/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.io.File;
import java.net.URL;
import java.util.TimerTask;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class DoAutomaticSave
extends TimerTask {
    static final String AUTOSAVE_EXTENSION = "autosave";
    private int changeState;
    private final boolean filesShouldBeDeletedAfterShutdown;
    private final MapModel model;
    private final int numberOfFiles;
    private final File singleBackupDirectory;
    static final String BACKUP_DIR = ".backup";

    public DoAutomaticSave(MapModel model, int numberOfTempFiles, boolean filesShouldBeDeletedAfterShutdown, boolean useSingleBackupDirectory, String singleBackupDirectory) {
        this.model = model;
        this.numberOfFiles = numberOfTempFiles > 0 ? numberOfTempFiles : 1;
        this.filesShouldBeDeletedAfterShutdown = filesShouldBeDeletedAfterShutdown;
        this.singleBackupDirectory = useSingleBackupDirectory ? new File(singleBackupDirectory) : null;
        this.changeState = model.getNumberOfChangesSinceLastSave();
    }

    public void run() {
        if (this.model.getNumberOfChangesSinceLastSave() == this.changeState) {
            return;
        }
        this.changeState = this.model.getNumberOfChangesSinceLastSave();
        if (this.changeState == 0) {
            return;
        }
        try {
            this.cancel();
            Controller.getCurrentController().getViewController().invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        ModeController currentModeController = Controller.getCurrentModeController();
                        if (!(currentModeController instanceof MModeController)) {
                            return;
                        }
                        MModeController modeController = (MModeController)currentModeController;
                        URL url = DoAutomaticSave.this.model.getURL();
                        File file = new File(url != null ? url.getFile() : DoAutomaticSave.this.model.getTitle() + ".mm");
                        File pathToStore = url == null ? new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), DoAutomaticSave.BACKUP_DIR) : (DoAutomaticSave.this.singleBackupDirectory != null ? DoAutomaticSave.this.singleBackupDirectory : new File(file.getParent(), DoAutomaticSave.BACKUP_DIR));
                        pathToStore.mkdirs();
                        File tempFile = MFileManager.renameBackupFiles(pathToStore, file, DoAutomaticSave.this.numberOfFiles, DoAutomaticSave.AUTOSAVE_EXTENSION);
                        if (tempFile == null) {
                            return;
                        }
                        if (DoAutomaticSave.this.filesShouldBeDeletedAfterShutdown) {
                            tempFile.deleteOnExit();
                        }
                        ((MFileManager)UrlManager.getController()).saveInternal((MMapModel)DoAutomaticSave.this.model, tempFile, true);
                        modeController.getController().getViewController().out(TextUtils.format("automatically_save_message", tempFile));
                    }
                    catch (Exception e) {
                        LogUtils.severe("Error in automatic MapModel.save(): ", e);
                    }
                }
            });
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }
}

