/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.FixedHTMLWriter;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;

public class SplitNode
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SplitNode() {
        super("SplitNode");
    }

    public void actionPerformed(ActionEvent e) {
        Collection<NodeModel> list = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        for (NodeModel next : list) {
            this.splitNode(next);
        }
    }

    private Element getParentElement(HTMLDocument doc) {
        Element htmlRoot = doc.getDefaultRootElement();
        Element parentCandidate = htmlRoot.getElement(htmlRoot.getElementCount() - 1);
        do {
            if (parentCandidate.getElementCount() <= 1) continue;
            return parentCandidate;
        } while (!(parentCandidate = parentCandidate.getElement(0)).isLeaf() && !parentCandidate.getName().equalsIgnoreCase("p-implied"));
        return null;
    }

    private void splitNode(NodeModel node) {
        if (node.isRoot()) {
            return;
        }
        String text = node.getText();
        String[] parts = this.splitNode(text);
        if (parts == null || parts.length == 1) {
            return;
        }
        ModeController c = Controller.getCurrentModeController();
        int firstPartNumber = 0;
        while (parts[firstPartNumber] == null) {
            ++firstPartNumber;
        }
        ((MTextController)TextController.getController()).setNodeText(node, parts[firstPartNumber]);
        NodeModel parent = node.getParentNode();
        int nodePosition = parent.getChildPosition(node) + 1;
        for (int i = parts.length - 1; i > firstPartNumber; --i) {
            MMapController mapController = (MMapController)c.getMapController();
            NodeModel lowerNode = mapController.addNewNode(parent, nodePosition, node.isLeft());
            String part = parts[i];
            if (part == null) continue;
            ((MTextController)TextController.getController()).setNodeText(lowerNode, part);
            MNodeStyleController nodeStyleController = (MNodeStyleController)NodeStyleController.getController();
            nodeStyleController.copyStyle(node, lowerNode);
            mapController.setFolded(lowerNode, !lowerNode.isFolded());
        }
    }

    private String[] splitNode(String text) {
        if (text.startsWith("<html>")) {
            String[] parts = null;
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                kit.read(buf, (Document)doc, 0);
                Element parent = this.getParentElement(doc);
                if (parent == null) {
                    return null;
                }
                int elementCount = parent.getElementCount();
                int notEmptyElementCount = 0;
                parts = new String[elementCount];
                for (int i = 0; i < elementCount; ++i) {
                    int end;
                    Element current = parent.getElement(i);
                    int start = current.getStartOffset();
                    String paragraphText = doc.getText(start, (end = current.getEndOffset()) - start).trim();
                    if (paragraphText.length() <= 0) continue;
                    StringWriter out = new StringWriter();
                    new FixedHTMLWriter((Writer)out, doc, start, end - start).write();
                    String string = out.toString();
                    if (!string.equals("")) {
                        parts[i] = string;
                        ++notEmptyElementCount;
                        continue;
                    }
                    parts[i] = null;
                }
                if (notEmptyElementCount <= 1) {
                    return null;
                }
            }
            catch (IOException e) {
                LogUtils.severe(e);
            }
            catch (BadLocationException e) {
                LogUtils.severe(e);
            }
            return parts;
        }
        return text.split("\n");
    }
}

