/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;

public class SortNodes
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;

    public SortNodes() {
        super("SortNodes");
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        Vector<NodeModel> sortVector = new Vector<NodeModel>();
        sortVector.addAll(node.getChildren());
        Collections.sort(sortVector, new NodeTextComparator());
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        int i = 0;
        for (NodeModel child : sortVector) {
            Controller.getCurrentModeController().getExtension(FreeNode.class).undoableDeactivateHook(child);
            mapController.moveNode(child, node, i++);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NodeTextComparator
    implements Comparator<Object> {
        private NodeTextComparator() {
        }

        @Override
        public int compare(Object pArg0, Object pArg1) {
            if (pArg0 instanceof NodeModel) {
                NodeModel node1 = (NodeModel)pArg0;
                if (pArg1 instanceof NodeModel) {
                    NodeModel node2 = (NodeModel)pArg1;
                    String nodeText1 = TextController.getController().getPlainTextContent(node1);
                    String nodeText2 = TextController.getController().getPlainTextContent(node2);
                    return nodeText1.compareToIgnoreCase(nodeText2);
                }
            }
            return 0;
        }
    }
}

