/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import com.lightdev.app.shtm.ActionBuilder;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.ScaledStyleSheet;
import com.lightdev.app.shtm.TextResources;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.components.BitmapImagePreview;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.FixedHTMLWriter;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.DeleteDetailsAction;
import org.freeplane.features.text.mindmapmode.EditAction;
import org.freeplane.features.text.mindmapmode.EditDetailsAction;
import org.freeplane.features.text.mindmapmode.EditLongAction;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.IEditorPaneListener;
import org.freeplane.features.text.mindmapmode.JoinNodesAction;
import org.freeplane.features.text.mindmapmode.SHTMLEditLinkAction;
import org.freeplane.features.text.mindmapmode.SHTMLSetLinkByFileChooserAction;
import org.freeplane.features.text.mindmapmode.SetImageByFileChooserAction;
import org.freeplane.features.text.mindmapmode.UsePlainTextAction;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.UrlManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTextController
extends TextController {
    private static final String PARSE_DATA_PROPERTY = "parse_data";
    public static final String NODE_TEXT = "NodeText";
    private static Pattern FORMATTING_PATTERN = null;
    private EditNodeBase mCurrentEditDialog = null;
    private final Collection<IEditorPaneListener> editorPaneListeners;
    private final EventBuffer eventQueue = new EventBuffer();
    private static final Pattern HTML_HEAD = Pattern.compile("\\s*<head>.*</head>", 32);
    private EditEventDispatcher keyEventDispatcher;
    private Boolean parseData;

    public static MTextController getController() {
        return (MTextController)TextController.getController();
    }

    public MTextController(ModeController modeController) {
        super(modeController);
        this.editorPaneListeners = new LinkedList<IEditorPaneListener>();
        this.createActions();
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (MTextController.PARSE_DATA_PROPERTY.equals(propertyName)) {
                    MTextController.this.parseData = null;
                    boolean dummy = MTextController.this.parseData();
                }
            }
        });
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new EditAction());
        modeController.addAction(new UsePlainTextAction());
        modeController.addAction(new JoinNodesAction());
        modeController.addAction(new EditLongAction());
        modeController.addAction(new SetImageByFileChooserAction());
        modeController.addAction(new EditDetailsAction(false));
        modeController.addAction(new EditDetailsAction(true));
        modeController.addAction(new DeleteDetailsAction());
    }

    private String[] getContent(String text, int pos) {
        if (pos <= 0) {
            return null;
        }
        String[] strings = new String[2];
        if (text.startsWith("<html>")) {
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                int secondStart;
                int firstStart;
                kit.read(buf, (Document)doc, 0);
                char[] firstText = doc.getText(0, pos).toCharArray();
                int firstLen = pos;
                for (firstStart = 0; firstStart < firstLen && firstText[firstStart] <= ' '; ++firstStart) {
                }
                while (firstStart < firstLen && firstText[firstLen - 1] <= ' ') {
                    --firstLen;
                }
                int secondLen = doc.getLength() - pos;
                if (secondLen <= 0) {
                    return null;
                }
                char[] secondText = doc.getText(pos, secondLen).toCharArray();
                for (secondStart = 0; secondStart < secondLen && secondText[secondStart] <= ' '; ++secondStart) {
                }
                while (secondStart < secondLen && secondText[secondLen - 1] <= ' ') {
                    --secondLen;
                }
                if (firstStart == firstLen || secondStart == secondLen) {
                    return null;
                }
                StringWriter out = new StringWriter();
                new FixedHTMLWriter((Writer)out, doc, firstStart, firstLen - firstStart).write();
                strings[0] = out.toString();
                out = new StringWriter();
                new FixedHTMLWriter((Writer)out, doc, pos + secondStart, secondLen - secondStart).write();
                strings[1] = out.toString();
                return strings;
            }
            catch (IOException e) {
                LogUtils.severe(e);
            }
            catch (BadLocationException e) {
                LogUtils.severe(e);
            }
        } else {
            if (pos >= text.length()) {
                return null;
            }
            strings[0] = text.substring(0, pos);
            strings[1] = text.substring(pos);
        }
        return strings;
    }

    private String addContent(String joinedContent, boolean isHtml, String nodeContent, boolean isHtmlNode) {
        if (isHtml) {
            String[] joinedContentParts = JoinNodesAction.BODY_END.split(joinedContent, -2);
            joinedContent = joinedContentParts[0];
            if (!isHtmlNode) {
                String[] end = JoinNodesAction.BODY_START.split(joinedContent, 2);
                if (end.length == 1) {
                    end[0] = "<html>";
                }
                nodeContent = end[0] + "<body><p>" + nodeContent + "</p>";
            }
        }
        if (isHtmlNode & !joinedContent.equals("")) {
            String[] nodeContentParts = JoinNodesAction.BODY_START.split(nodeContent, 2);
            if (nodeContentParts.length == 1) {
                nodeContent = nodeContent.substring(6);
                nodeContentParts[0] = "<html>";
            } else {
                nodeContent = nodeContentParts[1];
            }
            if (!isHtml) {
                joinedContent = nodeContentParts[0] + "<body><p>" + joinedContent + "</p>";
            }
        }
        if (joinedContent.equals("")) {
            return nodeContent;
        }
        joinedContent = joinedContent + '\n';
        joinedContent = joinedContent + nodeContent;
        return joinedContent;
    }

    public void joinNodes(List<NodeModel> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return;
        }
        NodeModel selectedNode = selectedNodes.get(0);
        NodeModel parentNode = selectedNode.getParentNode();
        for (NodeModel node : selectedNodes) {
            if (node.getParentNode() == parentNode) continue;
            UITools.errorMessage(TextUtils.getText("cannot_add_parent_diff_parents"));
            return;
        }
        String joinedContent = "";
        Controller controller = Controller.getCurrentController();
        boolean isHtml = false;
        LinkedHashSet<MindIcon> icons = new LinkedHashSet<MindIcon>();
        for (NodeModel node : selectedNodes) {
            String nodeContent = node.getText();
            icons.addAll(node.getIcons());
            boolean isHtmlNode = HtmlUtils.isHtmlNode(nodeContent);
            joinedContent = this.addContent(joinedContent, isHtml, nodeContent, isHtmlNode);
            if (node != selectedNode) {
                MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
                for (NodeModel child : node.getChildren().toArray(new NodeModel[0])) {
                    mapController.moveNode(child, selectedNode, selectedNode.getChildCount());
                }
                mapController.deleteNode(node);
            }
            isHtml = isHtml || isHtmlNode;
        }
        controller.getSelection().selectAsTheOnlyOneSelected(selectedNode);
        this.setNodeText(selectedNode, joinedContent);
        MIconController iconController = (MIconController)IconController.getController();
        iconController.removeAllIcons(selectedNode);
        for (MindIcon icon : icons) {
            iconController.addIcon(selectedNode, icon);
        }
    }

    public void setImageByFileChooser() {
        String uriString;
        boolean picturesAmongSelecteds = false;
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel node : modeController.getMapController().getSelectedNodes()) {
            String linkString;
            String lowerCase;
            URI link = NodeLinks.getLink(node);
            if (link == null || !(lowerCase = (linkString = link.toString()).toLowerCase()).endsWith(".png") && !lowerCase.endsWith(".jpg") && !lowerCase.endsWith(".jpeg") && !lowerCase.endsWith(".gif")) continue;
            picturesAmongSelecteds = true;
            String encodedLinkString = HtmlUtils.unicodeToHTMLUnicodeEntity(linkString);
            String strText = "<html><img src=\"" + encodedLinkString + "\">";
            ((MLinkController)LinkController.getController()).setLink(node, (URI)null, 0);
            this.setNodeText(node, strText);
        }
        if (picturesAmongSelecteds) {
            return;
        }
        Controller controller = modeController.getController();
        ViewController viewController = controller.getViewController();
        NodeModel selectedNode = modeController.getMapController().getSelectedNode();
        MapModel map = selectedNode.getMap();
        File file = map.getFile();
        if (file == null && LinkController.getLinkType() == 1) {
            JOptionPane.showMessageDialog(viewController.getContentPane(), TextUtils.getText("not_saved_for_image_error"), "Freeplane", 2);
            return;
        }
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("png");
        filter.addExtension("gif");
        filter.setDescription(TextUtils.getText("bitmaps"));
        UrlManager urlManager = modeController.getExtension(UrlManager.class);
        JFileChooser chooser = urlManager.getFileChooser(null, false);
        chooser.setFileFilter(filter);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setAccessory(new BitmapImagePreview(chooser));
        int returnVal = chooser.showOpenDialog(viewController.getContentPane());
        if (returnVal != 0) {
            return;
        }
        File input = chooser.getSelectedFile();
        URI uri = input.toURI();
        if (uri == null) {
            return;
        }
        if (!input.exists()) {
            uri = LinkController.toRelativeURI(map.getFile(), input, 1);
            if (uri == null || !"http".equals(uri.getScheme())) {
                UITools.errorMessage(TextUtils.format("file_not_found", input.toString()));
                return;
            }
        } else if (LinkController.getLinkType() != 0) {
            uri = LinkController.toLinkTypeDependantURI(map.getFile(), input);
        }
        if ((uriString = uri.toString()).startsWith("http:/")) {
            uriString = "http://" + uriString.substring("http:/".length());
        }
        String strText = "<html><img src=\"" + uriString + "\">";
        this.setNodeText(selectedNode, strText);
    }

    public void setGuessedNodeObject(NodeModel node, String newText) {
        if (HtmlUtils.isHtmlNode(newText)) {
            this.setNodeObject(node, newText);
        } else {
            Object guessedObject = this.guessObject(newText, NodeStyleModel.getNodeFormat(node));
            if (guessedObject instanceof IFormattedObject) {
                this.setNodeObject(node, ((IFormattedObject)guessedObject).getObject());
            } else {
                this.setNodeObject(node, newText);
            }
        }
    }

    public Object guessObject(Object text, String oldFormat) {
        if (this.parseData() && text instanceof String) {
            if (PatternFormat.getIdentityPatternFormat().getPattern().equals(oldFormat)) {
                return text;
            }
            Object parseResult = ScannerController.getController().parse((String)text);
            if (oldFormat != null) {
                Object formatted = FormatController.format(parseResult, oldFormat, null);
                return formatted == null ? text : formatted;
            }
            return parseResult;
        }
        return text;
    }

    @Override
    public boolean parseData() {
        if (this.parseData == null) {
            this.parseData = ResourceController.getResourceController().getBooleanProperty(PARSE_DATA_PROPERTY);
        }
        return this.parseData;
    }

    public Object guessObjectOrURI(Object object, String oldFormat) {
        Object guessedObject = this.guessObject(object, oldFormat);
        if (guessedObject == object && !(object instanceof URI) && this.matchUriPattern(object)) {
            try {
                return new URI((String)object);
            }
            catch (URISyntaxException e) {
                LogUtils.warn("URI regular expression does not match URI parser for " + object);
                return object;
            }
        }
        return guessedObject;
    }

    private boolean matchUriPattern(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        return TextUtils.matchUriPattern((String)object);
    }

    public void setNodeText(NodeModel node, String newText) {
        this.setNodeObject(node, newText);
    }

    public void setNodeObject(final NodeModel node, final Object newObject) {
        if (newObject == null) {
            this.setNodeObject(node, "");
            return;
        }
        final Object oldText = node.getUserObject();
        if (oldText.equals(newObject)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                if (!oldText.equals(newObject)) {
                    node.setUserObject(newObject);
                    Controller.getCurrentModeController().getMapController().nodeChanged(node, "node_text", oldText, newObject);
                }
            }

            public String getDescription() {
                return "setNodeText";
            }

            public void undo() {
                if (!oldText.equals(newObject)) {
                    node.setUserObject(oldText);
                    Controller.getCurrentModeController().getMapController().nodeChanged(node, "node_text", newObject, oldText);
                }
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void splitNode(NodeModel node, int caretPosition, String newText) {
        if (node.isRoot()) {
            return;
        }
        String futureText = newText != null ? newText : node.getText();
        String[] strings = this.getContent(futureText, caretPosition);
        if (strings == null) {
            return;
        }
        String newUpperContent = this.makePlainIfNoFormattingFound(strings[0]);
        String newLowerContent = this.makePlainIfNoFormattingFound(strings[1]);
        this.setNodeObject(node, newUpperContent);
        NodeModel parent = node.getParentNode();
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel lowerNode = ((MMapController)modeController.getMapController()).addNewNode(parent, parent.getChildPosition(node) + 1, node.isLeft());
        MNodeStyleController nodeStyleController = (MNodeStyleController)NodeStyleController.getController();
        nodeStyleController.copyStyle(node, lowerNode);
        this.setNodeObject(lowerNode, newLowerContent);
    }

    public boolean useRichTextInEditor(String key) {
        int showResult = OptionalDontShowMeAgainDialog.show("OptionPanel." + key, "edit.decision", key, 1);
        return showResult == 0;
    }

    public void editDetails(final NodeModel nodeModel, InputEvent e, boolean editLong) {
        boolean isNewNode;
        Controller controller = Controller.getCurrentController();
        this.stopEditing();
        Controller.getCurrentModeController().setBlocked(true);
        String text = DetailTextModel.getDetailTextText(nodeModel);
        boolean bl = isNewNode = text == null;
        if (isNewNode) {
            MTextController textController = MTextController.getController();
            textController.setDetails(nodeModel, "<html>");
            text = "";
        }
        EditNodeBase.IEditControl editControl = new EditNodeBase.IEditControl(){

            public void cancel() {
                if (isNewNode) {
                    String detailText = DetailTextModel.getDetailTextText(nodeModel);
                    MModeController modeController = (MModeController)Controller.getCurrentModeController();
                    if (detailText != null) {
                        modeController.undo();
                    }
                    modeController.resetRedo();
                }
                this.stop();
            }

            public void ok(String newText) {
                if (HtmlUtils.isEmpty(newText)) {
                    if (isNewNode) {
                        MModeController modeController = (MModeController)Controller.getCurrentModeController();
                        modeController.undo();
                        modeController.resetRedo();
                    } else {
                        MTextController.this.setDetailsHtmlText(nodeModel, null);
                    }
                } else {
                    MTextController.this.setDetailsHtmlText(nodeModel, newText);
                }
                this.stop();
            }

            public void split(String newText, int position) {
            }

            private void stop() {
                Controller.getCurrentModeController().setBlocked(false);
                MTextController.this.mCurrentEditDialog = null;
            }

            public boolean canSplit() {
                return false;
            }

            public EditNodeBase.EditedComponent getEditType() {
                return EditNodeBase.EditedComponent.DETAIL;
            }
        };
        this.mCurrentEditDialog = this.createEditor(nodeModel, editControl, text, false, editLong, true);
        RootPaneContainer frame = (RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(controller.getMapViewManager().getMapViewComponent()));
        this.mCurrentEditDialog.show(frame);
    }

    private void setDetailsHtmlText(NodeModel node, String newText) {
        if (newText != null) {
            String body = HTML_HEAD.matcher(newText).replaceFirst("");
            this.setDetails(node, body.replaceFirst("\\s+$", ""));
        } else {
            this.setDetails(node, null);
        }
    }

    public void setDetails(final NodeModel node, final String newText) {
        final String oldText = DetailTextModel.getDetailTextText(node);
        if (oldText == newText || null != oldText && oldText.equals(newText)) {
            return;
        }
        IActor actor = new IActor(){
            boolean hidden = false;

            public void act() {
                this.setText(newText);
            }

            public String getDescription() {
                return "setDetailText";
            }

            private void setText(String text) {
                boolean containsDetails;
                boolean bl = containsDetails = text != null && !text.equals("");
                if (containsDetails) {
                    DetailTextModel details = DetailTextModel.createDetailText(node);
                    details.setHtml(text);
                    details.setHidden(this.hidden);
                    node.addExtension(details);
                } else {
                    DetailTextModel details = node.getExtension(DetailTextModel.class);
                    if (null != details) {
                        this.hidden = details.isHidden();
                        node.removeExtension(DetailTextModel.class);
                    }
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node, DetailTextModel.class, oldText, text);
            }

            public void undo() {
                this.setText(oldText);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    @Override
    public void setDetailsHidden(final NodeModel node, final boolean isHidden) {
        this.stopEditing();
        DetailTextModel details = node.getExtension(DetailTextModel.class);
        if (details == null || details.isHidden() == isHidden) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                this.setHidden(isHidden);
            }

            public String getDescription() {
                return "setDetailsHidden";
            }

            private void setHidden(boolean isHidden2) {
                DetailTextModel details = DetailTextModel.createDetailText(node);
                details.setHidden(isHidden2);
                node.addExtension(details);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, "DETAILS_HIDDEN", !isHidden2, isHidden2);
            }

            public void undo() {
                this.setHidden(!isHidden);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    @Override
    public void setIsMinimized(final NodeModel node, final boolean state) {
        ShortenedTextModel details = node.getExtension(ShortenedTextModel.class);
        if (details == null && !state || details != null && state) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                this.setShortener(state);
            }

            public String getDescription() {
                return "setShortener";
            }

            private void setShortener(boolean state2) {
                if (state2) {
                    ShortenedTextModel details = ShortenedTextModel.createShortenedTextModel(node);
                    node.addExtension(details);
                } else {
                    node.removeExtension(ShortenedTextModel.class);
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node, "SHORTENER", !state2, state2);
            }

            public void undo() {
                this.setShortener(!state);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void edit(IEditHandler.FirstAction action, boolean editLong) {
        Controller controller = Controller.getCurrentController();
        NodeModel selectedNode = controller.getSelection().getSelected();
        if (selectedNode != null) {
            if (IEditHandler.FirstAction.EDIT_CURRENT.equals((Object)action)) {
                this.edit(selectedNode, selectedNode, false, false, editLong);
            } else if (!Controller.getCurrentModeController().isBlocked()) {
                int mode = IEditHandler.FirstAction.ADD_CHILD.equals((Object)action) ? 2 : 3;
                ((MMapController)Controller.getCurrentModeController().getMapController()).addNewNode(mode);
            }
        }
    }

    public boolean containsFormatting(String text) {
        if (FORMATTING_PATTERN == null) {
            FORMATTING_PATTERN = Pattern.compile("<(?!/|html>|head|body|p/?>|!--|style type=\"text/css\">)", 2);
        }
        Matcher matcher = FORMATTING_PATTERN.matcher(text);
        return matcher.find();
    }

    public void edit(final NodeModel nodeModel, final NodeModel prevSelectedModel, final boolean isNewNode, final boolean parentFolded, boolean editLong) {
        if (nodeModel == null || this.mCurrentEditDialog != null) {
            return;
        }
        final Controller controller = Controller.getCurrentController();
        if (controller.getMap() != nodeModel.getMap()) {
            return;
        }
        final IMapViewManager viewController = controller.getMapViewManager();
        Component map = viewController.getMapViewComponent();
        map.validate();
        map.invalidate();
        Component node = viewController.getComponent(nodeModel);
        if (node == null) {
            return;
        }
        node.requestFocus();
        this.stopEditing();
        if (isNewNode && !this.eventQueue.isActive() && !ResourceController.getResourceController().getBooleanProperty("display_inline_editor_for_all_new_nodes")) {
            this.keyEventDispatcher = new EditEventDispatcher(Controller.getCurrentModeController(), nodeModel, prevSelectedModel, isNewNode, parentFolded, editLong);
            this.keyEventDispatcher.install();
            return;
        }
        EditNodeBase.IEditControl editControl = new EditNodeBase.IEditControl(){

            public void cancel() {
                if (isNewNode && nodeModel.getMap().equals(controller.getMap())) {
                    if (nodeModel.getParent() != null) {
                        controller.getSelection().selectAsTheOnlyOneSelected(nodeModel);
                        MModeController modeController = (MModeController)Controller.getCurrentModeController();
                        modeController.undo();
                        modeController.resetRedo();
                    }
                    MapController mapController = Controller.getCurrentModeController().getMapController();
                    mapController.select(prevSelectedModel);
                    if (parentFolded) {
                        mapController.setFolded(prevSelectedModel, true);
                    }
                }
                this.stop();
            }

            private void stop() {
                Controller.getCurrentModeController().setBlocked(false);
                viewController.obtainFocusForSelected();
                MTextController.this.mCurrentEditDialog = null;
            }

            public void ok(String text) {
                String processedText = MTextController.this.makePlainIfNoFormattingFound(text);
                MTextController.this.setGuessedNodeObject(nodeModel, processedText);
                this.stop();
            }

            public void split(String newText, int position) {
                MTextController.this.splitNode(nodeModel, position, newText);
                viewController.obtainFocusForSelected();
                this.stop();
            }

            public boolean canSplit() {
                return true;
            }

            public EditNodeBase.EditedComponent getEditType() {
                return EditNodeBase.EditedComponent.TEXT;
            }
        };
        this.mCurrentEditDialog = this.createEditor(nodeModel, editControl, nodeModel.getText(), isNewNode, editLong, true);
        JFrame frame = controller.getViewController().getJFrame();
        this.mCurrentEditDialog.show(frame);
    }

    private EditNodeBase createEditor(NodeModel nodeModel, EditNodeBase.IEditControl editControl, String text, boolean isNewNode, boolean editLong, boolean internal) {
        Controller.getCurrentModeController().setBlocked(true);
        EditNodeBase base = this.getEditNodeBase(nodeModel, text, editControl, editLong);
        if (base != null || !internal) {
            return base;
        }
        IEditBaseCreator textFieldCreator = (IEditBaseCreator)((Object)Controller.getCurrentController().getMapViewManager());
        return textFieldCreator.createEditor(nodeModel, editControl, text, editLong);
    }

    public EditNodeBase getEditNodeBase(NodeModel nodeModel, String text, EditNodeBase.IEditControl editControl, boolean editLong) {
        List<IContentTransformer> textTransformers = this.getTextTransformers();
        for (IContentTransformer t : textTransformers) {
            EditNodeBase base;
            if (!(t instanceof IEditBaseCreator) || (base = ((IEditBaseCreator)((Object)t)).createEditor(nodeModel, editControl, text, editLong)) == null) continue;
            return base;
        }
        return null;
    }

    public void stopEditing() {
        if (this.keyEventDispatcher != null) {
            this.keyEventDispatcher.uninstall();
        }
        if (this.mCurrentEditDialog != null) {
            this.mCurrentEditDialog.closeEdit();
            this.modeController.forceNewTransaction();
            this.mCurrentEditDialog = null;
        }
    }

    public void addEditorPaneListener(IEditorPaneListener l) {
        this.editorPaneListeners.add(l);
    }

    public void removeEditorPaneListener(IEditorPaneListener l) {
        this.editorPaneListeners.remove(l);
    }

    private void fireEditorPaneCreated(JEditorPane editor, Object purpose) {
        for (IEditorPaneListener l : this.editorPaneListeners) {
            l.editorPaneCreated(editor, purpose);
        }
    }

    public SHTMLPanel createSHTMLPanel(String purpose) {
        SHTMLPanel.setResources((TextResources)new TextResources(){

            public String getString(String pKey) {
                if (pKey.equals("approximate_search_threshold")) {
                    return new Double(StringMatchingStrategy.APPROXIMATE_MATCHING_MINPROB).toString();
                }
                pKey = "simplyhtml." + pKey;
                String resourceString = ResourceController.getResourceController().getText(pKey, null);
                if (resourceString == null) {
                    resourceString = ResourceController.getResourceController().getProperty(pKey);
                }
                return resourceString;
            }
        });
        ScaledStyleSheet.FONT_SCALE_FACTOR = UITools.FONT_SCALE_FACTOR;
        SHTMLPanel.setActionBuilder((ActionBuilder)new ActionBuilder(){

            public void initActions(SHTMLPanel panel) {
                panel.addAction("editLink", (Action)new SHTMLEditLinkAction((SHTMLPanelImpl)panel));
                panel.addAction("setLinkByFileChooser", (Action)new SHTMLSetLinkByFileChooserAction((SHTMLPanelImpl)panel));
            }
        });
        SHTMLPanel shtmlPanel = SHTMLPanel.createSHTMLPanel();
        shtmlPanel.setOpenHyperlinkHandler(new ActionListener(){

            public void actionPerformed(ActionEvent pE) {
                try {
                    UrlManager.getController().loadURL(new URI(pE.getActionCommand()));
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        });
        JEditorPane editorPane = shtmlPanel.getEditorPane();
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
        this.fireEditorPaneCreated(editorPane, purpose);
        return shtmlPanel;
    }

    public JEditorPane createEditorPane(Object purpose) {
        JEditorPane editorPane = new JEditorPane(){

            protected void paintComponent(Graphics g) {
                try {
                    super.paintComponent(g);
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        };
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
        this.fireEditorPaneCreated(editorPane, purpose);
        return editorPane;
    }

    public EventBuffer getEventQueue() {
        return this.eventQueue;
    }

    private String makePlainIfNoFormattingFound(String text) {
        if (HtmlUtils.isHtmlNode(text) && !this.containsFormatting(text = HTML_HEAD.matcher(text).replaceFirst(""))) {
            text = HtmlUtils.htmlToPlain(text);
        }
        text = text.replaceFirst("\\s+$", "");
        return text;
    }

    private class EditEventDispatcher
    implements KeyEventDispatcher,
    INodeChangeListener,
    INodeSelectionListener {
        private final boolean editLong;
        private final boolean parentFolded;
        private final boolean isNewNode;
        private final NodeModel prevSelectedModel;
        private final NodeModel nodeModel;
        private final ModeController modeController;

        private EditEventDispatcher(ModeController modeController, NodeModel nodeModel, NodeModel prevSelectedModel, boolean isNewNode, boolean parentFolded, boolean editLong) {
            this.modeController = modeController;
            this.editLong = editLong;
            this.parentFolded = parentFolded;
            this.isNewNode = isNewNode;
            this.prevSelectedModel = prevSelectedModel;
            this.nodeModel = nodeModel;
        }

        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 402 || e.getID() == 400) {
                return false;
            }
            switch (e.getKeyCode()) {
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 65406: {
                    return false;
                }
            }
            this.uninstall();
            if (this.isMenuEvent(e)) {
                return false;
            }
            MTextController.this.eventQueue.activate(e);
            MTextController.this.edit(this.nodeModel, this.prevSelectedModel, this.isNewNode, this.parentFolded, this.editLong);
            return true;
        }

        private boolean isMenuEvent(KeyEvent e) {
            KeyStroke keyStroke;
            KeyStroke editLongKeyStroke;
            String editLongKeyStrokeProperty;
            return !this.editLong && (editLongKeyStrokeProperty = ResourceController.getResourceController().getProperty("acceleratorForMindMap/$EditLongAction$0", null)) != null && (editLongKeyStroke = UITools.getKeyStroke(editLongKeyStrokeProperty)) != null && editLongKeyStroke.equals(keyStroke = KeyStroke.getKeyStrokeForEvent(e));
        }

        public void uninstall() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            MapController mapController = this.modeController.getMapController();
            mapController.removeNodeChangeListener(this);
            mapController.removeNodeSelectionListener(this);
            MTextController.this.keyEventDispatcher = null;
        }

        public void install() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            MapController mapController = this.modeController.getMapController();
            mapController.addNodeChangeListener(this);
            mapController.addNodeSelectionListener(this);
        }

        public void onDeselect(NodeModel node) {
            this.uninstall();
        }

        public void onSelect(NodeModel node) {
            this.uninstall();
        }

        public void nodeChanged(NodeChangeEvent event) {
            this.uninstall();
        }
    }
}

