/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPrefsChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.FreeplaneToSHTMLPropertyChangeAdapter;
import org.freeplane.features.text.mindmapmode.MTextController;

public class EditNodeWYSIWYG
extends EditNodeBase {
    private static final Dimension PREFERRED_SIZE = new Dimension(600, 400);
    private String title;
    private Font font;
    private Color textColor = Color.BLACK;
    private Dimension preferredSize = PREFERRED_SIZE;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String purpose) {
        this.title = purpose;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public EditNodeWYSIWYG(NodeModel node, String text, EditNodeBase.IEditControl editControl, boolean enableSplit) {
        super(node, text, editControl);
    }

    public void show(RootPaneContainer frame) {
        try {
            HTMLDialog htmlEditorWindow = this.createHtmlEditor(frame);
            htmlEditorWindow.setBase(this);
            String titleText = TextUtils.getText(this.title);
            htmlEditorWindow.getDialog().setTitle(titleText);
            htmlEditorWindow.setSplitEnabled(this.getEditControl().canSplit());
            SHTMLPanel htmlEditorPanel = htmlEditorWindow.getHtmlEditorPanel();
            StringBuilder ruleBuilder = new StringBuilder(100);
            ruleBuilder.append("body {");
            if (this.font != null) {
                ruleBuilder.append("font-family: ").append(this.font.getFamily()).append(";");
                int fontSize = Math.round((float)this.font.getSize() / UITools.FONT_SCALE_FACTOR);
                ruleBuilder.append("font-size: ").append(fontSize).append("pt;");
                if (this.font.isItalic()) {
                    ruleBuilder.append("font-style: italic; ");
                }
                if (this.font.isBold()) {
                    ruleBuilder.append("font-weight: bold; ");
                }
            }
            if (this.textColor != null) {
                ruleBuilder.append("color: ").append(ColorUtils.colorToString(this.textColor)).append(";");
            }
            Color bgColor = this.getBackground();
            ruleBuilder.append("background-color: ").append(ColorUtils.colorToString(bgColor)).append(";");
            ruleBuilder.append("}\n");
            ruleBuilder.append("p {margin-top:0;}\n");
            HTMLDocument document = htmlEditorPanel.getDocument();
            JEditorPane editorPane = htmlEditorPanel.getEditorPane();
            if (this.textColor != null) {
                editorPane.setForeground(this.textColor);
                editorPane.setCaretColor(this.textColor);
            }
            StyleSheet styleSheet = document.getStyleSheet();
            styleSheet.removeStyle("p");
            styleSheet.removeStyle("body");
            styleSheet.addRule(ruleBuilder.toString());
            URL url = this.node.getMap().getURL();
            if (url != null) {
                document.setBase(url);
            } else {
                document.setBase(new URL("file: "));
            }
            htmlEditorPanel.setContentPanePreferredSize(this.preferredSize);
            htmlEditorWindow.getDialog().pack();
            if (ResourceController.getResourceController().getBooleanProperty("el__position_window_below_node")) {
                UITools.setDialogLocationUnder(htmlEditorWindow.getDialog(), this.node);
            } else {
                UITools.setDialogLocationRelativeTo(htmlEditorWindow.getDialog(), this.node);
            }
            String content = this.text;
            if (!HtmlUtils.isHtmlNode(content)) {
                content = HtmlUtils.plainToHTML(content);
            }
            htmlEditorPanel.setCurrentDocumentContent(content);
            KeyEvent firstKeyEvent = MTextController.getController().getEventQueue().getFirstEvent();
            JEditorPane currentPane = htmlEditorPanel.getEditorPane();
            if (currentPane == htmlEditorPanel.getMostRecentFocusOwner()) {
                this.redispatchKeyEvents(currentPane, firstKeyEvent);
                if (firstKeyEvent == null) {
                    editorPane.setCaretPosition(htmlEditorPanel.getDocument().getLength());
                }
            } else {
                EventBuffer keyEventDispatcher = MTextController.getController().getEventQueue();
                keyEventDispatcher.deactivate();
            }
            htmlEditorPanel.getMostRecentFocusOwner().requestFocus();
            htmlEditorWindow.show();
        }
        catch (Exception ex) {
            LogUtils.severe("Loading of WYSIWYG HTML editor failed. Use the other editors instead.", ex);
        }
    }

    public HTMLDialog createHtmlEditor(RootPaneContainer frame) throws Exception {
        JRootPane rootPane = frame.getRootPane();
        HTMLDialog htmlEditorWindow = (HTMLDialog)rootPane.getClientProperty(HTMLDialog.class);
        if (htmlEditorWindow == null) {
            htmlEditorWindow = new HTMLDialog(this, "", "", frame);
            rootPane.putClientProperty(HTMLDialog.class, htmlEditorWindow);
            ResourceController.getResourceController().addPropertyChangeListener(new FreeplaneToSHTMLPropertyChangeAdapter((SHTMLPrefsChangeListener)htmlEditorWindow.getHtmlEditorPanel()));
        }
        return htmlEditorWindow;
    }

    private static class HTMLDialog
    extends EditNodeBase.EditDialog {
        private SHTMLPanel htmlEditorPanel;
        private JButton splitButton;

        HTMLDialog(EditNodeBase base, String title, String purpose, RootPaneContainer frame) throws Exception {
            super(base, title, frame);
            this.createEditorPanel(purpose);
            this.getContentPane().add((Component)this.htmlEditorPanel, "Center");
            UITools.addEscapeActionToDialog(this.getDialog(), new EditNodeBase.EditDialog.CancelAction());
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            this.splitButton = new JButton();
            MenuBuilder.setLabelAndMnemonic(okButton, TextUtils.getRawText("ok"));
            MenuBuilder.setLabelAndMnemonic(cancelButton, TextUtils.getRawText("cancel"));
            MenuBuilder.setLabelAndMnemonic(this.splitButton, TextUtils.getRawText("split"));
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLDialog.this.submit();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLDialog.this.cancel();
                }
            });
            this.splitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLDialog.this.split();
                }
            });
            UITools.addKeyActionToDialog(this.getDialog(), new EditNodeBase.EditDialog.SubmitAction(), "alt ENTER", "submit");
            JPanel buttonPane = new JPanel();
            buttonPane.add(okButton);
            buttonPane.add(cancelButton);
            buttonPane.add(this.splitButton);
            buttonPane.setMaximumSize(new Dimension(1000, 20));
            if (ResourceController.getResourceController().getBooleanProperty("el__buttons_above")) {
                this.getContentPane().add((Component)buttonPane, "North");
            } else {
                this.getContentPane().add((Component)buttonPane, "South");
            }
        }

        protected void cancel() {
            super.cancel();
            StyleSheet styleSheet = this.htmlEditorPanel.getDocument().getStyleSheet();
            styleSheet.removeStyle("p");
            styleSheet.removeStyle("BODY");
            this.getBase().getEditControl().cancel();
        }

        private SHTMLPanel createEditorPanel(String purpose) throws Exception {
            if (this.htmlEditorPanel == null) {
                this.htmlEditorPanel = MTextController.getController().createSHTMLPanel(purpose);
                SHTMLEditorPane editorPane = (SHTMLEditorPane)this.htmlEditorPanel.getEditorPane();
                SpellCheckerController spellCheckerController = SpellCheckerController.getController();
                spellCheckerController.enableAutoSpell((JTextComponent)editorPane, true);
                spellCheckerController.addSpellCheckerMenu(editorPane.getPopup());
                spellCheckerController.enableShortKey((JTextComponent)editorPane, true);
            }
            return this.htmlEditorPanel;
        }

        public SHTMLPanel getHtmlEditorPanel() {
            return this.htmlEditorPanel;
        }

        public Component getMostRecentFocusOwner() {
            if (this.getDialog().isFocused()) {
                return this.getFocusOwner();
            }
            return this.htmlEditorPanel.getMostRecentFocusOwner();
        }

        protected boolean isChanged() {
            return this.htmlEditorPanel.needsSaving();
        }

        protected void split() {
            super.split();
            StyleSheet styleSheet = this.htmlEditorPanel.getDocument().getStyleSheet();
            styleSheet.removeStyle("p");
            styleSheet.removeStyle("body");
            this.getBase().getEditControl().split(HtmlUtils.unescapeHTMLUnicodeEntity(this.htmlEditorPanel.getDocumentText()), this.htmlEditorPanel.getCaretPosition());
        }

        protected void submit() {
            super.submit();
            this.htmlEditorPanel.getDocument().getStyleSheet().removeStyle("p");
            this.htmlEditorPanel.getDocument().getStyleSheet().removeStyle("body");
            if (this.htmlEditorPanel.needsSaving()) {
                this.getBase().getEditControl().ok(HtmlUtils.unescapeHTMLUnicodeEntity(this.htmlEditorPanel.getDocumentText()));
            } else {
                this.getBase().getEditControl().cancel();
            }
        }

        public void setSplitEnabled(boolean enableSplit) {
            this.splitButton.setEnabled(enableSplit);
            this.splitButton.setVisible(enableSplit);
        }
    }
}

