/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.NamedObject;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.FontProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.NextColumnProperty;
import org.freeplane.core.resources.components.NextLineProperty;
import org.freeplane.core.resources.components.NumberProperty;
import org.freeplane.core.resources.components.SeparatorProperty;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.edge.mindmapmode.AutomaticEdgeColorHook;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.AMapChangeListenerAdapter;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.AutomaticLayout;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.mindmapmode.EditablePatternComboProperty;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEditorPanel
extends JPanel {
    private static final NamedObject AUTOMATIC_LAYOUT_DISABLED = new NamedObject("automatic_layout_disabled");
    private static final String CLOUD_COLOR = "cloudcolor";
    private static final String EDGE_COLOR = "edgecolor";
    private static final String EDGE_STYLE = "edgestyle";
    private static final String CLOUD_SHAPE = "cloudshape";
    private static final String[] EDGE_STYLES = StyleEditorPanel.initializeEdgeStyles();
    private static final String[] CLOUD_SHAPES = StyleEditorPanel.initializeCloudShapes();
    private static final String EDGE_WIDTH = "edgewidth";
    private static final String NODE_BACKGROUND_COLOR = "nodebackgroundcolor";
    private static final String NODE_COLOR = "nodecolor";
    private static final String NODE_FONT_BOLD = "nodefontbold";
    private static final String NODE_FONT_ITALIC = "nodefontitalic";
    private static final String NODE_FONT_HYPERLINK = "nodefonthyperlink";
    private static final String NODE_FONT_NAME = "nodefontname";
    private static final String NODE_FONT_SIZE = "nodefontsize";
    private static final String NODE_NUMBERING = "nodenumbering";
    private static final String NODE_SHAPE = "nodeshape";
    private static final String NODE_TEXT_COLOR = "standardnodetextcolor";
    private static final String NODE_FORMAT = "nodeformat";
    private static final long serialVersionUID = 1L;
    private static final String SET_RESOURCE = "set_property_text";
    private static final String MAX_TEXT_WIDTH = "max_node_width";
    private static final String MIN_NODE_WIDTH = "min_node_width";
    private boolean internalChange;
    private ColorProperty mCloudColor;
    private ComboProperty mCloudShape;
    private List<IPropertyControl> mControls;
    private ColorProperty mEdgeColor;
    private ComboProperty mEdgeStyle;
    private NumberProperty mEdgeWidth;
    private ColorProperty mNodeBackgroundColor;
    private ColorProperty mNodeColor;
    private BooleanProperty mNodeFontBold;
    private BooleanProperty mNodeFontItalic;
    private BooleanProperty mNodeFontHyperlink;
    private FontProperty mNodeFontName;
    private ComboProperty mNodeFontSize;
    private BooleanProperty mNodeNumbering;
    private ComboProperty mNodeShape;
    private EditablePatternComboProperty mNodeFormat;
    private NumberProperty mMaxNodeWidth;
    private NumberProperty mMinNodeWidth;
    private BooleanProperty mSetCloud;
    private BooleanProperty mSetEdgeColor;
    private BooleanProperty mSetEdgeStyle;
    private BooleanProperty mSetEdgeWidth;
    private BooleanProperty mSetNodeBackgroundColor;
    private BooleanProperty mSetNodeColor;
    private BooleanProperty mSetNodeFontBold;
    private BooleanProperty mSetNodeFontItalic;
    private BooleanProperty mSetNodeFontHyperlink;
    private BooleanProperty mSetNodeFontName;
    private BooleanProperty mSetNodeFontSize;
    private BooleanProperty mSetNodeNumbering;
    private BooleanProperty mSetNodeShape;
    private BooleanProperty mSetNodeFormat;
    private BooleanProperty mSetStyle;
    private BooleanProperty mSetMaxNodeWidth;
    private BooleanProperty mSetMinNodeWidth;
    private final boolean addStyleBox;
    private final MUIFactory uiFactory;
    private final ModeController modeController;
    private JButton mNodeStyleButton;
    private JButton mMapStyleButton;
    private JComboBox mAutomaticLayoutComboBox;
    private JCheckBox mAutomaticEdgeColorCheckBox;
    private Container mStyleBox;

    private static String[] initializeEdgeStyles() {
        EdgeStyle[] enumConstants = (EdgeStyle[])EdgeStyle.class.getEnumConstants();
        String[] strings = new String[enumConstants.length - 1];
        for (int i = 0; i < enumConstants.length - 1; ++i) {
            strings[i] = enumConstants[i].toString();
        }
        return strings;
    }

    private static String[] initializeCloudShapes() {
        CloudModel.Shape[] enumConstants = (CloudModel.Shape[])CloudModel.Shape.class.getEnumConstants();
        String[] strings = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            strings[i] = enumConstants[i].toString();
        }
        return strings;
    }

    public StyleEditorPanel(ModeController modeController, MUIFactory uiFactory, boolean addStyleBox) throws HeadlessException {
        this.modeController = modeController;
        this.addStyleBox = addStyleBox;
        this.uiFactory = uiFactory;
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (StyleEditorPanel.this.isDisplayable()) {
                    StyleEditorPanel.this.removeHierarchyListener(this);
                    StyleEditorPanel.this.init();
                }
            }
        });
    }

    private void addBgColorControl(List<IPropertyControl> controls) {
        this.mSetNodeBackgroundColor = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeBackgroundColor);
        this.mNodeBackgroundColor = new ColorProperty(NODE_BACKGROUND_COLOR, ResourceController.getResourceController().getDefaultProperty(NODE_BACKGROUND_COLOR));
        controls.add(this.mNodeBackgroundColor);
        BgColorChangeListener listener = new BgColorChangeListener(this.mSetNodeBackgroundColor, this.mNodeBackgroundColor);
        this.mSetNodeBackgroundColor.addPropertyChangeListener(listener);
        this.mNodeBackgroundColor.addPropertyChangeListener(listener);
        this.mNodeBackgroundColor.fireOnMouseClick();
    }

    private void addFormatControl(List<IPropertyControl> controls) {
        this.mSetNodeFormat = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeFormat);
        this.mNodeFormat = new EditablePatternComboProperty(NODE_FORMAT, PatternFormat.getIdentityPatternFormat(), FormatController.getController().getAllFormats());
        controls.add(this.mNodeFormat);
        NodeFormatChangeListener listener = new NodeFormatChangeListener(this.mSetNodeFormat, this.mNodeFormat);
        this.mSetNodeFormat.addPropertyChangeListener(listener);
        this.mNodeFormat.addPropertyChangeListener(listener);
        this.mNodeFormat.fireOnMouseClick();
    }

    private void addNodeNumberingControl(List<IPropertyControl> controls) {
        this.mSetNodeNumbering = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeNumbering);
        this.mNodeNumbering = new BooleanProperty(NODE_NUMBERING);
        controls.add(this.mNodeNumbering);
        NodeNumberingChangeListener listener = new NodeNumberingChangeListener(this.mSetNodeNumbering, this.mNodeNumbering);
        this.mSetNodeNumbering.addPropertyChangeListener(listener);
        this.mNodeNumbering.addPropertyChangeListener(listener);
        this.mNodeNumbering.fireOnMouseClick();
    }

    private void addCloudColorControl(List<IPropertyControl> controls) {
        this.mSetCloud = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetCloud);
        this.mCloudColor = new ColorProperty(CLOUD_COLOR, ResourceController.getResourceController().getDefaultProperty("standardcloudcolor"));
        controls.add(this.mCloudColor);
        CloudColorChangeListener listener = new CloudColorChangeListener(this.mSetCloud, this.mCloudColor);
        this.mSetCloud.addPropertyChangeListener(listener);
        this.mCloudColor.addPropertyChangeListener(listener);
        this.mCloudColor.fireOnMouseClick();
    }

    private void addColorControl(List<IPropertyControl> controls) {
        this.mSetNodeColor = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeColor);
        this.mNodeColor = new ColorProperty(NODE_COLOR, ResourceController.getResourceController().getDefaultProperty(NODE_TEXT_COLOR));
        controls.add(this.mNodeColor);
        ColorChangeListener listener = new ColorChangeListener(this.mSetNodeColor, this.mNodeColor);
        this.mSetNodeColor.addPropertyChangeListener(listener);
        this.mNodeColor.addPropertyChangeListener(listener);
        this.mNodeColor.fireOnMouseClick();
    }

    private void addEdgeColorControl(List<IPropertyControl> controls) {
        this.mSetEdgeColor = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetEdgeColor);
        this.mEdgeColor = new ColorProperty(EDGE_COLOR, ColorUtils.colorToString(EdgeController.STANDARD_EDGE_COLOR));
        controls.add(this.mEdgeColor);
        EdgeColorChangeListener listener = new EdgeColorChangeListener(this.mSetEdgeColor, this.mEdgeColor);
        this.mSetEdgeColor.addPropertyChangeListener(listener);
        this.mEdgeColor.addPropertyChangeListener(listener);
        this.mEdgeColor.fireOnMouseClick();
    }

    private void addEdgeStyleControl(List<IPropertyControl> controls) {
        this.mSetEdgeStyle = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetEdgeStyle);
        this.mEdgeStyle = new ComboProperty(EDGE_STYLE, EDGE_STYLES);
        controls.add(this.mEdgeStyle);
        EdgeStyleChangeListener listener = new EdgeStyleChangeListener(this.mSetEdgeStyle, this.mEdgeStyle);
        this.mSetEdgeStyle.addPropertyChangeListener(listener);
        this.mEdgeStyle.addPropertyChangeListener(listener);
        this.mEdgeStyle.fireOnMouseClick();
    }

    private void addCloudShapeControl(List<IPropertyControl> controls) {
        this.mCloudShape = new ComboProperty(CLOUD_SHAPE, CLOUD_SHAPES);
        controls.add(this.mCloudShape);
        CloudShapeChangeListener listener = new CloudShapeChangeListener(this.mSetCloud, this.mCloudShape);
        this.mSetCloud.addPropertyChangeListener(listener);
        this.mCloudShape.addPropertyChangeListener(listener);
        this.mCloudShape.fireOnMouseClick();
    }

    private void addEdgeWidthControl(List<IPropertyControl> controls) {
        this.mSetEdgeWidth = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetEdgeWidth);
        this.mEdgeWidth = new NumberProperty(EDGE_WIDTH, 0, 100, 1);
        controls.add(this.mEdgeWidth);
        EdgeWidthChangeListener listener = new EdgeWidthChangeListener(this.mSetEdgeWidth, this.mEdgeWidth);
        this.mSetEdgeWidth.addPropertyChangeListener(listener);
        this.mEdgeWidth.addPropertyChangeListener(listener);
        this.mEdgeWidth.fireOnMouseClick();
    }

    private void addMaxNodeWidthControl(List<IPropertyControl> controls) {
        this.mSetMaxNodeWidth = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetMaxNodeWidth);
        this.mMaxNodeWidth = new NumberProperty(MAX_TEXT_WIDTH, 1, Integer.MAX_VALUE, 1);
        controls.add(this.mMaxNodeWidth);
        MaxNodeWidthChangeListener listener = new MaxNodeWidthChangeListener(this.mSetMaxNodeWidth, this.mMaxNodeWidth);
        this.mSetMaxNodeWidth.addPropertyChangeListener(listener);
        this.mMaxNodeWidth.addPropertyChangeListener(listener);
        this.mMaxNodeWidth.fireOnMouseClick();
    }

    private void addMinNodeWidthControl(List<IPropertyControl> controls) {
        this.mSetMinNodeWidth = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetMinNodeWidth);
        this.mMinNodeWidth = new NumberProperty(MIN_NODE_WIDTH, 1, Integer.MAX_VALUE, 1);
        controls.add(this.mMinNodeWidth);
        MinNodeWidthChangeListener listener = new MinNodeWidthChangeListener(this.mSetMinNodeWidth, this.mMinNodeWidth);
        this.mSetMinNodeWidth.addPropertyChangeListener(listener);
        this.mMinNodeWidth.addPropertyChangeListener(listener);
        this.mMinNodeWidth.fireOnMouseClick();
    }

    private void addFontBoldControl(List<IPropertyControl> controls) {
        this.mSetNodeFontBold = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeFontBold);
        this.mNodeFontBold = new BooleanProperty(NODE_FONT_BOLD);
        controls.add(this.mNodeFontBold);
        FontBoldChangeListener listener = new FontBoldChangeListener(this.mSetNodeFontBold, this.mNodeFontBold);
        this.mSetNodeFontBold.addPropertyChangeListener(listener);
        this.mNodeFontBold.addPropertyChangeListener(listener);
        this.mNodeFontBold.fireOnMouseClick();
    }

    private void addFontItalicControl(List<IPropertyControl> controls) {
        this.mSetNodeFontItalic = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeFontItalic);
        this.mNodeFontItalic = new BooleanProperty(NODE_FONT_ITALIC);
        controls.add(this.mNodeFontItalic);
        FontItalicChangeListener listener = new FontItalicChangeListener(this.mSetNodeFontItalic, this.mNodeFontItalic);
        this.mSetNodeFontItalic.addPropertyChangeListener(listener);
        this.mNodeFontItalic.addPropertyChangeListener(listener);
        this.mNodeFontItalic.fireOnMouseClick();
    }

    private void addFontHyperlinkControl(List<IPropertyControl> controls) {
        this.mSetNodeFontHyperlink = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeFontHyperlink);
        this.mNodeFontHyperlink = new BooleanProperty(NODE_FONT_HYPERLINK);
        controls.add(this.mNodeFontHyperlink);
        FontHyperlinkChangeListener listener = new FontHyperlinkChangeListener(this.mSetNodeFontHyperlink, this.mNodeFontHyperlink);
        this.mSetNodeFontHyperlink.addPropertyChangeListener(listener);
        this.mNodeFontHyperlink.addPropertyChangeListener(listener);
        this.mNodeFontHyperlink.fireOnMouseClick();
    }

    private void addFontNameControl(List<IPropertyControl> controls) {
        this.mSetNodeFontName = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeFontName);
        this.mNodeFontName = new FontProperty(NODE_FONT_NAME);
        controls.add(this.mNodeFontName);
        FontNameChangeListener listener = new FontNameChangeListener(this.mSetNodeFontName, this.mNodeFontName);
        this.mSetNodeFontName.addPropertyChangeListener(listener);
        this.mNodeFontName.addPropertyChangeListener(listener);
        this.mNodeFontName.fireOnMouseClick();
    }

    private void addFontSizeControl(List<IPropertyControl> controls) {
        this.mSetNodeFontSize = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeFontSize);
        ArrayList<String> sizesVector = new ArrayList<String>(Arrays.asList(MUIFactory.FONT_SIZES));
        this.mNodeFontSize = new ComboProperty(NODE_FONT_SIZE, sizesVector, sizesVector);
        this.mNodeFontSize.setEditable(true);
        controls.add(this.mNodeFontSize);
        FontSizeChangeListener listener = new FontSizeChangeListener(this.mSetNodeFontSize, this.mNodeFontSize);
        this.mSetNodeFontSize.addPropertyChangeListener(listener);
        this.mNodeFontSize.addPropertyChangeListener(listener);
        this.mNodeFontSize.fireOnMouseClick();
    }

    private void addNodeShapeControl(List<IPropertyControl> controls) {
        this.mSetNodeShape = new BooleanProperty(SET_RESOURCE);
        controls.add(this.mSetNodeShape);
        this.mNodeShape = new ComboProperty(NODE_SHAPE, new String[]{"fork", "bubble", "as_parent", "combined"});
        controls.add(this.mNodeShape);
        NodeShapeChangeListener listener = new NodeShapeChangeListener(this.mSetNodeShape, this.mNodeShape);
        this.mSetNodeShape.addPropertyChangeListener(listener);
        this.mNodeShape.addPropertyChangeListener(listener);
        this.mNodeShape.fireOnMouseClick();
    }

    private List<IPropertyControl> getControls() {
        ArrayList<IPropertyControl> controls = new ArrayList<IPropertyControl>();
        controls.add(new SeparatorProperty("OptionPanel.separator.NodeColors"));
        this.addColorControl(controls);
        this.addBgColorControl(controls);
        controls.add(new SeparatorProperty("OptionPanel.separator.NodeText"));
        this.addFormatControl(controls);
        this.addNodeNumberingControl(controls);
        controls.add(new SeparatorProperty("OptionPanel.separator.NodeShape"));
        this.addNodeShapeControl(controls);
        this.addMinNodeWidthControl(controls);
        this.addMaxNodeWidthControl(controls);
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("OptionPanel.separator.NodeFont"));
        this.addFontNameControl(controls);
        this.addFontSizeControl(controls);
        this.addFontBoldControl(controls);
        this.addFontItalicControl(controls);
        this.addFontHyperlinkControl(controls);
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("OptionPanel.separator.EdgeControls"));
        this.addEdgeWidthControl(controls);
        this.addEdgeStyleControl(controls);
        this.addEdgeColorControl(controls);
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("OptionPanel.separator.CloudControls"));
        this.addCloudColorControl(controls);
        controls.add(new NextLineProperty());
        controls.add(new NextColumnProperty(2));
        this.addCloudShapeControl(controls);
        return controls;
    }

    private void init() {
        if (this.mControls != null) {
            return;
        }
        String form = "right:max(20dlu;p), 2dlu, p, 1dlu,right:max(20dlu;p), 4dlu, 80dlu, 7dlu";
        FormLayout rightLayout = new FormLayout("right:max(20dlu;p), 2dlu, p, 1dlu,right:max(20dlu;p), 4dlu, 80dlu, 7dlu", "");
        DefaultFormBuilder rightBuilder = new DefaultFormBuilder(rightLayout);
        rightBuilder.setBorder(Borders.DLU2_BORDER);
        rightBuilder.appendSeparator(TextUtils.getText("OptionPanel.separator.NodeStyle"));
        if (this.addStyleBox) {
            this.addAutomaticLayout(rightBuilder);
            this.addStyleBox(rightBuilder);
        }
        this.mNodeStyleButton = this.addStyleButton(rightBuilder, "actual_node_styles", this.modeController.getAction("ManageNodeConditionalStylesAction"));
        if (this.addStyleBox) {
            this.mMapStyleButton = this.addStyleButton(rightBuilder, "actual_map_styles", this.modeController.getAction("ManageConditionalStylesAction"));
        }
        this.mControls = this.getControls();
        for (IPropertyControl control : this.mControls) {
            control.layout(rightBuilder);
        }
        this.add((Component)rightBuilder.getPanel(), "Center");
        this.addListeners();
        this.setFont(this, 10.0f);
    }

    private JButton addStyleButton(DefaultFormBuilder rightBuilder, String label, AFreeplaneAction action) {
        JButton button = new JButton(){
            private static final long serialVersionUID = 1L;
            {
                this.setUI(BasicButtonUI.createUI(this));
            }
        };
        button.addActionListener(action);
        button.setHorizontalAlignment(2);
        String labelText = TextUtils.getText(label);
        UITools.addTitledBorder(button, labelText, 10.0f);
        rightBuilder.append((Component)button, rightBuilder.getColumnCount());
        rightBuilder.nextLine();
        return button;
    }

    private void addStyleBox(DefaultFormBuilder rightBuilder) {
        this.mStyleBox = this.uiFactory.createStyleBox();
        this.mSetStyle = new BooleanProperty(SET_RESOURCE);
        StyleChangeListener listener = new StyleChangeListener();
        this.mSetStyle.addPropertyChangeListener(listener);
        this.mSetStyle.layout(rightBuilder);
        rightBuilder.append((Component)new JLabel(TextUtils.getText("style")));
        rightBuilder.append((Component)this.mStyleBox);
        rightBuilder.nextLine();
    }

    private void addAutomaticLayout(DefaultFormBuilder rightBuilder) {
        if (this.mAutomaticLayoutComboBox == null) {
            NamedObject[] automaticLayoutTypes = NamedObject.fromEnum(AutomaticLayout.class);
            this.mAutomaticLayoutComboBox = new JComboBox<NamedObject>(automaticLayoutTypes);
            DefaultComboBoxModel automaticLayoutComboBoxModel = (DefaultComboBoxModel)this.mAutomaticLayoutComboBox.getModel();
            automaticLayoutComboBoxModel.addElement(AUTOMATIC_LAYOUT_DISABLED);
            automaticLayoutComboBoxModel.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
            this.mAutomaticLayoutComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (StyleEditorPanel.this.internalChange) {
                        return;
                    }
                    ModeController modeController = Controller.getCurrentModeController();
                    AutomaticLayoutController al = modeController.getExtension(AutomaticLayoutController.class);
                    NamedObject selectedItem = (NamedObject)StyleEditorPanel.this.mAutomaticLayoutComboBox.getSelectedItem();
                    al.undoableDeactivateHook(Controller.getCurrentController().getMap().getRootNode());
                    if (!selectedItem.equals(AUTOMATIC_LAYOUT_DISABLED)) {
                        al.undoableActivateHook(Controller.getCurrentController().getMap().getRootNode(), (AutomaticLayout)selectedItem.getObject());
                    }
                }
            });
        }
        String label = TextUtils.getText("AutomaticLayoutAction.text");
        rightBuilder.append((Component)new JLabel(label), 5);
        rightBuilder.append((Component)this.mAutomaticLayoutComboBox);
        rightBuilder.nextLine();
        if (this.mAutomaticEdgeColorCheckBox == null) {
            this.mAutomaticEdgeColorCheckBox = new JCheckBox();
            this.mAutomaticEdgeColorCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ModeController modeController = Controller.getCurrentModeController();
                    AutomaticEdgeColorHook al = modeController.getExtension(AutomaticEdgeColorHook.class);
                    al.undoableToggleHook(Controller.getCurrentController().getMap().getRootNode());
                }
            });
        }
        label = TextUtils.getText("AutomaticEdgeColorHookAction.text");
        rightBuilder.append((Component)new JLabel(label), 5);
        rightBuilder.append((Component)this.mAutomaticEdgeColorCheckBox);
        rightBuilder.nextLine();
    }

    private void setFont(Container c, float size) {
        c.setFont(c.getFont().deriveFont(size));
        for (int i = 0; i < c.getComponentCount(); ++i) {
            this.setFont((Container)c.getComponent(i), size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyle(NodeModel node) {
        if (this.internalChange) {
            return;
        }
        this.internalChange = true;
        try {
            PersistentNodeHook al;
            ModeController modeController;
            LogicalStyleController logicalStyleController = LogicalStyleController.getController();
            if (this.addStyleBox) {
                boolean isStyleSet = LogicalStyleModel.getStyle(node) != null;
                this.mSetStyle.setValue(isStyleSet);
                this.setStyleList(this.mMapStyleButton, logicalStyleController.getMapStyleNames(node, "\n"));
            }
            this.setStyleList(this.mNodeStyleButton, logicalStyleController.getNodeStyleNames(node, "\n"));
            NodeStyleController styleController = NodeStyleController.getController();
            Color nodeColor = NodeStyleModel.getColor(node);
            Color viewNodeColor = styleController.getColor(node);
            this.mSetNodeColor.setValue(nodeColor != null);
            this.mNodeColor.setColorValue(viewNodeColor);
            Color color = NodeStyleModel.getBackgroundColor(node);
            Color viewColor = styleController.getBackgroundColor(node);
            this.mSetNodeBackgroundColor.setValue(color != null);
            this.mNodeBackgroundColor.setColorValue(viewColor != null ? viewColor : Controller.getCurrentController().getMapViewManager().getBackgroundColor(node));
            String shape = NodeStyleModel.getShape(node);
            String viewShape = styleController.getShape(node);
            this.mSetNodeShape.setValue(shape != null);
            this.mNodeShape.setValue(viewShape);
            NodeSizeModel nodeSizeModel = NodeSizeModel.getModel(node);
            int width = nodeSizeModel != null ? nodeSizeModel.getMaxNodeWidth() : -1;
            int viewWidth = styleController.getMaxWidth(node);
            this.mSetMaxNodeWidth.setValue(width != -1);
            this.mMaxNodeWidth.setValue(Integer.toString(viewWidth));
            width = nodeSizeModel != null ? nodeSizeModel.getMinNodeWidth() : -1;
            viewWidth = styleController.getMinWidth(node);
            this.mSetMinNodeWidth.setValue(width != -1);
            this.mMinNodeWidth.setValue(Integer.toString(viewWidth));
            EdgeController edgeController = EdgeController.getController();
            EdgeModel edgeModel = EdgeModel.getModel(node);
            Color edgeColor = edgeModel != null ? edgeModel.getColor() : null;
            Color viewColor2 = edgeController.getColor(node);
            this.mSetEdgeColor.setValue(edgeColor != null);
            this.mEdgeColor.setColorValue(viewColor2);
            EdgeStyle style = edgeModel != null ? edgeModel.getStyle() : null;
            EdgeStyle viewStyle = edgeController.getStyle(node);
            this.mSetEdgeStyle.setValue(style != null);
            this.mEdgeStyle.setValue(viewStyle.toString());
            int width2 = edgeModel != null ? edgeModel.getWidth() : -1;
            int viewWidth2 = edgeController.getWidth(node);
            this.mSetEdgeWidth.setValue(width2 != -1);
            this.mEdgeWidth.setValue(Integer.toString(viewWidth2));
            CloudController cloudController = CloudController.getController();
            CloudModel cloudModel = CloudModel.getModel(node);
            Color viewCloudColor = cloudController.getColor(node);
            this.mSetCloud.setValue(cloudModel != null);
            this.mCloudColor.setColorValue(viewCloudColor);
            CloudModel.Shape viewCloudShape = cloudController.getShape(node);
            this.mCloudShape.setValue(viewCloudShape != null ? viewCloudShape.toString() : CloudModel.Shape.ARC.toString());
            String fontFamilyName = NodeStyleModel.getFontFamilyName(node);
            String viewFontFamilyName = styleController.getFontFamilyName(node);
            this.mSetNodeFontName.setValue(fontFamilyName != null);
            this.mNodeFontName.setValue(viewFontFamilyName);
            Integer fontSize = NodeStyleModel.getFontSize(node);
            Integer viewfontSize = styleController.getFontSize(node);
            this.mSetNodeFontSize.setValue(fontSize != null);
            this.mNodeFontSize.setValue(viewfontSize.toString());
            Boolean bold = NodeStyleModel.isBold(node);
            Boolean viewbold = styleController.isBold(node);
            this.mSetNodeFontBold.setValue(bold != null);
            this.mNodeFontBold.setValue(viewbold);
            Boolean italic = NodeStyleModel.isItalic(node);
            Boolean viewitalic = styleController.isItalic(node);
            this.mSetNodeFontItalic.setValue(italic != null);
            this.mNodeFontItalic.setValue(viewitalic);
            Boolean hyperlink = NodeLinks.formatNodeAsHyperlink(node);
            Boolean viewhyperlink = LinkController.getController().formatNodeAsHyperlink(node);
            this.mSetNodeFontHyperlink.setValue(hyperlink != null);
            this.mNodeFontHyperlink.setValue(viewhyperlink);
            Boolean nodeNumbering = NodeStyleModel.getNodeNumbering(node);
            Boolean viewNodeNumbering = styleController.getNodeNumbering(node);
            this.mSetNodeNumbering.setValue(nodeNumbering != null);
            this.mNodeNumbering.setValue(viewNodeNumbering);
            String nodeFormat = NodeStyleModel.getNodeFormat(node);
            String viewNodeFormat = TextController.getController().getNodeFormat(node);
            this.mSetNodeFormat.setValue(nodeFormat != null);
            if (viewNodeFormat == null && node.getUserObject() instanceof IFormattedObject) {
                viewNodeFormat = ((IFormattedObject)node.getUserObject()).getPattern();
            }
            this.mNodeFormat.setValue(viewNodeFormat);
            if (this.mAutomaticLayoutComboBox != null) {
                modeController = Controller.getCurrentModeController();
                al = modeController.getExtension(AutomaticLayoutController.class);
                IExtension extension = al.getExtension(node);
                if (extension == null) {
                    this.mAutomaticLayoutComboBox.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
                } else {
                    this.mAutomaticLayoutComboBox.setSelectedIndex(((AutomaticLayout)extension).ordinal());
                }
            }
            if (this.mAutomaticEdgeColorCheckBox != null) {
                modeController = Controller.getCurrentModeController();
                al = modeController.getExtension(AutomaticEdgeColorHook.class);
                this.mAutomaticEdgeColorCheckBox.setSelected(al.isActive(node));
            }
        }
        finally {
            this.internalChange = false;
        }
    }

    private void setStyleList(JButton btn, String styles) {
        if ("".equals(styles)) {
            btn.setToolTipText(null);
            btn.setText(" ");
            return;
        }
        btn.setToolTipText(HtmlUtils.plainToHTML(styles));
        String text = styles.replaceAll("\n", ", ");
        btn.setText(text);
    }

    private void addListeners() {
        final Controller controller = Controller.getCurrentController();
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                if (selection.size() == 1) {
                    StyleEditorPanel.this.setStyle(node);
                }
            }

            public void onDeselect(NodeModel node) {
            }
        });
        mapController.addNodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                NodeModel node = event.getNode();
                if (selection.getSelected().equals(node)) {
                    StyleEditorPanel.this.setStyle(node);
                }
            }
        });
        mapController.addMapChangeListener(new AMapChangeListenerAdapter(){

            public void mapChanged(MapChangeEvent event) {
                if (!"MAP_STYLES".equals(event.getProperty())) {
                    return;
                }
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                NodeModel node = selection.getSelected();
                StyleEditorPanel.this.setStyle(node);
            }
        });
        IMapViewManager mapViewManager = controller.getMapViewManager();
        mapViewManager.addMapViewChangeListener(new IMapViewChangeListener(){

            public void beforeViewChange(Component oldView, Component newView) {
            }

            public void afterViewCreated(Component mapView) {
            }

            public void afterViewClose(Component oldView) {
            }

            public void afterViewChange(Component oldView, Component newView) {
                Container panel = (Container)StyleEditorPanel.this.getComponent(0);
                for (int i = 0; i < panel.getComponentCount(); ++i) {
                    panel.getComponent(i).setEnabled(newView != null);
                }
            }
        });
    }

    private abstract class ChangeListener
    implements PropertyChangeListener {
        private final IPropertyControl mProperty;
        private final BooleanProperty mSet;

        public ChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            this.mSet = mSet;
            this.mProperty = mProperty;
        }

        abstract void applyValue(boolean var1, NodeModel var2, PropertyChangeEvent var3);

        public void propertyChange(PropertyChangeEvent evt) {
            boolean enabled;
            if (StyleEditorPanel.this.internalChange) {
                return;
            }
            if (evt.getSource().equals(this.mSet)) {
                enabled = this.mSet.getBooleanValue();
            } else {
                assert (evt.getSource().equals(this.mProperty));
                enabled = true;
                this.mSet.setValue(true);
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            Set<NodeModel> nodes = selection.getSelection();
            if (enabled) {
                StyleEditorPanel.this.internalChange = true;
            }
            for (NodeModel node : nodes) {
                this.applyValue(enabled, node, evt);
            }
            StyleEditorPanel.this.internalChange = false;
            StyleEditorPanel.this.setStyle(selection.getSelected());
        }
    }

    private class StyleChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (StyleEditorPanel.this.internalChange) {
                return;
            }
            BooleanProperty isSet = (BooleanProperty)evt.getSource();
            MLogicalStyleController styleController = (MLogicalStyleController)LogicalStyleController.getController();
            if (isSet.getBooleanValue()) {
                styleController.setStyle((IStyle)StyleEditorPanel.this.uiFactory.getStyles().getSelectedItem());
            } else {
                styleController.setStyle(null);
            }
        }
    }

    private class NodeFormatChangeListener
    extends ChangeListener {
        public NodeFormatChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setNodeFormat(node, enabled ? StyleEditorPanel.this.mNodeFormat.getSelectedPattern() : null);
        }
    }

    private class NodeNumberingChangeListener
    extends ChangeListener {
        public NodeNumberingChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setNodeNumbering(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeNumbering.getBooleanValue()) : null);
        }
    }

    private class CloudShapeChangeListener
    extends ChangeListener {
        public CloudShapeChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MCloudController styleController = (MCloudController)Controller.getCurrentModeController().getExtension(CloudController.class);
            if (enabled) {
                styleController.setShape(node, CloudModel.Shape.valueOf(StyleEditorPanel.this.mCloudShape.getValue()));
            } else {
                styleController.setCloud(node, false);
            }
        }
    }

    private class CloudColorChangeListener
    extends ChangeListener {
        public CloudColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MCloudController styleController = (MCloudController)Controller.getCurrentModeController().getExtension(CloudController.class);
            if (enabled) {
                styleController.setColor(node, StyleEditorPanel.this.mCloudColor.getColorValue());
            } else {
                styleController.setCloud(node, false);
            }
        }
    }

    private class MinNodeWidthChangeListener
    extends ChangeListener {
        public MinNodeWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setMinNodeWidth(node, enabled ? Integer.parseInt(StyleEditorPanel.this.mMinNodeWidth.getValue()) : -1);
        }
    }

    private class MaxNodeWidthChangeListener
    extends ChangeListener {
        public MaxNodeWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setMaxNodeWidth(node, enabled ? Integer.parseInt(StyleEditorPanel.this.mMaxNodeWidth.getValue()) : -1);
        }
    }

    private class EdgeWidthChangeListener
    extends ChangeListener {
        public EdgeWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setWidth(node, enabled ? Integer.parseInt(StyleEditorPanel.this.mEdgeWidth.getValue()) : -1);
        }
    }

    private class EdgeStyleChangeListener
    extends ChangeListener {
        public EdgeStyleChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setStyle(node, enabled ? EdgeStyle.getStyle(StyleEditorPanel.this.mEdgeStyle.getValue()) : null);
        }
    }

    private class EdgeColorChangeListener
    extends ChangeListener {
        public EdgeColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController edgeController = (MEdgeController)MEdgeController.getController();
            edgeController.setColor(node, enabled ? StyleEditorPanel.this.mEdgeColor.getColorValue() : null);
        }
    }

    private class FontNameChangeListener
    extends ChangeListener {
        public FontNameChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setFontFamily(node, enabled ? StyleEditorPanel.this.mNodeFontName.getValue() : null);
        }
    }

    private class FontSizeChangeListener
    extends ChangeListener {
        public FontSizeChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            try {
                styleController.setFontSize(node, enabled ? Integer.valueOf(StyleEditorPanel.this.mNodeFontSize.getValue()) : null);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private class FontHyperlinkChangeListener
    extends ChangeListener {
        public FontHyperlinkChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MLinkController styleController = (MLinkController)Controller.getCurrentModeController().getExtension(LinkController.class);
            styleController.setFormatNodeAsHyperlink(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeFontHyperlink.getBooleanValue()) : null);
        }
    }

    private class FontItalicChangeListener
    extends ChangeListener {
        public FontItalicChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setItalic(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeFontItalic.getBooleanValue()) : null);
        }
    }

    private class FontBoldChangeListener
    extends ChangeListener {
        public FontBoldChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBold(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeFontBold.getBooleanValue()) : null);
        }
    }

    private class ColorChangeListener
    extends ChangeListener {
        public ColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setColor(node, enabled ? StyleEditorPanel.this.mNodeColor.getColorValue() : null);
        }
    }

    private class NodeShapeChangeListener
    extends ChangeListener {
        public NodeShapeChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setShape(node, enabled ? StyleEditorPanel.this.mNodeShape.getValue() : null);
        }
    }

    private class BgColorChangeListener
    extends ChangeListener {
        public BgColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBackgroundColor(node, enabled ? StyleEditorPanel.this.mNodeBackgroundColor.getColorValue() : null);
        }
    }
}

