/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleNamedObject;

public class NewUserStyleAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public NewUserStyleAction() {
        super("NewUserStyleAction");
    }

    public void actionPerformed(ActionEvent e) {
        String styleName = JOptionPane.showInputDialog(TextUtils.getText("enter_new_style_name"));
        if (styleName == null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        NodeModel selectedNode = controller.getSelection().getSelected();
        final MapModel map = controller.getMap();
        final MapStyleModel styleModel = MapStyleModel.getExtension(map);
        MapModel styleMap = styleModel.getStyleMap();
        IStyle newStyle = StyleFactory.create(styleName);
        if (null != styleModel.getStyleNode(newStyle)) {
            UITools.errorMessage(TextUtils.getText("style_already_exists"));
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        final NodeModel newNode = new NodeModel(styleMap);
        newNode.setUserObject(newStyle);
        final LogicalStyleController styleController = LogicalStyleController.getController();
        ArrayList<IStyle> styles = new ArrayList<IStyle>(styleController.getStyles(selectedNode));
        for (int i = styles.size() - 1; i >= 0; --i) {
            NodeModel styleNode;
            IStyle style = styles.get(i);
            if (MapStyleModel.DEFAULT_STYLE.equals(style) || (styleNode = styleModel.getStyleNode(style)) == null) continue;
            Controller.getCurrentModeController().copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, styleNode, newNode);
        }
        Controller.getCurrentModeController().copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, selectedNode, newNode);
        Controller.getCurrentModeController().copyExtensions((Object)MIconController.Keys.ICONS, selectedNode, newNode);
        NodeModel userStyleParentNode = styleModel.getStyleNodeGroup(styleMap, "styles.user-defined");
        if (userStyleParentNode == null) {
            userStyleParentNode = new NodeModel(styleMap);
            userStyleParentNode.setUserObject(new StyleNamedObject("styles.user-defined"));
            mapController.insertNode(userStyleParentNode, styleMap.getRootNode(), false, false, true);
        }
        mapController.insertNode(newNode, userStyleParentNode, false, false, true);
        mapController.select(newNode);
        IActor actor = new IActor(){

            public void undo() {
                styleModel.removeStyleNode(newNode);
                styleController.refreshMap(map);
            }

            public String getDescription() {
                return "NewStyle";
            }

            public void act() {
                styleModel.addStyleNode(newNode);
                styleController.refreshMap(map);
            }
        };
        Controller.getCurrentModeController().execute(actor, styleMap);
    }
}

