/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.mindmapmode.AManageConditionalStylesAction;

public class ManageNodeConditionalStylesAction
extends AManageConditionalStylesAction {
    public static final String NAME = "ManageNodeConditionalStylesAction";
    private static final long serialVersionUID = 1L;

    public ManageNodeConditionalStylesAction() {
        super(NAME);
    }

    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        ConditionalStyleModel conditionalStyleModel = this.getConditionalStyleModel();
        Component pane = this.createConditionalStylePane(map, conditionalStyleModel);
        ModeController modeController = Controller.getCurrentModeController();
        modeController.startTransaction();
        try {
            int confirmed = JOptionPane.showConfirmDialog(controller.getMapViewManager().getMapViewComponent(), pane, TextUtils.getText(TextUtils.removeMnemonic("ManageNodeConditionalStylesAction.text")), 2, -1);
            if (0 == confirmed) {
                modeController.commit();
                modeController.getMapController().nodeChanged(controller.getSelection().getSelected(), NodeModel.UNKNOWN_PROPERTY, null, null);
            } else {
                modeController.rollback();
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            modeController.rollback();
        }
    }

    public ConditionalStyleModel getConditionalStyleModel() {
        Controller controller = Controller.getCurrentController();
        NodeModel node = controller.getSelection().getSelected();
        ConditionalStyleModel conditionalStyleModel = node.getExtension(ConditionalStyleModel.class);
        if (conditionalStyleModel == null) {
            conditionalStyleModel = new ConditionalStyleModel();
            node.addExtension(conditionalStyleModel);
        }
        return conditionalStyleModel;
    }
}

