/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.AssignStyleAction;
import org.freeplane.features.styles.mindmapmode.CopyMapStylesAction;
import org.freeplane.features.styles.mindmapmode.CopyStyleExtensionsAction;
import org.freeplane.features.styles.mindmapmode.FilterComposerDialog;
import org.freeplane.features.styles.mindmapmode.ManageMapConditionalStylesAction;
import org.freeplane.features.styles.mindmapmode.ManageNodeConditionalStylesAction;
import org.freeplane.features.styles.mindmapmode.MapBackgroundColorAction;
import org.freeplane.features.styles.mindmapmode.NewUserStyleAction;
import org.freeplane.features.styles.mindmapmode.RedefineStyleAction;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.mindmapmode.MTextController;

public class MLogicalStyleController
extends LogicalStyleController {
    private final List<AssignStyleAction> actions = new LinkedList<AssignStyleAction>();
    private FilterComposerDialog filterComposerDialog;

    public MLogicalStyleController(ModeController modeController) {
        super(modeController);
    }

    public void initS() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new ManageNodeConditionalStylesAction());
    }

    public void initM() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.getMapController().addNodeChangeListener(new StyleRemover());
        modeController.registerExtensionCopier(new ExtensionCopier());
        modeController.addAction(new RedefineStyleAction());
        modeController.addAction(new NewUserStyleAction());
        modeController.addAction(new ManageMapConditionalStylesAction());
        modeController.addAction(new ManageNodeConditionalStylesAction());
        modeController.addAction(new CopyStyleExtensionsAction());
        if (modeController.getModeName().equals("MindMap")) {
            modeController.addAction(new MapBackgroundColorAction());
            modeController.addAction(new CopyMapStylesAction());
        }
        if (!modeController.getController().getViewController().isHeadless()) {
            IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            final MenuBuilder menuBuilder = userInputListenerFactory.getMenuBuilder();
            Controller.getCurrentController().getMapViewManager().addMapSelectionListener(new IMapSelectionListener(){

                public void beforeMapChange(MapModel oldMap, MapModel newMap) {
                    MLogicalStyleController.this.removeStyleMenu(menuBuilder, "main_menu_styles");
                    MLogicalStyleController.this.removeStyleMenu(menuBuilder, "node_popup_styles");
                }

                public void afterMapChange(MapModel oldMap, MapModel newMap) {
                    MLogicalStyleController.this.addStyleMenu(menuBuilder, "main_menu_styles", newMap);
                    MLogicalStyleController.this.addStyleMenu(menuBuilder, "node_popup_styles", newMap);
                }
            });
            MapController mapController = modeController.getMapController();
            mapController.addMapChangeListener(new IMapChangeListener(){

                public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
                }

                public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
                }

                public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
                }

                public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
                }

                public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
                }

                public void mapChanged(MapChangeEvent event) {
                    if (event.getProperty().equals("MAP_STYLES")) {
                        MLogicalStyleController.this.removeStyleMenu(menuBuilder, "main_menu_styles");
                        MLogicalStyleController.this.addStyleMenu(menuBuilder, "main_menu_styles", event.getMap());
                        MLogicalStyleController.this.removeStyleMenu(menuBuilder, "node_popup_styles");
                        MLogicalStyleController.this.addStyleMenu(menuBuilder, "node_popup_styles", event.getMap());
                    }
                }
            });
            mapController.addNodeSelectionListener(new INodeSelectionListener(){

                public void onSelect(NodeModel node) {
                    MLogicalStyleController.this.selectActions();
                }

                public void onDeselect(NodeModel node) {
                }
            });
        }
    }

    protected void removeStyleMenu(MenuBuilder menuBuilder, String formatMenuString) {
        if (null != menuBuilder.get(formatMenuString)) {
            menuBuilder.removeChildElements(formatMenuString);
        }
        this.actions.clear();
    }

    protected void addStyleMenu(MenuBuilder menuBuilder, String formatMenuString, MapModel newMap) {
        if (newMap == null) {
            return;
        }
        MapStyleModel extension = MapStyleModel.getExtension(newMap);
        if (extension == null) {
            return;
        }
        if (null == menuBuilder.get(formatMenuString)) {
            return;
        }
        NodeModel rootNode = extension.getStyleMap().getRootNode();
        AssignStyleAction resetAction = new AssignStyleAction(null);
        this.actions.add(resetAction);
        menuBuilder.addAction(formatMenuString, resetAction, 0);
        this.addStyleMenu(menuBuilder, formatMenuString, rootNode, extension);
    }

    private void addStyleMenu(MenuBuilder menuBuilder, String category, NodeModel rootNode, MapStyleModel extension) {
        List<NodeModel> children = rootNode.getChildren();
        for (NodeModel child : children) {
            IStyle style = (IStyle)child.getUserObject();
            if (child.hasChildren()) {
                this.addStyleMenu(menuBuilder, category, child, extension);
                continue;
            }
            if (null == extension.getStyleNode(style)) continue;
            AssignStyleAction action = new AssignStyleAction(style);
            this.actions.add(action);
            menuBuilder.addAction(category, action, 0);
        }
    }

    public void setStyle(final NodeModel node, final IStyle style) {
        final ModeController modeController = Controller.getCurrentModeController();
        final IStyle oldStyle = LogicalStyleModel.getStyle(node);
        if (oldStyle != null && oldStyle.equals(style) || oldStyle == style) {
            modeController.getMapController().nodeChanged(node, LogicalStyleModel.class, oldStyle, style);
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setStyle";
            }

            public void act() {
                this.changeStyle(modeController, node, oldStyle, style);
            }

            public void undo() {
                this.changeStyle(modeController, node, style, oldStyle);
            }

            private void changeStyle(ModeController modeController2, NodeModel node2, IStyle oldStyle2, IStyle style2) {
                if (style2 != null) {
                    LogicalStyleModel model = LogicalStyleModel.createExtension(node2);
                    model.setStyle(style2);
                } else {
                    node2.removeExtension(LogicalStyleModel.class);
                }
                modeController2.getMapController().nodeChanged(node2, LogicalStyleModel.class, oldStyle2, style2);
                MLogicalStyleController.this.selectActions();
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void copyStyleExtensions(IStyle style, NodeModel target) {
        MTextController textController = MTextController.getController();
        MapStyleModel extension = MapStyleModel.getExtension(target.getMap());
        NodeModel styleNode = extension.getStyleNode(style);
        if (styleNode != null) {
            String noteText;
            MAttributeController attributeController = MAttributeController.getController();
            attributeController.copyAttributesToNode(styleNode, target);
            String detailTextText = DetailTextModel.getDetailTextText(styleNode);
            if (detailTextText != null) {
                textController.setDetails(target, detailTextText);
            }
            if ((noteText = NoteModel.getNoteText(styleNode)) != null) {
                MNoteController noteController = (MNoteController)NoteController.getController();
                noteController.setNoteText(target, noteText);
            }
        }
    }

    void selectActions() {
        for (AssignStyleAction action : this.actions) {
            action.setSelected();
        }
    }

    public void setStyle(IStyle style) {
        ModeController modeController = Controller.getCurrentModeController();
        Collection<NodeModel> selectedNodes = modeController.getMapController().getSelectedNodes();
        for (NodeModel selected : selectedNodes) {
            this.setStyle(selected, style);
        }
    }

    public void moveConditionalStyleDown(MapModel map, final ConditionalStyleModel conditionalStyleModel, final int index) {
        int maxIndex = conditionalStyleModel.getStyleCount() - 1;
        if (index < 0 || index >= maxIndex) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveConditionalStyleDown";
            }

            public void act() {
                MLogicalStyleController.super.moveConditionalStyleDown(conditionalStyleModel, index);
            }

            public void undo() {
                MLogicalStyleController.super.moveConditionalStyleUp(conditionalStyleModel, index + 1);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void moveConditionalStyleUp(MapModel map, final ConditionalStyleModel conditionalStyleModel, final int index) {
        int maxIndex = conditionalStyleModel.getStyleCount() - 1;
        if (index <= 0 || index > maxIndex) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveConditionalStyleUp";
            }

            public void act() {
                MLogicalStyleController.super.moveConditionalStyleUp(conditionalStyleModel, index);
            }

            public void undo() {
                MLogicalStyleController.super.moveConditionalStyleDown(conditionalStyleModel, index - 1);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public static MLogicalStyleController getController() {
        return (MLogicalStyleController)LogicalStyleController.getController();
    }

    public void addConditionalStyle(MapModel map, ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        AddConditionalStyleActor actor = new AddConditionalStyleActor(conditionalStyleModel, isActive, condition, style, isLast);
        Controller.getCurrentModeController().execute(actor, map);
    }

    public ConditionalStyleModel.Item removeConditionalStyle(MapModel map, ConditionalStyleModel conditionalStyleModel, int index) {
        RemoveConditionalStyleActor actor = new RemoveConditionalStyleActor(conditionalStyleModel, index);
        Controller.getCurrentModeController().execute(actor, map);
        return actor.item;
    }

    public TableModel getConditionalStyleModelAsTableModel(final MapModel map, final ConditionalStyleModel conditionalStyleModel) {
        return new TableModel(){
            private final TableModel tableModel;
            {
                this.tableModel = conditionalStyleModel.asTableModel();
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
                this.tableModel.addTableModelListener(l);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.tableModel.getColumnClass(columnIndex);
            }

            @Override
            public int getColumnCount() {
                return this.tableModel.getColumnCount();
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.tableModel.getColumnName(columnIndex);
            }

            @Override
            public int getRowCount() {
                return this.tableModel.getRowCount();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return this.tableModel.getValueAt(rowIndex, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.tableModel.isCellEditable(rowIndex, columnIndex);
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
                this.tableModel.removeTableModelListener(l);
            }

            @Override
            public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
                final Object oldValue = this.tableModel.getValueAt(rowIndex, columnIndex);
                if (aValue == oldValue || aValue != null && aValue.equals(oldValue)) {
                    return;
                }
                IActor actor = new IActor(){

                    public String getDescription() {
                        return "set conditional style table cell value";
                    }

                    public void act() {
                        tableModel.setValueAt(aValue, rowIndex, columnIndex);
                    }

                    public void undo() {
                        tableModel.setValueAt(oldValue, rowIndex, columnIndex);
                    }
                };
                Controller.getCurrentModeController().execute(actor, map);
            }
        };
    }

    public FilterComposerDialog getFilterComposerDialog() {
        if (this.filterComposerDialog == null) {
            this.filterComposerDialog = new FilterComposerDialog();
        }
        return this.filterComposerDialog;
    }

    public ASelectableCondition editCondition(ASelectableCondition value) {
        FilterComposerDialog filterComposerDialog = this.getFilterComposerDialog();
        filterComposerDialog.acceptMultipleConditions(true);
        if (value != null) {
            filterComposerDialog.addCondition(value);
        }
        filterComposerDialog.show();
        List<ASelectableCondition> conditions = filterComposerDialog.getConditions();
        if (filterComposerDialog.isSuccess()) {
            return conditions.isEmpty() ? null : conditions.get(0);
        }
        return value;
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            LogicalStyleModel fromStyle = from.getExtension(LogicalStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            LogicalStyleModel toStyle = LogicalStyleModel.createExtension(to);
            toStyle.setStyle(fromStyle.getStyle());
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals((Object)LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            from.removeExtension(LogicalStyleModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals((Object)LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            LogicalStyleModel whichStyle = which.getExtension(LogicalStyleModel.class);
            if (whichStyle == null) {
                return;
            }
            LogicalStyleModel fromStyle = from.getExtension(LogicalStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension(fromStyle);
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
        }
    }

    private static class StyleRemover
    implements INodeChangeListener {
        public void nodeChanged(NodeChangeEvent event) {
            ModeController modeController = Controller.getCurrentModeController();
            if (modeController == null || modeController.isUndoAction()) {
                return;
            }
            if (!event.getProperty().equals(LogicalStyleModel.class)) {
                return;
            }
            NodeModel node = event.getNode();
            MapModel map = node.getMap();
            IStyle styleKey = (IStyle)event.getNewValue();
            MapStyleModel mapStyles = MapStyleModel.getExtension(map);
            NodeModel styleNode = mapStyles.getStyleNode(styleKey);
            if (styleNode == null) {
                return;
            }
            modeController.undoableRemoveExtensions((Object)LogicalStyleKeys.NODE_STYLE, node, styleNode);
        }
    }

    private final class AddConditionalStyleActor
    implements IActor {
        private final ConditionalStyleModel conditionalStyleModel;
        private final boolean isActive;
        private final ASelectableCondition condition;
        private final IStyle style;
        private boolean isLast;

        public AddConditionalStyleActor(ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
            this.conditionalStyleModel = conditionalStyleModel;
            this.isActive = isActive;
            this.condition = condition;
            this.style = style;
            this.isLast = isLast;
        }

        public void undo() {
            int index = this.conditionalStyleModel.getStyleCount() - 1;
            MLogicalStyleController.super.removeConditionalStyle(this.conditionalStyleModel, index);
        }

        public String getDescription() {
            return "AddConditionalStyle";
        }

        public void act() {
            MLogicalStyleController.super.addConditionalStyle(this.conditionalStyleModel, this.isActive, this.condition, this.style, this.isLast);
        }
    }

    private final class RemoveConditionalStyleActor
    implements IActor {
        private final int index;
        private final ConditionalStyleModel conditionalStyleModel;
        ConditionalStyleModel.Item item = null;

        private RemoveConditionalStyleActor(ConditionalStyleModel conditionalStyleModel, int index) {
            this.index = index;
            this.conditionalStyleModel = conditionalStyleModel;
        }

        public void undo() {
            MLogicalStyleController.super.insertConditionalStyle(this.conditionalStyleModel, this.index, this.item.isActive(), this.item.getCondition(), this.item.getStyle(), this.item.isLast());
        }

        public String getDescription() {
            return "RemoveConditionalStyle";
        }

        public void act() {
            this.item = MLogicalStyleController.super.removeConditionalStyle(this.conditionalStyleModel, this.index);
        }
    }
}

