/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.AFilterComposerDialog;
import org.freeplane.features.filter.condition.ASelectableCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterComposerDialog
extends AFilterComposerDialog {
    private final List<ASelectableCondition> conditions = new LinkedList<ASelectableCondition>();
    private DefaultComboBoxModel model;
    private boolean acceptMultipleConditions;

    public FilterComposerDialog() {
        super(TextUtils.getText("filter_dialog"), true);
    }

    @Override
    protected DefaultComboBoxModel createModel() {
        this.conditions.clear();
        this.initializeModel();
        return this.model;
    }

    protected void initializeModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        }
    }

    @Override
    protected boolean applyModel(DefaultComboBoxModel model, int[] selectedIndices) {
        if (selectedIndices.length != 1 && !this.acceptMultipleConditions) {
            return false;
        }
        this.conditions.clear();
        this.model = model;
        for (int i : selectedIndices) {
            this.conditions.add((ASelectableCondition)model.getElementAt(i));
        }
        return true;
    }

    public List<ASelectableCondition> getConditions() {
        return this.conditions;
    }

    public void acceptMultipleConditions(boolean acceptMultipleConditions) {
        this.acceptMultipleConditions = acceptMultipleConditions;
    }

    public void addCondition(ASelectableCondition value) {
        this.initializeModel();
        if (this.model.getIndexOf(value) == -1) {
            this.model.addElement(value);
        }
        this.setSelectedItem(value);
    }
}

