/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.DefaultStyleRenderer;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;

class ConditionalStyleTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private MapStyleModel styleModel;
    private DefaultConditionRenderer conditionRenderer;

    public ConditionalStyleTable(MapStyleModel styleModel, TableModel tableModel) {
        super(tableModel);
        this.styleModel = styleModel;
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        TableColumnModel columnModel = this.getColumnModel();
        this.setAutoResizeMode(0);
        this.setRowHeight(20);
        this.conditionRenderer = new DefaultConditionRenderer(TextUtils.getText("always"), true);
        columnModel.getColumn(1).setCellRenderer(this.conditionRenderer);
        columnModel.getColumn(1).setCellEditor(new ConditionEditor());
        final JComboBox styleBox = new JComboBox();
        styleBox.setEditable(false);
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(styleBox){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.setClickCountToStart(2);
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Set<IStyle> styles = ConditionalStyleTable.this.styleModel.getStyles();
                DefaultComboBoxModel<Object> boxContent = new DefaultComboBoxModel<Object>(styles.toArray());
                styleBox.setModel(boxContent);
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        });
        columnModel.getColumn(1).setPreferredWidth(300);
        columnModel.getColumn(2).setPreferredWidth(180);
        columnModel.getColumn(2).setCellRenderer(new DefaultStyleRenderer());
    }

    public MapStyleModel getStyles() {
        return this.styleModel;
    }

    private class ConditionEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JButton btn;
        private Object cellEditorValue;

        public ConditionEditor() {
            this.btn = new JButton(){
                {
                    this.setUI(BasicButtonUI.createUI(this));
                }

                public Color getBackground() {
                    return ConditionalStyleTable.this.getSelectionBackground();
                }
            };
        }

        public Component getTableCellEditorComponent(JTable table, final Object value, boolean isSelected, int row, int column) {
            this.btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MLogicalStyleController styleController = MLogicalStyleController.getController();
                    ConditionEditor.this.cellEditorValue = styleController.editCondition((ASelectableCondition)value);
                    ConditionEditor.this.btn.removeActionListener(this);
                    ConditionEditor.this.fireEditingStopped();
                }
            });
            return this.btn;
        }

        public Object getCellEditorValue() {
            return this.cellEditorValue;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }
    }
}

