/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.spellchecker.mindmapmode;

import com.inet.jortho.FileUserDictionary;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.UserDictionaryProvider;
import java.awt.EventQueue;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class SpellCheckerController
implements IExtension {
    private static final String SPELLING_LANGUAGE = "spelling_language";
    private boolean spellCheckerEnabled = false;
    private boolean spellCheckerInitialized = false;
    private LanguageChangeListener languageChangeListener;

    public static SpellCheckerController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return modeController.getExtension(SpellCheckerController.class);
    }

    public static void install(ModeController modeController) {
        modeController.addExtension(SpellCheckerController.class, new SpellCheckerController());
    }

    private SpellCheckerController() {
    }

    public void addSpellCheckerMenu(JPopupMenu popupMenu) {
        if (!this.isSpellCheckerActive()) {
            return;
        }
        popupMenu.add(SpellChecker.createCheckerMenu());
        popupMenu.add(SpellChecker.createLanguagesMenu());
    }

    public void enableAutoSpell(JTextComponent editorPane, boolean enable) {
        if (!this.isSpellCheckerActive()) {
            return;
        }
        SpellChecker.enableAutoSpell((JTextComponent)editorPane, (boolean)enable);
    }

    public void enableShortKey(JTextComponent editorPane, boolean enable) {
        if (!this.isSpellCheckerActive()) {
            return;
        }
        SpellChecker.enableShortKey((JTextComponent)editorPane, (boolean)enable);
    }

    private void init() {
        if (this.spellCheckerInitialized) {
            return;
        }
        this.spellCheckerInitialized = true;
        final ResourceController resourceController = ResourceController.getResourceController();
        File orthoDir = new File(resourceController.getResourceBaseDir(), "ortho");
        this.registerDictionaries(orthoDir);
        File userOrthoDir = new File(resourceController.getFreeplaneUserDirectory(), "ortho");
        this.registerDictionaries(userOrthoDir);
        if (!this.spellCheckerEnabled) {
            return;
        }
        this.setSpellCheckOptions(resourceController);
        resourceController.addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.startsWith("spelling_opt")) {
                    SpellCheckerController.this.setSpellCheckOptions(resourceController);
                }
            }
        });
        String spellingLanguage = resourceController.getProperty(SPELLING_LANGUAGE, null);
        if (spellingLanguage == null) {
            spellingLanguage = resourceController.getLanguageCode();
        }
        if (!spellingLanguage.equals("disabled")) {
            SpellChecker.setLanguage((String)spellingLanguage);
        }
        this.languageChangeListener = new LanguageChangeListener(){

            public void languageChanged(final LanguageChangeEvent ev) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Locale currentLocale = ev.getCurrentLocale();
                        if (currentLocale == null) {
                            resourceController.setProperty(SpellCheckerController.SPELLING_LANGUAGE, "disabled");
                            return;
                        }
                        resourceController.setProperty(SpellCheckerController.SPELLING_LANGUAGE, currentLocale.getLanguage());
                    }
                });
            }
        };
        SpellChecker.addLanguageChangeLister((LanguageChangeListener)this.languageChangeListener);
    }

    private void registerDictionaries(File orthoDir) {
        if (!orthoDir.isDirectory()) {
            return;
        }
        String[] dictionaryList = orthoDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.length() == "dictionary_XX.ortho".length() && name.startsWith("dictionary_") && name.endsWith(".ortho");
            }
        });
        if (dictionaryList.length == 0) {
            return;
        }
        ResourceController resourceController = ResourceController.getResourceController();
        SpellChecker.setUserDictionaryProvider((UserDictionaryProvider)new FileUserDictionary(resourceController.getFreeplaneUserDirectory()));
        StringBuilder availableLocales = new StringBuilder();
        for (int i = 0; i < dictionaryList.length; ++i) {
            String language = dictionaryList[i].substring("dictionary_".length(), "dictionary_".length() + 2);
            availableLocales.append(language);
            availableLocales.append(",");
        }
        try {
            SpellChecker.registerDictionaries((URL)orthoDir.toURI().toURL(), (String)availableLocales.toString(), null, (String)".ortho");
            this.spellCheckerEnabled = true;
        }
        catch (MalformedURLException e) {
            LogUtils.severe(e);
        }
    }

    private void setSpellCheckOptions(ResourceController resourceController) {
        SpellCheckerOptions options = SpellChecker.getOptions();
        options.setCaseSensitive(resourceController.getBooleanProperty("spelling_opt_case_sensitive"));
        options.setIgnoreAllCapsWords(resourceController.getBooleanProperty("spelling_opt_ignore_all_caps_words"));
        options.setIgnoreCapitalization(resourceController.getBooleanProperty("spelling_opt_ignore_capitalization"));
        options.setIgnoreWordsWithNumbers(resourceController.getBooleanProperty("spelling_opt_ignore_words_with_numbers"));
        options.setSuggestionsLimitDialog(resourceController.getIntProperty("spelling_opt_suggestions_limit_dialog", 15));
        options.setSuggestionsLimitMenu(resourceController.getIntProperty("spelling_opt_suggestions_limit_menu", 15));
    }

    public boolean isSpellCheckerActive() {
        this.init();
        return this.spellCheckerEnabled;
    }
}

