/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import com.lightdev.app.shtm.SHTMLPanel;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.text.html.HTMLDocument;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;

final class NoteManager
implements INodeSelectionListener {
    public static final Pattern HEAD = Pattern.compile("<head>.*</head>\n", 32);
    private boolean ignoreEditorUpdate;
    MNoteController.NoteDocumentListener mNoteDocumentListener;
    private NodeModel node;
    private final MNoteController noteController;

    public NoteManager(MNoteController noteController) {
        this.noteController = noteController;
    }

    public void onDeselect(NodeModel node) {
        SHTMLPanel noteViewerComponent = this.noteController.getNoteViewerComponent();
        if (noteViewerComponent == null) {
            return;
        }
        noteViewerComponent.getDocument().removeDocumentListener(this.mNoteDocumentListener);
        this.saveNote(node);
        this.node = null;
    }

    public void onSelect(NodeModel nodeView) {
        this.node = nodeView;
        this.updateEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNote() {
        if (this.node == null) {
            return;
        }
        SHTMLPanel noteViewerComponent = this.noteController.getNoteViewerComponent();
        if (noteViewerComponent == null) {
            return;
        }
        boolean editorContentEmpty = true;
        String documentText = noteViewerComponent.getDocumentText();
        documentText = HEAD.matcher(documentText).replaceFirst("");
        editorContentEmpty = HtmlUtils.isEmpty(documentText);
        Controller.getCurrentModeController().getMapController().removeNodeSelectionListener(this);
        if (noteViewerComponent.needsSaving()) {
            try {
                this.ignoreEditorUpdate = true;
                if (editorContentEmpty) {
                    this.noteController.setNoteText(this.node, null);
                } else {
                    this.noteController.setNoteText(this.node, documentText);
                }
            }
            finally {
                this.ignoreEditorUpdate = false;
            }
            this.noteController.setLastContentEmpty(editorContentEmpty);
        }
        Controller.getCurrentModeController().getMapController().addNodeSelectionListener(this);
    }

    void saveNote(NodeModel node) {
        if (this.node != node) {
            return;
        }
        this.saveNote();
    }

    void updateEditor() {
        String note;
        if (this.ignoreEditorUpdate) {
            return;
        }
        SHTMLPanel noteViewerComponent = this.noteController.getNoteViewerComponent();
        if (noteViewerComponent == null) {
            return;
        }
        HTMLDocument document = noteViewerComponent.getDocument();
        document.removeDocumentListener(this.mNoteDocumentListener);
        try {
            URL url = this.node.getMap().getURL();
            if (url != null) {
                document.setBase(url);
            } else {
                document.setBase(new URL("file: "));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.noteController.setDefaultFont();
        String string = note = this.node != null ? NoteModel.getNoteText(this.node) : null;
        if (note != null) {
            noteViewerComponent.setCurrentDocumentContent(note);
            this.noteController.setLastContentEmpty(false);
        } else if (!this.noteController.isLastContentEmpty()) {
            noteViewerComponent.setCurrentDocumentContent("");
            this.noteController.setLastContentEmpty(true);
        }
        document.addDocumentListener(this.mNoteDocumentListener);
    }
}

