/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPrefsChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.EditNoteInDialogAction;
import org.freeplane.features.note.mindmapmode.NoteManager;
import org.freeplane.features.note.mindmapmode.RemoveNoteAction;
import org.freeplane.features.note.mindmapmode.SelectNoteAction;
import org.freeplane.features.note.mindmapmode.SetNoteWindowPosition;
import org.freeplane.features.note.mindmapmode.ShowHideNoteAction;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.SetBooleanMapPropertyAction;
import org.freeplane.features.text.mindmapmode.FreeplaneToSHTMLPropertyChangeAdapter;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.url.UrlManager;

public class MNoteController
extends NoteController {
    private static SHTMLPanel htmlEditorPanel;
    public static final String RESOURCES_REMOVE_NOTES_WITHOUT_QUESTION = "remove_notes_without_question";
    public static final String RESOURCES_USE_DEFAULT_FONT_FOR_NOTES_TOO = "resources_use_default_font_for_notes_too";
    public static final String RESOURCES_USE_MARGIN_TOP_ZERO_FOR_NOTES = "resources_use_margin_top_zero_for_notes";
    static final String RESOURCES_USE_SPLIT_PANE = "use_split_pane";
    private boolean mLastContentEmpty = true;
    private NoteManager noteManager = new NoteManager(this);
    private SHTMLPanel noteViewerComponent;

    public MNoteController(ModeController modeController) {
        this.createActions(modeController);
    }

    private void createActions(ModeController modeController) {
        modeController.addAction(new SelectNoteAction(this));
        modeController.addAction(new ShowHideNoteAction(this));
        modeController.addAction(new EditNoteInDialogAction());
        modeController.addAction(new SetNoteWindowPosition("top"));
        modeController.addAction(new SetNoteWindowPosition("left"));
        modeController.addAction(new SetNoteWindowPosition("right"));
        modeController.addAction(new SetNoteWindowPosition("bottom"));
        modeController.addAction(new RemoveNoteAction(this));
        modeController.addAction(new SetBooleanMapPropertyAction("show_note_icons"));
    }

    SHTMLPanel getHtmlEditorPanel() {
        if (htmlEditorPanel != null) {
            return htmlEditorPanel;
        }
        htmlEditorPanel = MTextController.getController().createSHTMLPanel("Note");
        ResourceController.getResourceController().addPropertyChangeListener(new FreeplaneToSHTMLPropertyChangeAdapter((SHTMLPrefsChangeListener)htmlEditorPanel));
        htmlEditorPanel.setMinimumSize(new Dimension(100, 100));
        final SHTMLEditorPane editorPane = (SHTMLEditorPane)htmlEditorPanel.getEditorPane();
        for (InputMap inputMap = editorPane.getInputMap(); inputMap != null; inputMap = inputMap.getParent()) {
            inputMap.remove(KeyStroke.getKeyStroke("ctrl pressed T"));
            inputMap.remove(KeyStroke.getKeyStroke("ctrl shift pressed T"));
            inputMap.remove(KeyStroke.getKeyStroke("ctrl pressed SPACE"));
        }
        editorPane.addFocusListener(new FocusListener(){
            private SpellCheckerController spellCheckerController = null;
            private boolean enabled = false;

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    this.spellCheckerController.enableAutoSpell((JTextComponent)editorPane, false);
                    this.enabled = false;
                }
            }

            public void focusGained(FocusEvent e) {
                if (!this.enabled) {
                    this.initSpellChecker();
                    this.spellCheckerController.enableAutoSpell((JTextComponent)editorPane, true);
                    this.enabled = true;
                }
            }

            private void initSpellChecker() {
                if (this.spellCheckerController != null) {
                    return;
                }
                this.spellCheckerController = SpellCheckerController.getController();
                this.spellCheckerController.addSpellCheckerMenu(editorPane.getPopup());
                this.spellCheckerController.enableShortKey((JTextComponent)editorPane, true);
            }
        });
        return htmlEditorPanel;
    }

    SHTMLPanel getNoteViewerComponent() {
        return this.noteViewerComponent;
    }

    void hideNotesPanel() {
        this.noteManager.saveNote();
        this.noteViewerComponent.setVisible(false);
        Controller.getCurrentModeController().getController().getViewController().removeSplitPane();
        ResourceController.getResourceController().setProperty(RESOURCES_USE_SPLIT_PANE, "false");
    }

    boolean isLastContentEmpty() {
        return this.mLastContentEmpty;
    }

    protected void onWrite(MapModel map) {
        ModeController modeController = Controller.getCurrentModeController();
        Controller controller = modeController.getController();
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return;
        }
        NodeModel selected = selection.getSelected();
        this.noteManager.saveNote(selected);
    }

    void setLastContentEmpty(boolean mLastContentEmpty) {
        this.mLastContentEmpty = mLastContentEmpty;
    }

    public void setNoteText(final NodeModel node, final String newText) {
        final String oldText = this.getNoteText(node);
        if (oldText == newText || null != oldText && oldText.equals(newText)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                this.setText(newText);
            }

            public String getDescription() {
                return "setNoteText";
            }

            private void setText(String text) {
                boolean enabled;
                boolean bl = enabled = text != null && !text.equals("");
                if (enabled) {
                    NoteModel note = NoteModel.createNote(node);
                    note.setHtml(text);
                    node.addExtension(note);
                } else if (null != node.getExtension(NoteModel.class)) {
                    node.removeExtension(NoteModel.class);
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node, "note_text", oldText, text);
                if (MNoteController.this.noteManager != null) {
                    MNoteController.this.noteManager.updateEditor();
                }
            }

            public void undo() {
                this.setText(oldText);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private boolean shouldUseSplitPane() {
        return "true".equals(ResourceController.getResourceController().getProperty(RESOURCES_USE_SPLIT_PANE));
    }

    void showNotesPanel(boolean requestFocus) {
        if (this.noteViewerComponent == null) {
            this.noteViewerComponent = this.getHtmlEditorPanel();
            this.noteManager.updateEditor();
        }
        SouthPanel southPanel = new SouthPanel();
        southPanel.add((Component)this.noteViewerComponent, "Center");
        this.noteViewerComponent.setOpenHyperlinkHandler(new ActionListener(){

            public void actionPerformed(ActionEvent pE) {
                try {
                    String uriText = pE.getActionCommand();
                    UrlManager.getController().loadURL(new URI(uriText));
                }
                catch (Exception e) {
                    LogUtils.severe(e);
                }
            }
        });
        this.noteViewerComponent.setVisible(true);
        ResourceController.getResourceController().setProperty(RESOURCES_USE_SPLIT_PANE, "true");
        Controller.getCurrentModeController().getController().getViewController().insertComponentIntoSplitPane(southPanel);
        if (requestFocus) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SHTMLPanel htmlEditorPanel = MNoteController.this.getHtmlEditorPanel();
                    htmlEditorPanel.getMostRecentFocusOwner().requestFocus();
                    if (ResourceController.getResourceController().getBooleanProperty("goto_note_end_on_edit")) {
                        JEditorPane editorPane = htmlEditorPanel.getEditorPane();
                        editorPane.setCaretPosition(editorPane.getDocument().getLength());
                    }
                }
            });
        }
        southPanel.revalidate();
    }

    void setDefaultFont() {
        StyleSheet styleSheet = this.noteViewerComponent.getDocument().getStyleSheet();
        styleSheet.removeStyle("body");
        styleSheet.removeStyle("p");
        NodeStyleController style = Controller.getCurrentModeController().getExtension(NodeStyleController.class);
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        if (map != null) {
            Font defaultFont = style.getDefaultFont(map, MapStyleModel.NOTE_STYLE);
            String rule = "body {";
            rule = rule + "font-family: " + defaultFont.getFamily() + ";";
            rule = rule + "font-size: " + defaultFont.getSize() + "pt;";
            if (defaultFont.isItalic()) {
                rule = rule + "font-style: italic; ";
            }
            if (defaultFont.isBold()) {
                rule = rule + "font-weight: bold; ";
            }
            rule = rule + "}\n";
            styleSheet.addRule(rule);
        }
        if (ResourceController.getResourceController().getBooleanProperty(RESOURCES_USE_MARGIN_TOP_ZERO_FOR_NOTES)) {
            String rule = "p {";
            rule = rule + "margin-top:0;";
            rule = rule + "}\n";
            styleSheet.addRule(rule);
        }
    }

    boolean isEditing() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focusOwner != null && this.noteViewerComponent != null && SwingUtilities.isDescendingFrom(focusOwner, (Component)this.noteViewerComponent);
    }

    void setFocusToMap() {
        Controller controller = Controller.getCurrentModeController().getController();
        NodeModel node = controller.getSelection().getSelected();
        controller.getMapViewManager().getComponent(node).requestFocusInWindow();
    }

    public void shutdownController() {
        Controller.getCurrentModeController().getMapController().removeNodeSelectionListener(this.noteManager);
        if (this.noteViewerComponent == null) {
            return;
        }
        this.noteViewerComponent.getActionMap().remove("jumpToMapAction");
        if (this.shouldUseSplitPane()) {
            this.hideNotesPanel();
            this.noteViewerComponent = null;
        }
    }

    public void startupController() {
        ModeController modeController = Controller.getCurrentModeController();
        if (this.shouldUseSplitPane()) {
            SwingUtilities.invokeLater(new Runnable(){
                int count = 10;

                public void run() {
                    if (this.count == 0) {
                        NodeModel selected;
                        MNoteController.this.showNotesPanel(false);
                        IMapSelection selection = Controller.getCurrentController().getSelection();
                        if (selection != null && (selected = selection.getSelected()) != null) {
                            selection.centerNode(selected);
                        }
                    } else {
                        --this.count;
                        SwingUtilities.invokeLater(this);
                    }
                }
            });
        }
        modeController.getMapController().addNodeSelectionListener(this.noteManager);
        this.noteManager.mNoteDocumentListener = new NoteDocumentListener();
    }

    boolean isNoteEditorShowing() {
        return ResourceController.getResourceController().getBooleanProperty(RESOURCES_USE_SPLIT_PANE);
    }

    public void setShowNotesInMap(MapModel model, boolean show) {
        MapStyle.getController().setProperty(model, "show_notes_in_map", Boolean.toString(show));
    }

    private static class SouthPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public SouthPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return super.processKeyBinding(ks, e, condition, pressed) || e.getKeyChar() == ' ' || e.getKeyChar() == '\u0012';
        }
    }

    final class NoteDocumentListener
    implements DocumentListener {
        NoteDocumentListener() {
        }

        public void changedUpdate(DocumentEvent arg0) {
            this.docEvent();
        }

        private void docEvent() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, (Component)htmlEditorPanel)) {
                return;
            }
            ModeController modeController = Controller.getCurrentModeController();
            MapController mapController = modeController.getMapController();
            MapModel map = modeController.getController().getMap();
            mapController.setSaved(map, false);
        }

        public void insertUpdate(DocumentEvent arg0) {
            this.docEvent();
        }

        public void removeUpdate(DocumentEvent arg0) {
            this.docEvent();
        }
    }
}

