/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Pattern;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.ui.IMapViewManager;

class EditNoteInDialogAction
extends AFreeplaneAction {
    private static final Pattern HTML_HEAD = Pattern.compile("\\s*<head>.*</head>", 32);
    private static final long serialVersionUID = 1L;
    private EditNodeBase mCurrentEditDialog = null;

    public EditNoteInDialogAction() {
        super("EditNoteInDialogAction");
    }

    public void actionPerformed(ActionEvent arg0) {
        Controller controller = Controller.getCurrentController();
        NodeModel nodeModel = controller.getSelection().getSelected();
        IMapViewManager viewController = controller.getMapViewManager();
        Component node = viewController.getComponent(nodeModel);
        node.requestFocus();
        this.edit(nodeModel);
    }

    void edit(final NodeModel nodeModel) {
        Controller controller = Controller.getCurrentController();
        this.stopEditing();
        Controller.getCurrentModeController().setBlocked(true);
        String text = NoteModel.getNoteText(nodeModel);
        if (text == null) {
            text = "";
        }
        EditNodeBase.IEditControl editControl = new EditNodeBase.IEditControl(){

            public void cancel() {
                Controller.getCurrentModeController().setBlocked(false);
                EditNoteInDialogAction.this.mCurrentEditDialog = null;
            }

            public void ok(String newText) {
                EditNoteInDialogAction.this.setHtmlText(nodeModel, newText);
                this.cancel();
            }

            public void split(String newText, int position) {
            }

            public boolean canSplit() {
                return false;
            }

            public EditNodeBase.EditedComponent getEditType() {
                return EditNodeBase.EditedComponent.NOTE;
            }
        };
        IEditBaseCreator textFieldCreator = (IEditBaseCreator)((Object)Controller.getCurrentController().getMapViewManager());
        this.mCurrentEditDialog = textFieldCreator.createEditor(nodeModel, editControl, text, true);
        RootPaneContainer frame = (RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(controller.getMapViewManager().getMapViewComponent()));
        this.mCurrentEditDialog.show(frame);
    }

    private void setHtmlText(NodeModel node, String newText) {
        String body = HTML_HEAD.matcher(newText).replaceFirst("");
        MNoteController noteController = (MNoteController)MNoteController.getController();
        String trimmed = body.replaceFirst("\\s+$", "");
        if (HtmlUtils.isEmpty(trimmed)) {
            noteController.setNoteText(node, null);
        } else {
            noteController.setNoteText(node, trimmed);
        }
    }

    private void stopEditing() {
        if (this.mCurrentEditDialog != null) {
            this.mCurrentEditDialog.closeEdit();
            this.mCurrentEditDialog = null;
        }
    }
}

