/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle.mindmapmode;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.BoldAction;
import org.freeplane.features.nodestyle.mindmapmode.CopyFormat;
import org.freeplane.features.nodestyle.mindmapmode.ItalicAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeBackgroundColorAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeColorAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeColorBlendAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeShapeAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeWidthAction;
import org.freeplane.features.nodestyle.mindmapmode.PasteFormat;
import org.freeplane.features.nodestyle.mindmapmode.RemoveFormatAction;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MNodeStyleController
extends NodeStyleController {
    public MNodeStyleController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier(new StyleCopier(modeController));
        modeController.addAction(new BoldAction());
        modeController.addAction(new ItalicAction());
        modeController.addAction(new CopyFormat());
        modeController.addAction(new PasteFormat());
        modeController.addAction(new RemoveFormatAction());
        AMultipleNodeAction increaseNodeFont = new AMultipleNodeAction("IncreaseNodeFontAction"){
            private static final long serialVersionUID = 1L;

            protected void actionPerformed(ActionEvent e, NodeModel node) {
                MNodeStyleController.this.increaseFontSize(node, 1);
            }
        };
        modeController.addAction(increaseNodeFont);
        AMultipleNodeAction decreaseNodeFont = new AMultipleNodeAction("DecreaseNodeFontAction"){
            private static final long serialVersionUID = 1L;

            protected void actionPerformed(ActionEvent e, NodeModel node) {
                MNodeStyleController.this.increaseFontSize(node, -1);
            }
        };
        modeController.addAction(decreaseNodeFont);
        modeController.addAction(new NodeColorAction());
        modeController.addAction(new NodeColorBlendAction());
        modeController.addAction(new NodeBackgroundColorAction());
        modeController.addAction(new NodeShapeAction("fork"));
        modeController.addAction(new NodeShapeAction("bubble"));
        modeController.addAction(new NodeWidthAction());
    }

    public void copyStyle(NodeModel source, NodeModel target) {
        this.copyStyleModel(source, target);
        this.copySizeModel(source, target);
    }

    protected void copyStyleModel(NodeModel source, NodeModel target) {
        NodeStyleModel sourceStyleModel = NodeStyleModel.getModel(source);
        if (sourceStyleModel != null) {
            this.setColor(target, sourceStyleModel.getColor());
            this.setBackgroundColor(target, sourceStyleModel.getBackgroundColor());
            this.setShape(target, sourceStyleModel.getShape());
            this.setFontFamily(target, sourceStyleModel.getFontFamilyName());
            this.setFontSize(target, sourceStyleModel.getFontSize());
            this.setBold(target, sourceStyleModel.isBold());
            this.setItalic(target, sourceStyleModel.isItalic());
            this.setNodeFormat(target, sourceStyleModel.getNodeFormat());
            this.setNodeNumbering(target, sourceStyleModel.getNodeNumbering());
        }
    }

    protected void copySizeModel(NodeModel source, NodeModel target) {
        NodeSizeModel sourceSizeModel = NodeSizeModel.getModel(source);
        if (sourceSizeModel != null) {
            this.setMaxNodeWidth(target, sourceSizeModel.getMaxNodeWidth());
            this.setMinNodeWidth(target, sourceSizeModel.getMinNodeWidth());
        }
    }

    private NodeStyleModel createOwnStyleModel(final NodeModel node) {
        NodeStyleModel styleModel = NodeStyleModel.getModel(node);
        if (styleModel != null) {
            return styleModel;
        }
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                node.addExtension(new NodeStyleModel());
            }

            public String getDescription() {
                return null;
            }

            public void undo() {
                node.removeExtension(NodeStyleModel.class);
            }
        };
        modeController.execute(actor, node.getMap());
        return NodeStyleModel.getModel(node);
    }

    private NodeSizeModel createOwnSizeModel(final NodeModel node) {
        NodeSizeModel sizeModel = NodeSizeModel.getModel(node);
        if (sizeModel != null) {
            return sizeModel;
        }
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                node.addExtension(new NodeSizeModel());
            }

            public String getDescription() {
                return null;
            }

            public void undo() {
                node.removeExtension(NodeSizeModel.class);
            }
        };
        modeController.execute(actor, node.getMap());
        return NodeSizeModel.getModel(node);
    }

    public void increaseFontSize(NodeModel node, int increment) {
        int newSize = this.getFontSize(node) + increment;
        if (newSize > 0) {
            this.setFontSize(node, newSize);
        }
    }

    public void setBackgroundColor(final NodeModel node, final Color color) {
        ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = NodeStyleModel.getBackgroundColor(node);
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setBackgroundColor(node, color);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setBackgroundColor";
            }

            public void undo() {
                NodeStyleModel.setBackgroundColor(node, oldColor);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setBold(final NodeModel node, final Boolean bold) {
        final Boolean oldBold = NodeStyleModel.isBold(node);
        if (oldBold == bold || oldBold != null && oldBold.equals(bold)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setBold(bold);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setBold";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setBold(oldBold);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setColor(final NodeModel node, final Color color) {
        ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = NodeStyleModel.getColor(node);
        if (oldColor == color || oldColor != null && oldColor.equals(color)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setColor(node, color);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                NodeStyleModel.setColor(node, oldColor);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setFontFamily(final NodeModel node, final String fontFamily) {
        final String oldFontFamily = NodeStyleModel.getFontFamilyName(node);
        if (oldFontFamily == fontFamily || oldFontFamily != null && oldFontFamily.equals(fontFamily)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setFontFamilyName(fontFamily);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFontFamily";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setFontFamilyName(oldFontFamily);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setFontFamily(String fontFamily) {
        for (NodeModel selected : Controller.getCurrentModeController().getMapController().getSelectedNodes()) {
            this.setFontFamily(selected, fontFamily);
        }
    }

    public void setFontSize(int size) {
        Collection<NodeModel> selectedNodes = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        for (NodeModel selected : selectedNodes) {
            this.setFontSize(selected, size);
        }
    }

    public void setFontSize(final NodeModel node, final Integer fontSize) {
        final Integer oldFontSize = NodeStyleModel.getFontSize(node);
        if (oldFontSize == fontSize || oldFontSize != null && oldFontSize.equals(fontSize)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setFontSize(fontSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFontSize";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setFontSize(oldFontSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setItalic(final NodeModel node, final Boolean italic) {
        final Boolean oldItalic = NodeStyleModel.isItalic(node);
        if (oldItalic == italic || oldItalic != null && oldItalic.equals(italic)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setItalic(italic);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setItalic";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel(node);
                styleModel.setItalic(oldItalic);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setNodeNumbering(final NodeModel node, final Boolean enableNodeNumbering) {
        final ModeController modeController = Controller.getCurrentModeController();
        final Boolean oldValue = NodeStyleModel.getNodeNumbering(node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setNodeNumbering(node, enableNodeNumbering);
                MapController mapController = modeController.getMapController();
                mapController.setSaved(node.getMap(), false);
                mapController.delayedNodeRefresh(node, "NodeNumbering", oldValue, enableNodeNumbering);
            }

            public String getDescription() {
                return "setNodeNumbering";
            }

            public void undo() {
                NodeStyleModel.setNodeNumbering(node, oldValue);
                MapController mapController = modeController.getMapController();
                mapController.setSaved(node.getMap(), false);
                modeController.getMapController().delayedNodeRefresh(node, "NodeNumbering", enableNodeNumbering, oldValue);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setNodeFormat(final NodeModel node, final String format) {
        final ModeController modeController = Controller.getCurrentModeController();
        final String oldFormat = NodeStyleModel.getNodeFormat(node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setNodeFormat(node, format);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setNodeFormat";
            }

            public void undo() {
                NodeStyleModel.setNodeFormat(node, oldFormat);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setShape(final NodeModel node, final String shape) {
        final ModeController modeController = Controller.getCurrentModeController();
        final String oldShape = NodeStyleModel.getShape(node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setShape(node, shape);
                modeController.getMapController().nodeChanged(node);
                this.childShapeRefresh(node);
            }

            public String getDescription() {
                return "setShape";
            }

            private void childShapeRefresh(NodeModel node2) {
                for (NodeModel child : modeController.getMapController().childrenFolded(node2)) {
                    String childShape;
                    if (child.getViewers().isEmpty() || (childShape = NodeStyleModel.getShape(child)) != null && !"as_parent".equals(childShape)) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.childShapeRefresh(child);
                }
            }

            public void undo() {
                NodeStyleModel.setShape(node, oldShape);
                modeController.getMapController().nodeChanged(node);
                this.childShapeRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setMinNodeWidth(final NodeModel node, final int minNodeWidth) {
        final NodeSizeModel sizeModel = this.createOwnSizeModel(node);
        final int oldValue = NodeSizeModel.getMinNodeWidth(node);
        IActor actor = new IActor(){

            public void act() {
                sizeModel.setMinNodeWidth(minNodeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMinNodeWidth";
            }

            public void undo() {
                sizeModel.setMinNodeWidth(oldValue);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
        int maxWidth = this.getMaxWidth(node);
        if (maxWidth < minNodeWidth) {
            this.setMaxNodeWidth(node, minNodeWidth);
        }
    }

    public void setMaxNodeWidth(final NodeModel node, final int maxNodeWidth) {
        final NodeSizeModel sizeModel = this.createOwnSizeModel(node);
        final int oldValue = NodeSizeModel.getNodeMaxNodeWidth(node);
        IActor actor = new IActor(){

            public void act() {
                sizeModel.setMaxNodeWidth(maxNodeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMaxNodeWidth";
            }

            public void undo() {
                sizeModel.setMaxNodeWidth(oldValue);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
        int minNodeWidth = this.getMinWidth(node);
        if (maxNodeWidth < minNodeWidth) {
            this.setMinNodeWidth(node, maxNodeWidth);
        }
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private final ModeController modeController;

        public StyleCopier(ModeController modeController) {
            this.modeController = modeController;
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            NodeSizeModel fromSize;
            NodeStyleModel fromStyle = from.getExtension(NodeStyleModel.class);
            if (fromStyle != null) {
                fromStyle.copyTo(NodeStyleModel.createNodeStyleModel(to));
            }
            if ((fromSize = from.getExtension(NodeSizeModel.class)) != null) {
                fromSize.copyTo(NodeSizeModel.createNodeSizeModel(to));
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(NodeStyleModel.class);
            from.removeExtension(NodeSizeModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            this.removeStyleData(key, from, which);
            this.removeSizeData(key, from, which);
        }

        private void removeSizeData(Object key, NodeModel from, NodeModel which) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NodeSizeModel whichData = which.getExtension(NodeSizeModel.class);
            if (whichData == null) {
                return;
            }
            NodeSizeModel fromData = from.getExtension(NodeSizeModel.class);
            if (fromData == null) {
                return;
            }
            if (-1 != whichData.getMaxNodeWidth()) {
                fromData.setMaxNodeWidth(-1);
            }
            if (-1 != whichData.getMinNodeWidth()) {
                fromData.setMinNodeWidth(-1);
            }
        }

        private void removeStyleData(Object key, NodeModel from, NodeModel which) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NodeStyleModel whichStyle = which.getExtension(NodeStyleModel.class);
            if (whichStyle == null) {
                return;
            }
            NodeStyleModel fromStyle = from.getExtension(NodeStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            if (null != whichStyle.isBold()) {
                fromStyle.setBold(null);
            }
            if (null != whichStyle.isItalic()) {
                fromStyle.setItalic(null);
            }
            if (null != whichStyle.getFontFamilyName()) {
                fromStyle.setFontFamilyName(null);
            }
            if (null != whichStyle.getFontSize()) {
                fromStyle.setFontSize(null);
            }
            if (null != whichStyle.getShape()) {
                fromStyle.setShape(null);
            }
            if (null != whichStyle.getColor()) {
                fromStyle.setColor(null);
            }
            if (null != whichStyle.getBackgroundColor()) {
                fromStyle.setBackgroundColor(null);
            }
            if (null != whichStyle.getNodeFormat()) {
                fromStyle.setNodeFormat(null);
            }
            if (null != whichStyle.getNodeNumbering()) {
                fromStyle.setNodeNumbering(null);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.resolveShape(to);
        }

        private void resolveShape(NodeModel to) {
            if (this.hasOwnShape(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                if (!this.hasOwnShape(source)) continue;
                String shape = this.getShape(source);
                NodeStyleModel.createNodeStyleModel(to).setShape(shape);
                return;
            }
        }

        private boolean hasOwnShape(NodeModel to) {
            return !"as_parent".equals(this.getShape(to));
        }

        private String getShape(NodeModel node) {
            return this.modeController.getExtension(NodeStyleController.class).getShape(node);
        }
    }
}

