/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation.mindmapmode;

import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.ResetNodeLocationAction;

public class MLocationController
extends LocationController {
    public MLocationController() {
        this.createActions();
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new ResetNodeLocationAction());
    }

    public void moveNodePosition(NodeModel node, int parentVGap, int hGap, int shiftY) {
        ChangeNodePositionActor actor = new ChangeNodePositionActor(node, parentVGap, hGap, shiftY);
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private final class ChangeNodePositionActor
    implements IActor {
        private final int gap;
        private final NodeModel node;
        private final int oldHgap;
        private final int oldParentVgap;
        private final int oldShiftY;
        private final int parentVGap;
        private final int shiftY;

        private ChangeNodePositionActor(NodeModel node, int parentVGap, int gap, int shiftY) {
            this.node = node;
            this.gap = gap;
            this.shiftY = shiftY;
            this.parentVGap = parentVGap;
            LocationModel locationModel = LocationModel.getModel(node);
            this.oldHgap = locationModel.getHGap();
            this.oldShiftY = locationModel.getShiftY();
            this.oldParentVgap = !node.isRoot() ? LocationModel.getModel(node.getParentNode()).getVGap() : 0;
        }

        public void act() {
            this.moveNodePosition(this.node, this.parentVGap, this.gap, this.shiftY);
        }

        public String getDescription() {
            return "moveNodePosition";
        }

        private void moveNodePosition(NodeModel node, int parentVGap, int hGap, int shiftY) {
            LocationModel locationModel = LocationModel.createLocationModel(node);
            locationModel.setHGap(hGap);
            locationModel.setShiftY(shiftY);
            if (!node.isRoot() && this.parentVGap >= 0) {
                LocationModel.createLocationModel(node.getParentNode()).setVGap(parentVGap);
            }
            Controller.getCurrentModeController().getMapController().nodeChanged(node);
        }

        public void undo() {
            this.moveNodePosition(this.node, this.oldParentVgap, this.oldHgap, this.oldShiftY);
        }
    }
}

