/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.LoadAcceleratorPresetsAction;

class SaveAcceleratorPresetsAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SaveAcceleratorPresetsAction() {
        super("SaveAcceleratorPresetsAction");
    }

    public void actionPerformed(ActionEvent e) {
        int confirm;
        String keyset = JOptionPane.showInputDialog(TextUtils.getText("enter_keyset_name"));
        if (keyset == null || keyset.equals("")) {
            return;
        }
        File acceleratorsUserDirectory = LoadAcceleratorPresetsAction.getAcceleratorsUserDirectory();
        File keysetFile = new File(acceleratorsUserDirectory, keyset + ".properties");
        if (keysetFile.exists() && (confirm = JOptionPane.showConfirmDialog(UITools.getFrame(), TextUtils.getText("overwrite_keyset_question"), "Freeplane", 0)) != 0) {
            return;
        }
        Properties keysetProperties = new Properties();
        Set<Map.Entry<Object, Object>> allProperties = ResourceController.getResourceController().getProperties().entrySet();
        for (Map.Entry<Object, Object> p : allProperties) {
            if (!p.getKey().toString().startsWith("acceleratorFor")) continue;
            keysetProperties.put(p.getKey(), p.getValue());
        }
        try {
            acceleratorsUserDirectory.mkdirs();
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(keysetFile));
            keysetProperties.store(output, "");
            ((OutputStream)output).close();
            String key = "LoadAcceleratorPresetsAction." + keyset;
            if (Controller.getCurrentController().getAction(key) != null) {
                return;
            }
            String title = TextUtils.getText(key + ".text", keyset);
            LoadAcceleratorPresetsAction loadAcceleratorPresetsAction = new LoadAcceleratorPresetsAction(keysetFile.toURL(), key, title);
            if (null == Controller.getCurrentController().getAction(loadAcceleratorPresetsAction.getKey())) {
                Controller.getCurrentController().addAction(loadAcceleratorPresetsAction);
                Controller.getCurrentModeController().getUserInputListenerFactory().getMenuBuilder().addAction("main_menu_new_load_accelerator_presets", key, loadAcceleratorPresetsAction, 0);
            }
        }
        catch (IOException e1) {
            UITools.errorMessage(TextUtils.getText("can_not_save_key_set"));
        }
    }
}

