/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class RedoAction
extends AFreeplaneAction
implements INodeChangeListener {
    private static final long serialVersionUID = 1L;
    private Action undo;
    private NodeModel lastChangedNode;

    public RedoAction() {
        super("RedoAction");
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        MapController mapController = Controller.getCurrentModeController().getMapController();
        mapController.addNodeChangeListener(this);
        try {
            undoHandler.getRedoAction().actionPerformed(e);
            if (this.lastChangedNode != null) {
                mapController.displayNode(this.lastChangedNode);
                controller.getSelection().selectAsTheOnlyOneSelected(this.lastChangedNode);
                this.lastChangedNode = null;
            }
            this.undo.setEnabled(undoHandler.canUndo());
            this.setEnabled(undoHandler.canRedo());
        }
        finally {
            mapController.removeNodeChangeListener(this);
        }
    }

    public void reset() {
        MapModel map = Controller.getCurrentController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.resetRedo();
        this.setEnabled(false);
    }

    public void setUndo(Action undo) {
        this.undo = undo;
    }

    public void afterMapChange(Object newMap) {
    }

    public void nodeChanged(NodeChangeEvent event) {
        this.lastChangedNode = event.getNode();
    }
}

