/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.net.URL;
import java.util.Vector;
import javax.swing.UIManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.resources.components.PropertyAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.RedoAction;
import org.freeplane.features.mode.mindmapmode.SaveAcceleratorPresetsAction;
import org.freeplane.features.mode.mindmapmode.SelectAllAction;
import org.freeplane.features.mode.mindmapmode.SelectBranchAction;
import org.freeplane.features.mode.mindmapmode.UndoAction;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.ui.MenuXmlCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MModeController
extends ModeController {
    private static final String LOOKANDFEEL_PROPERTY = "lookandfeel";
    public static final String MODENAME = "MindMap";
    private RedoAction redo;
    public static final String RESOURCES_DELETE_NODES_WITHOUT_QUESTION = "delete_nodes_without_question";
    private static final String PREF_MM2XML = "/xslt/mm2preferences.xsl";
    private UndoAction undo;
    private OptionPanelBuilder optionPanelBuilder;

    public static MModeController getMModeController() {
        Controller controller = Controller.getCurrentController();
        return (MModeController)controller.getModeController(MODENAME);
    }

    public MModeController(Controller controller) {
        super(controller);
        this.createActions();
        this.createOptionPanelControls();
    }

    private void addUndoableActor(IActor actor, MapModel map) {
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.addActor(actor);
    }

    public void deactivateUndo(MMapModel map) {
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.deactivate();
    }

    @Override
    public void commit() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.commit();
    }

    public void delayedCommit() {
        MMapModel map = (MMapModel)this.getController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.delayedCommit();
    }

    public void delayedRollback() {
        MMapModel map = (MMapModel)this.getController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.delayedRollback();
    }

    private void createActions() {
        this.undo = new UndoAction();
        this.redo = new RedoAction();
        this.undo.setRedo(this.redo);
        this.redo.setUndo(this.undo);
        this.addAction(this.undo);
        this.addAction(this.redo);
        this.addAction(new SelectBranchAction());
        this.addAction(new SelectAllAction());
        this.addAction(new SaveAcceleratorPresetsAction());
    }

    private void createOptionPanelControls() {
        this.optionPanelBuilder = new OptionPanelBuilder();
        ResourceController resourceController = ResourceController.getResourceController();
        URL preferences = new MenuXmlCreator(PREF_MM2XML).menuResource("/xml/preferences.xml");
        this.optionPanelBuilder.load(preferences);
        this.addAction(MModeController.createPropertyAction(this.optionPanelBuilder));
    }

    public static PropertyAction createPropertyAction(OptionPanelBuilder optionPanelBuilder) {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Vector<String> lafNames = new Vector<String>(lafInfo.length + 1);
        Vector<String> translatedLafNames = new Vector<String>(lafInfo.length + 1);
        lafNames.add("default");
        translatedLafNames.add(TextUtils.getOptionalText("OptionPanel.default"));
        for (int i = 0; i < lafInfo.length; ++i) {
            UIManager.LookAndFeelInfo info = lafInfo[i];
            String className = info.getClassName();
            lafNames.add(className);
            translatedLafNames.add(info.getName());
        }
        MModeController.addCurrentLookAndFeelIfNecessary(lafNames, translatedLafNames);
        optionPanelBuilder.addComboProperty("Appearance/look_and_feel/lookandfeel", LOOKANDFEEL_PROPERTY, lafNames, translatedLafNames, 0);
        return new PropertyAction(optionPanelBuilder.getRoot());
    }

    private static void addCurrentLookAndFeelIfNecessary(Vector<String> lafNames, Vector<String> translatedLafNames) {
        String currentLaf = ResourceController.getResourceController().getProperty(LOOKANDFEEL_PROPERTY);
        if (!lafNames.contains(currentLaf)) {
            lafNames.add(currentLaf);
            translatedLafNames.add(currentLaf.replaceFirst(".*\\.", ""));
        }
    }

    @Override
    public void execute(IActor actor, MapModel map) {
        actor.act();
        this.addUndoableActor(actor, map);
    }

    @Override
    public String getModeName() {
        return MODENAME;
    }

    public OptionPanelBuilder getOptionPanelBuilder() {
        return this.optionPanelBuilder;
    }

    @Override
    public boolean isUndoAction() {
        MapModel model = this.getController().getMap();
        if (!(model instanceof MMapModel)) {
            return false;
        }
        return ((MMapModel)model).getExtension(IUndoHandler.class).isUndoActionRunning();
    }

    @Override
    public void rollback() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.rollback();
    }

    public boolean save() {
        return ((MFileManager)UrlManager.getController()).save(this.getController().getMap());
    }

    @Override
    public void shutdown() {
        super.shutdown();
        MNoteController noteController = (MNoteController)NoteController.getController();
        if (noteController != null) {
            noteController.shutdownController();
        }
    }

    @Override
    public void startTransaction() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.startTransaction();
    }

    @Override
    public void forceNewTransaction() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        undoHandler.forceNewTransaction();
    }

    @Override
    public void startup() {
        super.startup();
        NoteController noteController = NoteController.getController();
        if (noteController != null) {
            ((MNoteController)noteController).startupController();
        }
    }

    public void undo() {
        this.undo.actionPerformed(null);
    }

    public void resetRedo() {
        this.redo.reset();
    }

    @Override
    public boolean canEdit() {
        return true;
    }
}

