/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class LoadAcceleratorPresetsAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final URL resource;

    private static File getAcceleratorsSysDirectory() {
        return new File(ResourceController.getResourceController().getResourceBaseDir(), "accelerators");
    }

    static File getAcceleratorsUserDirectory() {
        return new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), "accelerators");
    }

    public static final void install() {
        File[] dirs = new File[]{LoadAcceleratorPresetsAction.getAcceleratorsUserDirectory(), LoadAcceleratorPresetsAction.getAcceleratorsSysDirectory()};
        Controller controller = Controller.getCurrentController();
        ModeController modecontroller = controller.getModeController("MindMap");
        MenuBuilder menuBuilder = modecontroller.getUserInputListenerFactory().getMenuBuilder();
        for (File dir : dirs) {
            File[] fileList = dir.listFiles();
            if (fileList == null) continue;
            for (File prop : fileList) {
                String fileName = prop.getName();
                if (prop.isDirectory() || !fileName.endsWith(".properties")) continue;
                try {
                    int propNameLength = fileName.lastIndexOf(46);
                    String propName = fileName.substring(0, propNameLength);
                    String key = "LoadAcceleratorPresetsAction." + propName;
                    if (controller.getAction(key) != null) continue;
                    String title = TextUtils.getText(key + ".text", propName);
                    LoadAcceleratorPresetsAction loadAcceleratorPresetsAction = new LoadAcceleratorPresetsAction(prop.toURL(), key, title);
                    controller.addAction(loadAcceleratorPresetsAction);
                    menuBuilder.addAction("main_menu_new_load_accelerator_presets", key, loadAcceleratorPresetsAction, 0);
                }
                catch (Exception e) {
                    UITools.errorMessage(TextUtils.format("accelerators_loading_error", prop.getPath()));
                }
            }
        }
    }

    LoadAcceleratorPresetsAction(URL resource, String propFileName, String title) {
        super("LoadAcceleratorPresetsAction." + propFileName, title, null);
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        InputStream in = null;
        try {
            in = this.resource.openStream();
            MenuBuilder.loadAcceleratorPresets(in);
        }
        catch (IOException e1) {
            try {
                e1.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in);
                throw throwable;
            }
            FileUtils.silentlyClose(in);
        }
        FileUtils.silentlyClose(in);
    }
}

