/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

class NewSummaryAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private int start;
    private int end;
    private int summaryLevel;

    public NewSummaryAction() {
        super("NewSummaryAction");
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.check()) {
            UITools.errorMessage(TextUtils.getText("summary_not_possible"));
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        mapController.addNewSummaryNodeStartEditing(this.summaryLevel, this.start, this.end);
    }

    private boolean check() {
        this.start = -1;
        this.end = -1;
        this.summaryLevel = -1;
        ModeController modeController = Controller.getCurrentModeController();
        IMapSelection selection = modeController.getController().getSelection();
        List<NodeModel> sortedSelection = selection.getSortedSelection(false);
        NodeModel firstNode = sortedSelection.get(0);
        NodeModel parentNode = firstNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        NodeModel lastNode = sortedSelection.get(sortedSelection.size() - 1);
        if (!parentNode.equals(lastNode.getParentNode())) {
            return false;
        }
        boolean isLeft = firstNode.isLeft();
        if (isLeft != lastNode.isLeft()) {
            return false;
        }
        this.start = parentNode.getIndex(firstNode);
        this.end = parentNode.getIndex(lastNode);
        if (firstNode != lastNode && SummaryNode.isFirstGroupNode(lastNode)) {
            return false;
        }
        this.summaryLevel = SummaryNode.getSummaryLevel(firstNode);
        if (this.summaryLevel != SummaryNode.getSummaryLevel(lastNode)) {
            return false;
        }
        int level = this.summaryLevel;
        for (int i = this.start + 1; i < this.end; ++i) {
            NodeModel node = (NodeModel)parentNode.getChildAt(i);
            if (isLeft != node.isLeft()) continue;
            level = SummaryNode.isSummaryNode(node) ? ++level : 0;
            if (level <= this.summaryLevel) continue;
            return false;
        }
        return true;
    }
}

