/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewParentNode
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public NewParentNode() {
        super("NewParentNode");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final NodeModel selectedNode = Controller.getCurrentModeController().getMapController().getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        Collection<NodeModel> unmodifyable = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>(unmodifyable.size());
        selectedNodes.addAll(unmodifyable);
        Controller.getCurrentModeController().getMapController().sortNodesByDepth(selectedNodes);
        if (selectedNode.isRoot()) {
            UITools.errorMessage(TextUtils.getText("cannot_add_parent_to_root"));
            return;
        }
        final NodeModel newNode = this.moveToNewParent(selectedNode, selectedNodes);
        if (newNode == null) {
            return;
        }
        Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(newNode);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ((MTextController)TextController.getController()).edit(newNode, selectedNode, true, false, false);
            }
        });
    }

    private NodeModel moveToNewParent(NodeModel selectedNode, List<NodeModel> selectedNodes) {
        NodeModel oldParent = selectedNode.getParentNode();
        int childPosition = oldParent.getChildPosition(selectedNode);
        NodeModel newParent = ((MMapController)Controller.getCurrentModeController().getMapController()).addNewNode(oldParent, childPosition, selectedNode.isLeft());
        for (NodeModel node : selectedNodes) {
            if (node.getParentNode() != oldParent) {
                UITools.errorMessage(TextUtils.getText("cannot_add_parent_diff_parents"));
                return null;
            }
            if (!node.isRoot()) continue;
            UITools.errorMessage(TextUtils.getText("cannot_add_parent_to_root"));
            return null;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        for (NodeModel node : selectedNodes) {
            mapController.moveNodeAsChild(node, newParent, false, false);
        }
        return newParent;
    }
}

