/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.FirstGroupNode;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.DeleteAction;
import org.freeplane.features.map.mindmapmode.DocuMapAttribute;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.map.mindmapmode.NewChildAction;
import org.freeplane.features.map.mindmapmode.NewFreeNodeAction;
import org.freeplane.features.map.mindmapmode.NewMapViewAction;
import org.freeplane.features.map.mindmapmode.NewPreviousSiblingAction;
import org.freeplane.features.map.mindmapmode.NewSiblingAction;
import org.freeplane.features.map.mindmapmode.NewSummaryAction;
import org.freeplane.features.map.mindmapmode.NodeDownAction;
import org.freeplane.features.map.mindmapmode.NodeUpAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.n3.nanoxml.XMLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMapController
extends MapController {
    public static final int NEW_CHILD = 2;
    public static final int NEW_SIBLING_BEFORE = 4;
    public static final int NEW_SIBLING_BEHIND = 3;
    public static final String RESOURCES_CONVERT_TO_CURRENT_VERSION = "convert_to_current_version";

    public MMapController(ModeController modeController) {
        super(modeController);
        this.createActions();
        this.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                if (ResourceController.getResourceController().getBooleanProperty("display_node_id")) {
                    viewController.addStatusInfo("display_node_id", "ID=" + node.createID(), null);
                }
            }

            public void onDeselect(NodeModel node) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                viewController.addStatusInfo("display_node_id", null, null);
            }
        });
    }

    public NodeModel addNewNode(int newNodeMode) {
        NodeModel newNode;
        this.stopEditing();
        NodeModel targetNode = this.getSelectedNode();
        switch (newNodeMode) {
            case 3: 
            case 4: {
                if (!targetNode.isRoot()) {
                    NodeModel parent = targetNode.getParentNode();
                    int childPosition = parent.getChildPosition(targetNode);
                    if (newNodeMode == 3) {
                        ++childPosition;
                    }
                    if ((newNode = this.addNewNode(parent, childPosition, targetNode.isLeft())) == null) {
                        return null;
                    }
                    this.startEditingAfterSelect(newNode);
                    this.select(newNode);
                    break;
                }
                newNodeMode = 2;
            }
            case 2: {
                int position;
                boolean parentFolded = this.isFolded(targetNode);
                if (parentFolded) {
                    this.setFolded(targetNode, false);
                }
                if ((newNode = this.addNewNode(targetNode, position = ResourceController.getResourceController().getProperty("placenewbranches").equals("last") ? targetNode.getChildCount() : 0, targetNode.isNewChildLeft())) == null) {
                    return null;
                }
                this.startEditingAfterSelect(newNode);
                this.select(newNode);
                break;
            }
            default: {
                newNode = null;
            }
        }
        return newNode;
    }

    private void startEditingAfterSelect(final NodeModel newNode) {
        Component component = Controller.getCurrentController().getMapViewManager().getComponent(newNode);
        if (component == null) {
            return;
        }
        component.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                TextController textController = TextController.getController();
                ((MTextController)textController).edit(newNode, newNode.getParentNode(), true, false, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEditing() {
        ModeController modeController = Controller.getCurrentModeController();
        TextController textController = TextController.getController();
        if (textController instanceof MTextController) {
            ((MTextController)textController).stopEditing();
        }
        if (textController instanceof MTextController) {
            modeController.startTransaction();
            try {
                ((MTextController)TextController.getController()).stopEditing();
            }
            finally {
                modeController.commit();
            }
        }
    }

    public void addNewSummaryNodeStartEditing(int summaryLevel, int start, int end) {
        this.stopEditing();
        MModeController modeController = this.getMModeController();
        IMapSelection selection = modeController.getController().getSelection();
        NodeModel selected = selection.getSelected();
        NodeModel parentNode = selected.getParentNode();
        boolean isLeft = selected.isLeft();
        NodeModel newNode = this.addNewNode(parentNode, end + 1, isLeft);
        SummaryNode summary = modeController.getExtension(SummaryNode.class);
        summary.undoableActivateHook(newNode, summary);
        FirstGroupNode firstGroup = modeController.getExtension(FirstGroupNode.class);
        NodeModel firstNode = (NodeModel)parentNode.getChildAt(start);
        firstGroup.undoableActivateHook(firstNode, firstGroup);
        int level = summaryLevel;
        for (int i = start + 1; i < end; ++i) {
            NodeModel node = (NodeModel)parentNode.getChildAt(i);
            if (isLeft != node.isLeft()) continue;
            level = SummaryNode.isSummaryNode(node) ? ++level : 0;
            if (level != summaryLevel || !SummaryNode.isFirstGroupNode(node)) continue;
            firstGroup.undoableActivateHook(node, firstGroup);
        }
        this.startEditingAfterSelect(newNode);
        this.select(newNode);
    }

    public NodeModel addNewNode(NodeModel parent, int index, boolean newNodeIsLeft) {
        if (!this.isWriteable(parent)) {
            UITools.errorMessage(TextUtils.getText("node_is_write_protected"));
            return null;
        }
        NodeModel newNode = this.newNode("", parent.getMap());
        if (this.addNewNode(newNode, parent, index, newNodeIsLeft)) {
            return newNode;
        }
        return null;
    }

    public boolean addNewNode(final NodeModel newNode, final NodeModel parent, final int index, boolean newNodeIsLeft) {
        if (!this.isWriteable(parent)) {
            UITools.errorMessage(TextUtils.getText("node_is_write_protected"));
            return false;
        }
        MapModel map = parent.getMap();
        newNode.setLeft(newNodeIsLeft);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.insertNodeIntoWithoutUndo(newNode, parent, index);
            }

            public String getDescription() {
                return "addNewNode";
            }

            public void undo() {
                MMapController.this.deleteWithoutUndo(newNode);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
        return true;
    }

    @Override
    public boolean close(MapModel map, boolean force) {
        List<Component> views;
        if (!force && !map.isSaved() && (views = Controller.getCurrentController().getMapViewManager().getViews(map)).size() == 1) {
            boolean savingNotCancelled;
            String text = TextUtils.getText("save_unsaved") + "\n" + map.getTitle();
            String title = TextUtils.getText("SaveAction.text");
            int returnVal = JOptionPane.showOptionDialog(Controller.getCurrentController().getViewController().getContentPane(), text, title, 1, 3, null, null, null);
            if (returnVal == 0 ? !(savingNotCancelled = ((MFileManager)UrlManager.getController()).save(map)) : returnVal == 2 || returnVal == -1) {
                return false;
            }
        }
        return super.close(map, force);
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new NewMapViewAction());
        modeController.addAction(new NewSiblingAction());
        modeController.addAction(new NewPreviousSiblingAction());
        modeController.addAction(new NewChildAction());
        modeController.addAction(new NewSummaryAction());
        modeController.addAction(new NewFreeNodeAction());
        modeController.addAction(new DeleteAction());
        modeController.addAction(new NodeUpAction());
        modeController.addAction(new NodeDownAction());
    }

    public void deleteNode(final NodeModel node) {
        final NodeModel parentNode = node.getParentNode();
        final int index = parentNode.getIndex(node);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.deleteWithoutUndo(node);
            }

            public String getDescription() {
                return "delete";
            }

            public void undo() {
                Controller.getCurrentModeController().getMapController().insertNodeIntoWithoutUndo(node, parentNode, index);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void deleteWithoutUndo(NodeModel selectedNode) {
        NodeModel oldParent = selectedNode.getParentNode();
        this.firePreNodeDelete(oldParent, selectedNode, oldParent.getIndex(selectedNode));
        MapModel map = selectedNode.getMap();
        this.setSaved(map, false);
        oldParent.remove(selectedNode);
        this.fireNodeDeleted(oldParent, selectedNode, oldParent.getIndex(selectedNode));
    }

    public MModeController getMModeController() {
        return (MModeController)Controller.getCurrentModeController();
    }

    public void insertNode(NodeModel node, NodeModel parent) {
        this.insertNode(node, parent, parent.getChildCount());
    }

    public void insertNode(NodeModel node, NodeModel target, boolean asSibling, boolean isLeft, boolean changeSide) {
        NodeModel parent = asSibling ? target.getParentNode() : target;
        if (changeSide) {
            node.setParent(parent);
            node.setLeft(isLeft);
        }
        if (asSibling) {
            this.insertNode(node, parent, parent.getChildPosition(target));
        } else {
            this.insertNode(node, parent, parent.getChildCount());
        }
    }

    public void insertNode(final NodeModel node, final NodeModel parentNode, final int index) {
        IActor actor = new IActor(){

            public void act() {
                Controller.getCurrentModeController().getMapController().insertNodeIntoWithoutUndo(node, parentNode, index);
            }

            public String getDescription() {
                return "insertNode";
            }

            public void undo() {
                ((MMapController)Controller.getCurrentModeController().getMapController()).deleteWithoutUndo(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    @Override
    public void insertNodeIntoWithoutUndo(NodeModel newNode, NodeModel parent, int index) {
        this.setSaved(parent.getMap(), false);
        super.insertNodeIntoWithoutUndo(newNode, parent, index);
    }

    public boolean isWriteable(NodeModel targetNode) {
        EncryptionModel encryptionModel = EncryptionModel.getModel(targetNode);
        if (encryptionModel != null) {
            return encryptionModel.isAccessible();
        }
        return true;
    }

    public void moveNode(NodeModel node, int i) {
        this.moveNode(node, node.getParentNode(), i);
    }

    public void moveNode(NodeModel child, NodeModel newParent, int childCount) {
        this.moveNode(child, newParent, childCount, false, false);
    }

    public void moveNode(final NodeModel child, final NodeModel newParent, final int newIndex, final boolean isLeft, final boolean changeSide) {
        final NodeModel oldParent = child.getParentNode();
        final int oldIndex = oldParent.getChildPosition(child);
        final boolean wasLeft = child.isLeft();
        if (oldParent == newParent && oldIndex == newIndex && !changeSide) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.moveNodeToWithoutUndo(child, newParent, newIndex, isLeft, changeSide);
            }

            public String getDescription() {
                return "moveNode";
            }

            public void undo() {
                MMapController.this.moveNodeToWithoutUndo(child, oldParent, oldIndex, wasLeft, changeSide);
            }
        };
        Controller.getCurrentModeController().execute(actor, newParent.getMap());
    }

    public void moveNodeAsChild(NodeModel node, NodeModel selectedParent, boolean isLeft, boolean changeSide) {
        int position = selectedParent.getChildCount();
        if (node.getParent() == selectedParent) {
            --position;
        }
        FreeNode r = Controller.getCurrentModeController().getExtension(FreeNode.class);
        FreeNode extension = node.getExtension(FreeNode.class);
        if (extension != null) {
            r.undoableToggleHook(node, extension);
            if (MapStyleModel.FLOATING_STYLE.equals(LogicalStyleModel.getStyle(node))) {
                ((MLogicalStyleController)MLogicalStyleController.getController(this.getMModeController())).setStyle(node, null);
            }
        }
        this.moveNode(node, selectedParent, position, isLeft, changeSide);
    }

    public void moveNodeBefore(NodeModel node, NodeModel target, boolean isLeft, boolean changeSide) {
        int oldIndex;
        NodeModel newParent = target.getParentNode();
        NodeModel oldParent = node.getParentNode();
        int newIndex = newParent.getChildPosition(target);
        if (newParent.equals(oldParent) && (oldIndex = oldParent.getChildPosition(node)) < newIndex) {
            --newIndex;
        }
        Controller.getCurrentModeController().getExtension(FreeNode.class).undoableDeactivateHook(node);
        this.moveNode(node, newParent, newIndex, isLeft, changeSide);
    }

    public void moveNodes(NodeModel selected, Collection<NodeModel> movedNodes, final int direction) {
        final ArrayList<NodeModel> mySelecteds = new ArrayList<NodeModel>(movedNodes);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this._moveNodes(mySelecteds, direction);
            }

            public String getDescription() {
                return "moveNodes";
            }

            public void undo() {
                MMapController.this._moveNodes(mySelecteds, -direction);
            }
        };
        Controller.getCurrentModeController().execute(actor, selected.getMap());
    }

    private void _moveNodes(List<NodeModel> movedNodes, int direction) {
        Comparator<Object> comparator;
        Comparator<Object> comparator2 = comparator = direction == -1 ? null : new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return i2 - i1;
            }
        };
        if (movedNodes.size() == 0) {
            return;
        }
        NodeModel selected = this.getSelectedNode();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>(this.getSelectedNodes());
        NodeModel parent = movedNodes.get(0).getParentNode();
        if (parent != null) {
            Vector<NodeModel> sortedChildren = this.getSortedSiblings(parent);
            TreeSet<Object> range = new TreeSet<Object>(comparator);
            for (NodeModel node : movedNodes) {
                if (node.getParent() != parent) {
                    LogUtils.warn("Not all selected nodes have the same parent.");
                    return;
                }
                range.add(new Integer(sortedChildren.indexOf(node)));
            }
            Integer last = (Integer)range.iterator().next();
            for (Integer n : range) {
                if (Math.abs(n - last) > 1) {
                    LogUtils.warn("Not adjacent nodes. Skipped. ");
                    return;
                }
                last = n;
            }
            for (Integer n : range) {
                NodeModel node = sortedChildren.get(n);
                this.moveNodeTo(node, direction);
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            selection.selectAsTheOnlyOneSelected(selected);
            for (NodeModel selectedNode : selectedNodes) {
                selection.makeTheSelected(selectedNode);
            }
        }
    }

    private int moveNodeTo(NodeModel child, int direction) {
        int index;
        NodeModel parent = child.getParentNode();
        int newIndex = index = parent.getIndex(child);
        int maxIndex = parent.getChildCount();
        Vector<NodeModel> sortedNodesIndices = this.getSortedSiblings(parent);
        int newPositionInVector = sortedNodesIndices.indexOf(child) + direction;
        if (newPositionInVector < 0) {
            newPositionInVector = maxIndex - 1;
        }
        if (newPositionInVector >= maxIndex) {
            newPositionInVector = 0;
        }
        NodeModel destinationNode = sortedNodesIndices.get(newPositionInVector);
        newIndex = parent.getIndex(destinationNode);
        ((MMapController)Controller.getCurrentModeController().getMapController()).moveNodeToWithoutUndo(child, parent, newIndex, false, false);
        return newIndex;
    }

    private Vector<NodeModel> getSortedSiblings(NodeModel node) {
        Vector<NodeModel> nodes = new Vector<NodeModel>();
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            nodes.add(child);
        }
        if (!node.isRoot()) {
            return nodes;
        }
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(node.getMap());
        MapViewLayout layoutType = mapStyleModel.getMapViewLayout();
        if (layoutType.equals((Object)MapViewLayout.OUTLINE)) {
            return nodes;
        }
        Collections.sort(nodes, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof NodeModel) {
                    NodeModel n1 = (NodeModel)o1;
                    if (o2 instanceof NodeModel) {
                        NodeModel n2 = (NodeModel)o2;
                        int b1 = n1.isLeft() ? 0 : 1;
                        int b2 = n2.isLeft() ? 0 : 1;
                        return b1 - b2;
                    }
                }
                throw new IllegalArgumentException("Elements in LeftRightComparator are not comparable.");
            }
        });
        return nodes;
    }

    int moveNodeToWithoutUndo(NodeModel child, NodeModel newParent, int newIndex, boolean isLeft, boolean changeSide) {
        NodeModel oldParent = child.getParentNode();
        int oldIndex = oldParent.getIndex(child);
        this.firePreNodeMoved(oldParent, oldIndex, newParent, child, newIndex);
        oldParent.remove(child);
        if (changeSide) {
            child.setParent(newParent);
            child.setLeft(isLeft);
        }
        newParent.insert(child, newIndex);
        this.fireNodeMoved(oldParent, oldIndex, newParent, child, newIndex);
        this.setSaved(newParent.getMap(), false);
        return newIndex;
    }

    public MapModel newModel(NodeModel existingNode) {
        if (existingNode == null) {
            throw new NullPointerException("null node not allowed.");
        }
        MMapModel mindMapMapModel = new MMapModel();
        mindMapMapModel.setRoot(existingNode);
        mindMapMapModel.registryNodeRecursive(existingNode);
        this.fireMapCreated(mindMapMapModel);
        return mindMapMapModel;
    }

    @Override
    public MapModel newModel() {
        MMapModel mindMapMapModel = new MMapModel();
        mindMapMapModel.createNewRoot();
        this.fireMapCreated(mindMapMapModel);
        return mindMapMapModel;
    }

    @Override
    public void setSaved(MapModel mapModel, boolean saved) {
        boolean setTitle = saved != mapModel.isSaved();
        mapModel.setSaved(saved);
        if (setTitle) {
            Controller controller = Controller.getCurrentController();
            controller.getMapViewManager().setTitle();
            AFreeplaneAction saveAction = controller.getModeController().getAction("SaveAction");
            if (saveAction != null) {
                saveAction.setEnabled();
            }
        }
    }

    public NodeModel addFreeNode(Point pt, boolean newNodeIsLeft) {
        NodeModel target;
        NodeModel targetNode;
        boolean parentFolded;
        ModeController modeController = Controller.getCurrentModeController();
        final TextController textController = TextController.getController();
        if (textController instanceof MTextController) {
            ((MTextController)textController).stopEditing();
            modeController.forceNewTransaction();
        }
        if (parentFolded = this.isFolded(targetNode = (target = this.getRootNode()))) {
            this.setFolded(targetNode, false);
        }
        if (!this.isWriteable(target)) {
            UITools.errorMessage(TextUtils.getText("node_is_write_protected"));
            return null;
        }
        final NodeModel newNode = this.newNode("", target.getMap());
        LogicalStyleModel.createExtension(newNode).setStyle(MapStyleModel.FLOATING_STYLE);
        newNode.addExtension(modeController.getExtension(FreeNode.class));
        if (!this.addNewNode(newNode, target, -1, newNodeIsLeft)) {
            return null;
        }
        ((MLocationController)MLocationController.getController(modeController)).moveNodePosition(newNode, -1, pt.x, pt.y);
        Component component = Controller.getCurrentController().getMapViewManager().getComponent(newNode);
        if (component == null) {
            return newNode;
        }
        component.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                ((MTextController)textController).edit(newNode, targetNode, true, false, false);
            }
        });
        this.select(newNode);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean newUntitledMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        try {
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            MMapModel newModel = new MMapModel();
            UrlManager.getController().load(url, newModel);
            newModel.setURL(null);
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public boolean newMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        MFileManager fileManager;
        if (this.getMModeController().containsExtension(DocuMapAttribute.class)) {
            return this.newDocumentationMap(url);
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager.tryToChangeToMapView(url)) {
            return false;
        }
        if (AddOnsController.getController().installIfAppropriate(url)) {
            return false;
        }
        URL alternativeURL = null;
        try {
            File file = Compat.urlToFile(url);
            if (file == null) {
                alternativeURL = url;
            } else if (file.exists()) {
                fileManager = MFileManager.getController(this.getMModeController());
                File alternativeFile = fileManager.getAlternativeFile(file, MFileManager.AlternativeFileMode.AUTOSAVE);
                if (alternativeFile == null) return false;
                alternativeURL = Compat.fileToUrl(alternativeFile);
            } else {
                alternativeURL = url;
            }
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (alternativeURL == null) {
            return false;
        }
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            MMapModel newModel = new MMapModel();
            fileManager = MFileManager.getController(this.getMModeController());
            fileManager.loadAndLock(alternativeURL, newModel);
            newModel.setURL(url);
            newModel.setSaved(alternativeURL.equals(url));
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean newDocumentationMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager.tryToChangeToMapView(url)) {
            return false;
        }
        try {
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            MMapModel newModel = new MMapModel();
            newModel.addExtension(DocuMapAttribute.instance);
            UrlManager.getController().load(url, newModel);
            newModel.setReadOnly(true);
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean restoreCurrentMap() throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        URL url = map.getURL();
        if (url == null) {
            UITools.errorMessage(TextUtils.getText("map_not_saved"));
            return false;
        }
        if (map.containsExtension(DocuMapAttribute.class)) {
            controller.close(true);
            return this.newDocumentationMap(url);
        }
        URL alternativeURL = MFileManager.getController(this.getMModeController()).getAlternativeURL(url, MFileManager.AlternativeFileMode.ALL);
        if (alternativeURL == null) {
            return false;
        }
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            MMapModel newModel = new MMapModel();
            ((MFileManager)MFileManager.getController()).loadAndLock(alternativeURL, newModel);
            newModel.setURL(url);
            newModel.setSaved(alternativeURL.equals(url));
            this.fireMapCreated(newModel);
            controller.close(true);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }
}

