/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

class SetLinkByTextFieldAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SetLinkByTextFieldAction() {
        super("SetLinkByTextFieldAction");
    }

    public void actionPerformed(ActionEvent e) {
        String inputValue;
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel selectedNode = modeController.getMapController().getSelectedNode();
        String linkAsString = NodeLinks.getLinkAsString(selectedNode);
        if (Compat.isWindowsOS() && linkAsString != null && linkAsString.startsWith("smb:")) {
            URI link = NodeLinks.getValidLink(selectedNode);
            linkAsString = Compat.smbUri2unc(link);
        }
        if (linkAsString == null || "".equals(linkAsString)) {
            linkAsString = "http://";
            ClipboardController clipboardController = modeController.getExtension(ClipboardController.class);
            Transferable t = clipboardController.getClipboardContents();
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String plainTextFromClipboard = t.getTransferData(DataFlavor.stringFlavor).toString().trim();
                    new URI(plainTextFromClipboard);
                    linkAsString = plainTextFromClipboard;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((inputValue = UITools.showInputDialog(Controller.getCurrentController().getSelection().getSelected(), TextUtils.getText("edit_link_manually"), linkAsString)) != null && !inputValue.matches("\\w+://")) {
            MLinkController linkController = (MLinkController)MLinkController.getController();
            if (inputValue.equals("")) {
                linkController.setLink(selectedNode, (URI)null, 0);
                return;
            }
            try {
                URI link = LinkController.createURI(inputValue.trim());
                linkController.setLink(selectedNode, link, 0);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn(e1);
                UITools.errorMessage(TextUtils.format("invalid_uri", inputValue));
                return;
            }
        }
    }
}

