/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.MindIconFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class SelectMenuItemDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String SELECTION_ROOT_KEY = "/menu_bar";
    private static final Dimension DIALOG_DIMENSION = new Dimension(350, 350);
    private JButton btnOK;
    private final JTree tree;
    private MenuUtils.MenuEntry menuItem;

    public SelectMenuItemDialog(NodeModel node) {
        super(UITools.getFrame(), TextUtils.getText("select_menu_item_dialog"), true);
        Controller.getCurrentController().getMapViewManager().scrollNodeToVisible(node);
        UITools.setDialogLocationRelativeTo((JDialog)this, node);
        this.setSize(DIALOG_DIMENSION);
        this.setDefaultCloseOperation(2);
        UITools.addEscapeActionToDialog(this);
        this.tree = this.createTree();
        this.getContentPane().add(new JScrollPane(this.tree));
        this.getContentPane().add((Component)this.createButtonBar(), "South");
        this.getRootPane().setDefaultButton(this.btnOK);
        this.setVisible(true);
    }

    public MenuUtils.MenuEntry getMenuItem() {
        return this.menuItem;
    }

    private Box createButtonBar() {
        Box controllerBox = Box.createHorizontalBox();
        controllerBox.setBorder(new EmptyBorder(5, 0, 5, 0));
        CloseAction closeAction = new CloseAction();
        this.btnOK = this.createButton("ok", closeAction);
        JButton btnCancel = this.createButton("cancel", closeAction);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(this.btnOK);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(btnCancel);
        controllerBox.add(Box.createHorizontalGlue());
        return controllerBox;
    }

    private JButton createButton(String key, CloseAction closeAction) {
        JButton button = new JButton();
        MenuBuilder.setLabelAndMnemonic(button, TextUtils.getRawText(key));
        button.addActionListener(closeAction);
        button.setMaximumSize(new Dimension(1000, 1000));
        return button;
    }

    private JTree createTree() {
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        MenuBuilder menuBuilder = modeController.getUserInputListenerFactory().getMenuBuilder();
        DefaultMutableTreeNode treeRoot = MenuUtils.createMenuEntryTree(SELECTION_ROOT_KEY, menuBuilder);
        if (treeRoot.getUserObject() == null) {
            treeRoot.setUserObject(new MenuUtils.MenuEntry(null, TextUtils.getText("select_menu_item_root_node")));
        }
        JTree jTree = new JTree(treeRoot);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setCellRenderer(new MenuIconRenderer());
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SelectMenuItemDialog.this.tree.getLastSelectedPathComponent();
                SelectMenuItemDialog.this.btnOK.setEnabled(node != null && node.isLeaf());
            }
        });
        jTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && SelectMenuItemDialog.this.btnOK.isEnabled()) {
                    SelectMenuItemDialog.this.btnOK.doClick();
                }
            }
        });
        return jTree;
    }

    private class MenuIconRenderer
    extends DefaultTreeCellRenderer {
        private static final String DEFAULT_ICON = "button";
        private static final long serialVersionUID = 1L;

        public MenuIconRenderer() {
            this.setOpenIcon(null);
            this.setClosedIcon(null);
            this.setLeafIcon(MindIconFactory.create(DEFAULT_ICON).getIcon());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MindIcon mindIcon;
            DefaultMutableTreeNode node;
            MenuUtils.MenuEntry menuEntry;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && (menuEntry = (MenuUtils.MenuEntry)(node = (DefaultMutableTreeNode)value).getUserObject()).getIconKey() != null && (mindIcon = menuEntry.createMindIcon()) != null) {
                this.setIcon(mindIcon.getIcon());
            }
            return this;
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == SelectMenuItemDialog.this.btnOK) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)SelectMenuItemDialog.this.tree.getLastSelectedPathComponent();
                if (selectedNode != null && selectedNode.isLeaf()) {
                    SelectMenuItemDialog.this.menuItem = (MenuUtils.MenuEntry)selectedNode.getUserObject();
                    SelectMenuItemDialog.this.dispose();
                }
            } else {
                SelectMenuItemDialog.this.dispose();
            }
        }
    }
}

