/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.HyperTextLinkModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.LinkModel;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.AddConnectorAction;
import org.freeplane.features.link.mindmapmode.AddLocalLinkAction;
import org.freeplane.features.link.mindmapmode.AddMenuItemLinkAction;
import org.freeplane.features.link.mindmapmode.ChangeConnectorArrowsAction;
import org.freeplane.features.link.mindmapmode.ChangeConnectorDashAction;
import org.freeplane.features.link.mindmapmode.ChangeConnectorShapeAction;
import org.freeplane.features.link.mindmapmode.ClearLinkAnchorAction;
import org.freeplane.features.link.mindmapmode.ConnectorColorAction;
import org.freeplane.features.link.mindmapmode.ExtractLinkFromTextAction;
import org.freeplane.features.link.mindmapmode.MakeLinkFromAnchorAction;
import org.freeplane.features.link.mindmapmode.MakeLinkToAnchorAction;
import org.freeplane.features.link.mindmapmode.RemoveConnectorAction;
import org.freeplane.features.link.mindmapmode.SetLinkAnchorAction;
import org.freeplane.features.link.mindmapmode.SetLinkByFileChooserAction;
import org.freeplane.features.link.mindmapmode.SetLinkByTextFieldAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.DocuMapAttribute;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.url.UrlManager;

public class MLinkController
extends LinkController {
    private static SetLinkByFileChooserAction setLinkByFileChooser;
    private static SetLinkByTextFieldAction setLinkByTextField;
    private String anchorID;
    private final ModeController modeController;

    public MLinkController(ModeController modeController) {
        this.modeController = modeController;
        this.anchorID = "";
    }

    protected void init() {
        super.init();
        this.createActions();
        this.modeController.registerExtensionCopier(new StyleCopier());
        this.modeController.getMapController().addMapChangeListener(new NodeDeletionListener());
    }

    public ConnectorModel addConnector(NodeModel source, NodeModel target) {
        return this.addConnector(source, target.createID());
    }

    public void changeArrowsOfArrowLink(final ConnectorModel link, final ArrowType startArrow, final ArrowType endArrow) {
        IActor actor = new IActor(){
            private final ArrowType oldEndArrow;
            private final ArrowType oldStartArrow;
            {
                this.oldEndArrow = link.getEndArrow();
                this.oldStartArrow = link.getStartArrow();
            }

            public void act() {
                link.setStartArrow(startArrow);
                link.setEndArrow(endArrow);
                Controller.getCurrentModeController().getMapController().nodeChanged(link.getSource());
            }

            public String getDescription() {
                return "changeArrowsOfArrowLink";
            }

            public void undo() {
                link.setStartArrow(this.oldStartArrow);
                link.setEndArrow(this.oldEndArrow);
                Controller.getCurrentModeController().getMapController().nodeChanged(link.getSource());
            }
        };
        Controller.getCurrentModeController().execute(actor, link.getSource().getMap());
    }

    private void createActions() {
        setLinkByFileChooser = new SetLinkByFileChooserAction();
        this.modeController.addAction(setLinkByFileChooser);
        AddConnectorAction addArrowLinkAction = new AddConnectorAction();
        this.modeController.addAction(addArrowLinkAction);
        setLinkByTextField = new SetLinkByTextFieldAction();
        this.modeController.addAction(setLinkByTextField);
        this.modeController.addAction(new AddLocalLinkAction());
        this.modeController.addAction(new AddMenuItemLinkAction());
        this.modeController.addAction(new ExtractLinkFromTextAction());
        this.modeController.addAction(new SetLinkAnchorAction());
        this.modeController.addAction(new MakeLinkToAnchorAction());
        this.modeController.addAction(new MakeLinkFromAnchorAction());
        this.modeController.addAction(new ClearLinkAnchorAction());
    }

    protected void createArrowLinkPopup(final ConnectorModel link, final JComponent arrowLinkPopup) {
        super.createArrowLinkPopup(link, arrowLinkPopup);
        this.addAction(arrowLinkPopup, new RemoveConnectorAction(this, link));
        this.addSeparator(arrowLinkPopup);
        this.addAction(arrowLinkPopup, new ConnectorColorAction(this, link));
        final JSlider transparencySlider = new JSlider(20, 255, link.getAlpha());
        transparencySlider.setMinorTickSpacing(20);
        transparencySlider.setPaintTicks(true);
        transparencySlider.setSnapToTicks(true);
        transparencySlider.setPaintTrack(true);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("edit_transparency_label"), transparencySlider);
        this.addSeparator(arrowLinkPopup);
        AFreeplaneAction[] arrowActions = new AFreeplaneAction[]{new ChangeConnectorArrowsAction(this, "none", link, ArrowType.NONE, ArrowType.NONE), new ChangeConnectorArrowsAction(this, "forward", link, ArrowType.NONE, ArrowType.DEFAULT), new ChangeConnectorArrowsAction(this, "backward", link, ArrowType.DEFAULT, ArrowType.NONE), new ChangeConnectorArrowsAction(this, "both", link, ArrowType.DEFAULT, ArrowType.DEFAULT)};
        JComboBox connectorArrows = this.createActionBox(arrowActions);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("connector_arrows"), connectorArrows);
        boolean twoNodesConnector = !link.getSource().equals(link.getTarget());
        AFreeplaneAction[] shapeActions = twoNodesConnector ? new AFreeplaneAction[]{new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.CUBIC_CURVE), new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.LINE), new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.LINEAR_PATH), new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.EDGE_LIKE)} : new AFreeplaneAction[]{new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.CUBIC_CURVE), new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.LINE), new ChangeConnectorShapeAction(this, link, ConnectorModel.Shape.LINEAR_PATH)};
        JComboBox connectorShapes = this.createActionBox(shapeActions);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("connector_shapes"), connectorShapes);
        AFreeplaneAction[] dashActions = new AFreeplaneAction[]{new ChangeConnectorDashAction(this, link, null), new ChangeConnectorDashAction(this, link, new int[]{3, 3}), new ChangeConnectorDashAction(this, link, new int[]{7, 7}), new ChangeConnectorDashAction(this, link, new int[]{2, 7}), new ChangeConnectorDashAction(this, link, new int[]{2, 7, 7, 7})};
        JComboBox connectorDashes = this.createActionBox(dashActions);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("connector_lines"), connectorDashes);
        final SpinnerNumberModel widthModel = new SpinnerNumberModel(link.getWidth(), 1, 32, 1);
        JSpinner widthSpinner = new JSpinner(widthModel);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("edit_width_label"), widthSpinner);
        this.addSeparator(arrowLinkPopup);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envFonts = gEnv.getAvailableFontFamilyNames();
        DefaultComboBoxModel<String> fonts = new DefaultComboBoxModel<String>(envFonts);
        fonts.setSelectedItem(link.getLabelFontFamily());
        JComboBox<String> fontBox = new JComboBox<String>(fonts);
        fontBox.setEditable(false);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("edit_label_font_family"), fontBox);
        fontBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (item != null) {
                    MLinkController.this.setLabelFontFamily(link, item.toString());
                }
            }
        });
        Integer[] sizes = new Integer[]{4, 6, 8, 10, 12, 14, 16, 18, 24, 36};
        DefaultComboBoxModel<Integer> sizesModel = new DefaultComboBoxModel<Integer>(sizes);
        sizesModel.setSelectedItem(link.getLabelFontSize());
        JComboBox<Integer> sizesBox = new JComboBox<Integer>(sizesModel);
        sizesBox.setEditable(true);
        this.addPopupComponent(arrowLinkPopup, TextUtils.getText("edit_label_font_size"), sizesBox);
        sizesBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object item;
                if (arrowLinkPopup.isVisible()) {
                    arrowLinkPopup.setVisible(false);
                }
                if ((item = e.getItem()) != null) {
                    int size;
                    if (item instanceof Integer) {
                        size = (Integer)item;
                    } else {
                        try {
                            size = Integer.valueOf(item.toString());
                            if (size <= 0) {
                                return;
                            }
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                    }
                    MLinkController.this.setLabelFontSize(link, size);
                }
            }
        });
        final JTextArea sourceLabelEditor = new JTextArea(link.getSourceLabel());
        this.addTextEditor(arrowLinkPopup, "edit_source_label", sourceLabelEditor);
        final JTextArea middleLabelEditor = new JTextArea(link.getMiddleLabel());
        this.addTextEditor(arrowLinkPopup, "edit_middle_label", middleLabelEditor);
        final JTextArea targetLabelEditor = new JTextArea(link.getTargetLabel());
        this.addTextEditor(arrowLinkPopup, "edit_target_label", targetLabelEditor);
        arrowLinkPopup.addHierarchyListener(new HierarchyListener(){
            private Component focusOwner;
            private Window dialog;

            public void hierarchyChanged(HierarchyEvent e) {
                final JComponent component = (JComponent)e.getComponent();
                if (component.isShowing()) {
                    if (this.dialog == null) {
                        this.dialog = SwingUtilities.getWindowAncestor(component);
                        this.dialog.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                component.putClientProperty("CANCEL", Boolean.TRUE);
                            }
                        });
                    }
                    if (this.focusOwner == null) {
                        this.focusOwner = FocusManager.getCurrentManager().getFocusOwner();
                    }
                    return;
                }
                if (this.focusOwner == null || !this.focusOwner.isShowing()) {
                    return;
                }
                this.focusOwner.requestFocus();
                if (Boolean.TRUE.equals(component.getClientProperty("CANCEL"))) {
                    return;
                }
                IMapSelection selection = Controller.getCurrentController().getSelection();
                if (selection == null || selection.getSelected() == null) {
                    return;
                }
                MLinkController.this.setSourceLabel(link, sourceLabelEditor.getText());
                MLinkController.this.setTargetLabel(link, targetLabelEditor.getText());
                MLinkController.this.setMiddleLabel(link, middleLabelEditor.getText());
                MLinkController.this.setAlpha(link, transparencySlider.getValue());
                MLinkController.this.setWidth(link, widthModel.getNumber().intValue());
            }
        });
    }

    protected JComboBox createActionBox(AFreeplaneAction[] items) {
        JComboBox<Object> box = new JComboBox<Object>();
        box.setEditable(false);
        box.setModel(new DefaultComboBoxModel<AFreeplaneAction>(items));
        for (AFreeplaneAction item : items) {
            if (!item.isSelected()) continue;
            box.setSelectedItem(item);
            break;
        }
        box.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Action action = (Action)value;
                Icon icon = (Icon)action.getValue("SmallIcon");
                String text = (String)action.getValue("Name");
                Object renderedValue = text == null ? icon : text;
                DefaultListCellRenderer renderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, renderedValue, index, isSelected, cellHasFocus);
                if (text != null && icon != null) {
                    renderer.setIcon(icon);
                }
                return renderer;
            }
        });
        box.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AFreeplaneAction item = (AFreeplaneAction)e.getItem();
                JComboBox box = (JComboBox)e.getSource();
                item.actionPerformed(new ActionEvent(box, 1001, null));
                SwingUtilities.getWindowAncestor(box).setVisible(false);
            }
        });
        return box;
    }

    private void addSeparator(JComponent arrowLinkPopup) {
    }

    private void addTextEditor(JComponent popup, String label, JTextArea editor) {
        InputMap inputMap = editor.getInputMap();
        ActionMap actionMap = editor.getActionMap();
        boolean enterConfirms = ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default");
        KeyStroke close = KeyStroke.getKeyStroke(enterConfirms ? "ENTER" : "alt ENTER");
        inputMap.put(close, "CLOSE");
        actionMap.put("CLOSE", new LinkController.ClosePopupAction("CLOSE"));
        KeyStroke enter = KeyStroke.getKeyStroke(!enterConfirms ? "ENTER" : "alt ENTER");
        KeyStroke enter2 = KeyStroke.getKeyStroke("shift ENTER");
        inputMap.put(enter, "INSERT_EOL");
        inputMap.put(enter2, "INSERT_EOL");
        actionMap.put("INSERT_EOL", new UITools.InsertEolAction());
        editor.setRows(5);
        editor.setColumns(30);
        final JPopupMenu popupMenu = new JPopupMenu();
        SpellCheckerController spellCheckerController = SpellCheckerController.getController();
        spellCheckerController.addSpellCheckerMenu(popupMenu);
        spellCheckerController.enableAutoSpell(editor, true);
        editor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            private void handlePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(editor, 22, 32);
        this.addPopupComponent(popup, TextUtils.getText(label), scrollPane);
    }

    public void setConnectorColor(final ConnectorModel arrowLink, final Color color) {
        final Color oldColor = arrowLink.getColor();
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                arrowLink.setColor(color);
                NodeModel node = arrowLink.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorColor";
            }

            public void undo() {
                arrowLink.setColor(oldColor);
                NodeModel node = arrowLink.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, arrowLink.getSource().getMap());
    }

    public void setConnectorDash(final ConnectorModel arrowLink, final int[] dash) {
        final int[] oldDash = arrowLink.getDash();
        if (dash == oldDash || dash != null && dash.equals(oldDash)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                arrowLink.setDash(dash);
                NodeModel node = arrowLink.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorDash";
            }

            public void undo() {
                arrowLink.setDash(oldDash);
                NodeModel node = arrowLink.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, arrowLink.getSource().getMap());
    }

    public void setArrowLinkEndPoints(final ConnectorModel link, final Point startPoint, final Point endPoint) {
        IActor actor = new IActor(){
            private final Point oldEndPoint;
            private final Point oldStartPoint;
            {
                this.oldEndPoint = link.getEndInclination();
                this.oldStartPoint = link.getStartInclination();
            }

            public void act() {
                link.setStartInclination(startPoint);
                link.setEndInclination(endPoint);
                Controller.getCurrentModeController().getMapController().nodeChanged(link.getSource());
            }

            public String getDescription() {
                return "setArrowLinkEndPoints";
            }

            public void undo() {
                link.setStartInclination(this.oldStartPoint);
                link.setEndInclination(this.oldEndPoint);
                Controller.getCurrentModeController().getMapController().nodeChanged(link.getSource());
            }
        };
        Controller.getCurrentModeController().execute(actor, link.getSource().getMap());
    }

    public void setLink(NodeModel node, String link, int linkType) {
        if (link != null && !"".equals(link)) {
            try {
                URI uri = new URI(link);
                this.setLink(node, uri, linkType);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            return;
        }
        this.setLink(node, (URI)null, 0);
    }

    private URI relativeLink(URI argUri, NodeModel node, int linkType) {
        if (linkType != 0 && "file".equals(argUri.getScheme())) {
            try {
                File mapFile = node.getMap().getFile();
                return LinkController.toRelativeURI(mapFile, new File(argUri), linkType);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return argUri;
    }

    public void setLinkTypeDependantLink(NodeModel node, URI argUri) {
        this.setLink(node, argUri, MLinkController.getLinkType());
    }

    public void setLinkTypeDependantLink(NodeModel node, File file) {
        this.setLink(node, file.toURI(), MLinkController.getLinkType());
    }

    public void setLinkTypeDependantLink(NodeModel node, String link) {
        this.setLink(node, link, MLinkController.getLinkType());
    }

    public void setLink(final NodeModel node, URI argUri, int linkType) {
        final URI uri = this.relativeLink(argUri, node, linkType);
        IActor actor = new IActor(){
            private URI oldlink;
            private String oldTargetID;

            public void act() {
                NodeLinks links = NodeLinks.getLinkExtension(node);
                if (links != null) {
                    this.oldlink = links.getHyperLink();
                    this.oldTargetID = links.removeLocalHyperLink(node);
                } else {
                    links = NodeLinks.createLinkExtension(node);
                }
                if (uri != null && uri.toString().startsWith("#")) {
                    links.setLocalHyperlink(node, uri.toString().substring(1));
                }
                URI oldHyperLink = links.getHyperLink();
                links.setHyperLink(uri);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeModel.HYPERLINK_CHANGED, oldHyperLink, uri);
            }

            public String getDescription() {
                return "setLink";
            }

            public void undo() {
                NodeLinks links = NodeLinks.getLinkExtension(node);
                links.setLocalHyperlink(node, this.oldTargetID);
                links.setHyperLink(this.oldlink);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void setLinkByFileChooser() {
        setLinkByFileChooser.setLinkByFileChooser();
    }

    public void setMiddleLabel(ConnectorModel model, String label) {
        String oldLabel;
        if ("".equals(label)) {
            label = null;
        }
        if ("".equals(oldLabel = model.getMiddleLabel())) {
            oldLabel = null;
        }
        if (label == oldLabel || label != null && label.equals(oldLabel)) {
            return;
        }
        MiddleLabelSetter actor = new MiddleLabelSetter(model, oldLabel, label);
        Controller.getCurrentModeController().execute(actor, model.getSource().getMap());
    }

    public void setSourceLabel(ConnectorModel model, String label) {
        String oldLabel;
        if ("".equals(label)) {
            label = null;
        }
        if ("".equals(oldLabel = model.getSourceLabel())) {
            oldLabel = null;
        }
        if (label == oldLabel || label != null && label.equals(oldLabel)) {
            return;
        }
        SourceLabelSetter actor = new SourceLabelSetter(model, label, oldLabel);
        Controller.getCurrentModeController().execute(actor, model.getSource().getMap());
    }

    public void setTargetLabel(ConnectorModel model, String label) {
        String oldLabel;
        if ("".equals(label)) {
            label = null;
        }
        if ("".equals(oldLabel = model.getTargetLabel())) {
            oldLabel = null;
        }
        if (label == oldLabel || label != null && label.equals(oldLabel)) {
            return;
        }
        TargetLabelSetter actor = new TargetLabelSetter(oldLabel, label, model);
        Controller.getCurrentModeController().execute(actor, model.getSource().getMap());
    }

    public ConnectorModel addConnector(NodeModel source, String targetID) {
        CreateArrowLinkActor actor = new CreateArrowLinkActor(targetID, source);
        Controller.getCurrentModeController().execute(actor, source.getMap());
        return actor.getArrowLink();
    }

    public void removeArrowLink(final NodeLinkModel arrowLink) {
        IActor actor = new IActor(){

            public void act() {
                NodeModel source = arrowLink.getSource();
                NodeLinks nodeLinks = source.getExtension(NodeLinks.class);
                nodeLinks.removeArrowlink(arrowLink);
                Controller.getCurrentModeController().getMapController().nodeChanged(source);
            }

            public String getDescription() {
                return "removeArrowLink";
            }

            public void undo() {
                NodeModel source = arrowLink.getSource();
                NodeLinks nodeLinks = source.getExtension(NodeLinks.class);
                if (nodeLinks == null) {
                    nodeLinks = new NodeLinks();
                    source.addExtension(nodeLinks);
                }
                nodeLinks.addArrowlink(arrowLink);
                Controller.getCurrentModeController().getMapController().nodeChanged(source);
            }
        };
        Controller.getCurrentModeController().execute(actor, arrowLink.getSource().getMap());
    }

    public void setShape(final ConnectorModel connector, final ConnectorModel.Shape shape) {
        final ConnectorModel.Shape oldShape = connector.getShape();
        if (oldShape.equals((Object)shape)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setShape(shape);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorShape";
            }

            public void undo() {
                connector.setShape(oldShape);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setWidth(final ConnectorModel connector, final int width) {
        final int oldWidth = connector.getWidth();
        if (oldWidth == width) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setWidth(width);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorWidth";
            }

            public void undo() {
                connector.setWidth(oldWidth);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setLabelFontSize(final ConnectorModel connector, final int width) {
        final int oldWidth = connector.getLabelFontSize();
        if (oldWidth == width) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setLabelFontSize(width);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorWidth";
            }

            public void undo() {
                connector.setLabelFontSize(oldWidth);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setLabelFontFamily(final ConnectorModel connector, final String family) {
        final String oldFamily = connector.getLabelFontFamily();
        if (oldFamily.equals(family)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setLabelFontFamily(family);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorWidth";
            }

            public void undo() {
                connector.setLabelFontFamily(oldFamily);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void setAlpha(final ConnectorModel connector, final int alpha) {
        final int oldAlpha = connector.getAlpha();
        if (oldAlpha == alpha) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                connector.setAlpha(alpha);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setConnectorAlpha";
            }

            public void undo() {
                connector.setAlpha(oldAlpha);
                NodeModel node = connector.getSource();
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, connector.getSource().getMap());
    }

    public void loadURI(URI uri) {
        UrlManager.getController().loadURL(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadURL(NodeModel node, ActionEvent e) {
        boolean addDocuMapAttribute;
        boolean bl = addDocuMapAttribute = node.getMap().containsExtension(DocuMapAttribute.class) && !this.modeController.containsExtension(DocuMapAttribute.class);
        if (addDocuMapAttribute) {
            this.modeController.addExtension(DocuMapAttribute.class, DocuMapAttribute.instance);
        }
        try {
            super.loadURL(node, e);
        }
        finally {
            if (addDocuMapAttribute) {
                this.modeController.removeExtension(DocuMapAttribute.class);
            }
        }
    }

    public String getAnchorID() {
        return this.anchorID;
    }

    public void setAnchorID(String anchorID) {
        this.anchorID = anchorID;
        AFreeplaneAction setLinkAnchorAction = this.modeController.getAction("SetLinkAnchorAction");
        boolean anchored = this.isAnchored();
        String tooltip = anchored ? TextUtils.format(setLinkAnchorAction.getTooltipKey() + "_anchored", anchorID) : TextUtils.getRawText(setLinkAnchorAction.getTooltipKey());
        setLinkAnchorAction.putValue("ShortDescription", tooltip);
        setLinkAnchorAction.putValue("LongDescription", tooltip);
        setLinkAnchorAction.setSelected(anchored);
        this.modeController.getAction("ClearLinkAnchorAction").setEnabled(anchored);
        this.modeController.getAction("MakeLinkToAnchorAction").setEnabled(anchored);
        this.modeController.getAction("MakeLinkFromAnchorAction").setEnabled(anchored);
    }

    public boolean isAnchored() {
        return this.anchorID != null;
    }

    public String getAnchorIDforNode(NodeModel node) {
        String link;
        String targetID = this.getAnchorID();
        if (targetID != null && !targetID.matches("\\w+://")) {
            String targetMapFileName = targetID.substring(targetID.indexOf("/") + 1, targetID.indexOf("#"));
            File sourceMapFile = node.getMap().getFile();
            if (sourceMapFile == null) {
                UITools.errorMessage(TextUtils.getRawText("map_not_saved"));
                return null;
            }
            String sourceMapFileNameURI = sourceMapFile.toURI().toString();
            link = sourceMapFileNameURI.substring(sourceMapFileNameURI.indexOf("/") + 1).equals(targetMapFileName) ? targetID.substring(targetID.indexOf("#")) : targetID;
        } else {
            link = null;
        }
        return link;
    }

    public void setFormatNodeAsHyperlink(final NodeModel node, final Boolean enabled) {
        final NodeLinks links = NodeLinks.createLinkExtension(node);
        IActor actor = new IActor(){
            final Boolean old;
            {
                this.old = links.formatNodeAsHyperlink();
            }

            public void act() {
                links.setFormatNodeAsHyperlink(enabled);
                MLinkController.this.modeController.getMapController().nodeChanged(node);
            }

            public void undo() {
                links.setFormatNodeAsHyperlink(this.old);
                MLinkController.this.modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFormatNodeAsHyperlink";
            }
        };
        this.modeController.execute(actor, node.getMap());
    }

    private final class NodeDeletionListener
    implements IMapChangeListener {
        private NodeDeletionListener() {
        }

        public void mapChanged(MapChangeEvent event) {
        }

        public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
        }

        public void onNodeInserted(NodeModel parent, final NodeModel child, int newIndex) {
            if (((MModeController)Controller.getCurrentModeController()).isUndoAction()) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    NodeDeletionListener.this.onChange(child, false);
                }
            });
        }

        public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        }

        public void onPreNodeDelete(NodeModel oldParent, NodeModel model, int oldIndex) {
            this.onChange(model, true);
        }

        private void onChange(NodeModel model, boolean delete) {
            if (((MModeController)Controller.getCurrentModeController()).isUndoAction()) {
                return;
            }
            MapModel map = model.getMap();
            MapLinks links = map.getExtension(MapLinks.class);
            if (links == null) {
                return;
            }
            this.removeLinksForDeletedSource(links, model, delete);
            this.removeLinksForDeletedTarget(links, model);
        }

        private void removeLinksForDeletedSource(final MapLinks links, NodeModel model, final boolean delete) {
            List<NodeModel> children = model.getChildren();
            for (NodeModel child : children) {
                this.removeLinksForDeletedSource(links, child, delete);
            }
            NodeLinks nodeLinks = NodeLinks.getLinkExtension(model);
            if (nodeLinks == null) {
                return;
            }
            for (final LinkModel link : nodeLinks.getLinks()) {
                if (!(link instanceof NodeLinkModel)) continue;
                IActor actor = new IActor(){

                    public void act() {
                        if (delete) {
                            this.delete();
                        } else {
                            this.insert();
                        }
                    }

                    public void undo() {
                        if (delete) {
                            this.insert();
                        } else {
                            this.delete();
                        }
                    }

                    private void delete() {
                        links.remove(link);
                    }

                    public String getDescription() {
                        return null;
                    }

                    private void insert() {
                        links.add(link);
                    }
                };
                MapModel map = model.getMap();
                Controller.getCurrentModeController().execute(actor, map);
            }
        }

        private void removeLinksForDeletedTarget(MapLinks links, NodeModel model) {
            List<NodeModel> children = model.getChildren();
            for (NodeModel child : children) {
                this.removeLinksForDeletedTarget(links, child);
            }
            String id = model.getID();
            if (id == null) {
                return;
            }
            final Set<LinkModel> linkModels = links.get(id);
            if (linkModels == null || linkModels.isEmpty()) {
                return;
            }
            IActor actor = new IActor(){

                public void act() {
                    this.refresh();
                }

                public void undo() {
                    this.refresh();
                }

                private void refresh() {
                    for (LinkModel link : linkModels) {
                        if (!(link instanceof HyperTextLinkModel)) continue;
                        NodeModel source = ((HyperTextLinkModel)link).getSource();
                        Controller.getCurrentModeController().getMapController().delayedNodeRefresh(source, "icon", null, null);
                    }
                }

                public String getDescription() {
                    return null;
                }
            };
            MapModel map = model.getMap();
            Controller.getCurrentModeController().execute(actor, map);
        }

        public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        }
    }

    private final class MiddleLabelSetter
    implements IActor {
        private final ConnectorModel model;
        private final String oldLabel;
        private final String label;

        private MiddleLabelSetter(ConnectorModel model, String oldLabel, String label) {
            this.model = model;
            this.oldLabel = oldLabel;
            this.label = label;
        }

        public void act() {
            this.model.setMiddleLabel(this.label);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.model.getSource());
        }

        public String getDescription() {
            return "setMiddleLabel";
        }

        public void undo() {
            this.model.setMiddleLabel(this.oldLabel);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.model.getSource());
        }
    }

    private final class SourceLabelSetter
    implements IActor {
        private final ConnectorModel model;
        private final String label;
        private final String oldLabel;

        private SourceLabelSetter(ConnectorModel model, String label, String oldLabel) {
            this.model = model;
            this.label = label;
            this.oldLabel = oldLabel;
        }

        public void act() {
            this.model.setSourceLabel(this.label);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.model.getSource());
        }

        public String getDescription() {
            return "setSourceLabel";
        }

        public void undo() {
            this.model.setSourceLabel(this.oldLabel);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.model.getSource());
        }
    }

    private final class TargetLabelSetter
    implements IActor {
        private final String oldLabel;
        private final String label;
        private final ConnectorModel model;

        private TargetLabelSetter(String oldLabel, String label, ConnectorModel model) {
            this.oldLabel = oldLabel;
            this.label = label;
            this.model = model;
        }

        public void act() {
            this.model.setTargetLabel(this.label);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.model.getSource());
        }

        public String getDescription() {
            return "setTargetLabel";
        }

        public void undo() {
            this.model.setTargetLabel(this.oldLabel);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.model.getSource());
        }
    }

    private final class CreateArrowLinkActor
    implements IActor {
        private final String targetID;
        private final NodeModel source;
        private ConnectorModel arrowLink;

        public ConnectorModel getArrowLink() {
            return this.arrowLink;
        }

        private CreateArrowLinkActor(String targetID, NodeModel source) {
            this.targetID = targetID;
            this.source = source;
        }

        public void act() {
            NodeLinks nodeLinks = this.source.getExtension(NodeLinks.class);
            if (nodeLinks == null) {
                nodeLinks = new NodeLinks();
                this.source.addExtension(nodeLinks);
            }
            this.arrowLink = new ConnectorModel(this.source, this.targetID, MLinkController.this.getStandardConnectorColor(), MLinkController.this.getStandardConnectorAlpha(), MLinkController.this.getStandardConnectorShape(), MLinkController.this.getStandardConnectorWidth(), MLinkController.this.getStandardLabelFontFamily(), MLinkController.this.getStandardLabelFontSize());
            nodeLinks.addArrowlink(this.arrowLink);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.source);
        }

        public String getDescription() {
            return "addLink";
        }

        public void undo() {
            NodeLinks nodeLinks = this.source.getExtension(NodeLinks.class);
            nodeLinks.removeArrowlink(this.arrowLink);
            Controller.getCurrentModeController().getMapController().nodeChanged(this.source);
        }
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private StyleCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            Boolean formatNodeAsHyperlink = NodeLinks.formatNodeAsHyperlink(from);
            if (formatNodeAsHyperlink != null) {
                NodeLinks.createLinkExtension(to).setFormatNodeAsHyperlink(formatNodeAsHyperlink);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NodeLinks model = NodeLinks.getModel(from);
            if (model != null) {
                model.setFormatNodeAsHyperlink(null);
            }
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (NodeLinks.formatNodeAsHyperlink(which) != null) {
                this.remove(key, from);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
        }
    }
}

