/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.Icon;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;

class ChangeConnectorDashAction
extends AFreeplaneAction {
    private static final int ICON_HEIGHT = 6;
    private static final int ICON_WIDTH = 60;
    private static final long serialVersionUID = 1L;
    private ConnectorModel arrowLink;
    private final int[] dash;

    public ChangeConnectorDashAction(MLinkController linkController, ConnectorModel arrowLink, int[] dash) {
        super("ChangeConnectorDashAction", "", ChangeConnectorDashAction.createIcon(dash));
        this.arrowLink = arrowLink;
        this.dash = dash;
        int[] dash2 = arrowLink.getDash();
        boolean selected = dash2 == dash || dash != null && Arrays.equals(dash, dash2);
        this.setSelected(selected);
    }

    public void actionPerformed(ActionEvent e) {
        MLinkController linkController = (MLinkController)LinkController.getController();
        linkController.setConnectorDash(this.arrowLink, this.dash);
    }

    private static Icon createIcon(int[] dash) {
        final BasicStroke stroke = UITools.createStroke(2, dash);
        return new Icon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.BLACK);
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(stroke);
                g2.drawLine(x, y + 3, x + 60, y + 3);
                g2.setStroke(oldStroke);
            }

            public int getIconWidth() {
                return 60;
            }

            public int getIconHeight() {
                return 6;
            }
        };
    }
}

