/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.icon.IIconInformation;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.ImageIconFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;

class IconAction
extends AMultipleNodeAction
implements IIconInformation {
    private static final long serialVersionUID = 1L;
    private final MindIcon icon;

    public IconAction(MindIcon _icon) {
        super("IconAction." + _icon.getName(), _icon.getDescription(), ImageIconFactory.getInstance().getImageIcon(_icon));
        this.icon = _icon;
        this.putValue("ShortDescription", this.getDescription());
    }

    public void actionPerformed(ActionEvent e, NodeModel node) {
        ((MIconController)IconController.getController()).addIcon(node, this.icon);
    }

    public String getDescription() {
        return this.icon.getDescription();
    }

    public Icon getIcon() {
        return ImageIconFactory.getInstance().getImageIcon(this.icon);
    }

    public KeyStroke getKeyStroke() {
        String keystrokeResourceName = this.icon.getShortcutKey();
        String keyStrokeDescription = ResourceController.getResourceController().getProperty(keystrokeResourceName);
        return UITools.getKeyStroke(keyStrokeDescription);
    }

    public MindIcon getMindIcon() {
        return this.icon;
    }

    public String getShortcutKey() {
        return this.icon.getShortcutKey();
    }
}

