/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;

public class ImportMindmanagerFiles
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportMindmanagerFiles() {
        super("ImportMindmanagerFiles");
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String type = "mmap";
        Container component = Controller.getCurrentController().getViewController().getContentPane();
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new ExampleFileFilter("mmap", null));
        File mmFile = Controller.getCurrentController().getMap().getFile();
        if (mmFile != null && mmFile.getParentFile() != null) {
            chooser.setSelectedFile(mmFile.getParentFile());
        }
        if ((returnVal = chooser.showOpenDialog(component)) != 0) {
            return;
        }
        File chosenFile = chooser.getSelectedFile();
        this.importMindmanagerFile(chosenFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importMindmanagerFile(File file) {
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            in = new ZipInputStream(new FileInputStream(file));
            while (in.available() != 0 && (entry = in.getNextEntry()) != null) {
                if (!entry.getName().equals("Document.xml")) continue;
                String xsltFileName = "/xslt/mindmanager2mm.xsl";
                URL xsltUrl = ResourceController.getResourceController().getResource("/xslt/mindmanager2mm.xsl");
                if (xsltUrl == null) {
                    LogUtils.severe("Can't find /xslt/mindmanager2mm.xsl as resource.");
                    throw new IllegalArgumentException("Can't find /xslt/mindmanager2mm.xsl as resource.");
                }
                InputStream xsltFile = xsltUrl.openStream();
                String xml = this.transForm(new StreamSource(in), xsltFile);
                xsltFile.close();
                if (xml == null) break;
                File tempFile = File.createTempFile(file.getName(), ".mm", file.getParentFile());
                FileWriter fw = new FileWriter(tempFile);
                fw.write(xml);
                fw.close();
                Controller.getCurrentModeController().getMapController().newMap(Compat.fileToUrl(tempFile));
                break;
            }
        }
        catch (Exception e) {
            try {
                LogUtils.severe(e);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in);
                throw throwable;
            }
            FileUtils.silentlyClose(in);
        }
        FileUtils.silentlyClose(in);
    }

    public String transForm(Source xmlSource, InputStream xsltStream) {
        StreamSource xsltSource = new StreamSource(xsltStream);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
        return writer.toString();
    }
}

