/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.export.mindmapmode.ImageCreator;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class ExportWithXSLT
implements IExportEngine {
    private static final Pattern propertyReferenceEpression = Pattern.compile("\\$\\{[^}]+\\}");
    private boolean mTransformResultWithoutError = false;
    private final Properties properties;
    private final String name;

    static void copyIconsToDirectory(MapModel map, String directoryName) {
        ListModel icons = map.getIconRegistry().getIconsAsListModel();
        for (int i = 0; i < icons.getSize(); ++i) {
            UIIcon icon = (UIIcon)icons.getElementAt(i);
            String iconName = icon.getName();
            StringBuilder sb = new StringBuilder(directoryName);
            int lastIndexOfSeparator = iconName.lastIndexOf(47);
            if (lastIndexOfSeparator != -1) {
                sb.append(File.separatorChar);
                sb.append(iconName.substring(0, lastIndexOfSeparator));
            }
            File destinationDirectory = new File(sb.toString());
            destinationDirectory.mkdirs();
            FileUtils.copyFromURL(icon.getUrl(), destinationDirectory);
        }
    }

    public ExportWithXSLT(String name, Properties properties) {
        this.name = name;
        this.properties = properties;
    }

    private void copyFilesFromResourcesToDirectory(String targetDirectoryName, String sourceDirectoryPath, String files) {
        StringTokenizer tokenizer = new StringTokenizer(files, ",");
        File destinationDirectory = new File(targetDirectoryName);
        while (tokenizer.hasMoreTokens()) {
            String sourceFile = tokenizer.nextToken();
            int nameStartPosition = sourceFile.lastIndexOf(47) + 1;
            String sourceFileDirectory = nameStartPosition > 0 ? sourceFile.substring(0, nameStartPosition) : "";
            String sourceFileName = nameStartPosition > 0 ? sourceFile.substring(nameStartPosition) : sourceFile;
            FileUtils.copyFromResource(sourceDirectoryPath + sourceFileDirectory, sourceFileName, destinationDirectory);
        }
    }

    private boolean copyIcons(MapModel map, String directoryName) {
        String iconDirectoryName = directoryName + File.separatorChar + "icons";
        boolean success = FileUtils.createDirectory(iconDirectoryName);
        if (success) {
            ExportWithXSLT.copyIconsToDirectory(map, iconDirectoryName);
        }
        return success;
    }

    private boolean copyMap(MapModel map, String pDirectoryName) {
        boolean success = true;
        try {
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(pDirectoryName + File.separator + "map" + ".mm")));
            MapWriter.Mode mode = MapWriter.Mode.valueOf(this.getProperty("copymode", MapWriter.Mode.EXPORT.name()));
            Controller.getCurrentModeController().getMapController().getFilteredXml(map, fileout, mode, MapWriter.Mode.EXPORT.equals((Object)mode));
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    private int getImageResolutionDPI() {
        return ResourceController.getResourceController().getIntProperty("exported_image_resolution_dpi", 300);
    }

    private boolean createImageFromMap(MapModel map, String directoryName) {
        if (Controller.getCurrentController().getMapViewManager().getMapViewComponent() == null) {
            return false;
        }
        RenderedImage image = new ImageCreator(this.getImageResolutionDPI()).createBufferedImage(map);
        if (image == null) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(directoryName + File.separator + "image.png");
            ImageIO.write(image, "png", out);
            out.close();
            return true;
        }
        catch (IOException e1) {
            LogUtils.severe(e1);
            return false;
        }
    }

    private String getAreaCode(boolean create_image) {
        String areaCode = "";
        if (create_image) {
            areaCode = Controller.getCurrentController().getMapViewManager().createHtmlMap();
        }
        return areaCode;
    }

    private String getMapXml(MapWriter.Mode mode) throws IOException {
        StringWriter writer = new StringWriter();
        ModeController modeController = Controller.getCurrentModeController();
        Controller controller = modeController.getController();
        MapModel map = controller.getMap();
        modeController.getMapController().getFilteredXml(map, writer, mode, MapWriter.Mode.EXPORT.equals((Object)mode));
        return writer.getBuffer().toString();
    }

    String getProperty(String key) {
        String property = this.getProperty(key, null);
        if (property == null) {
            return property;
        }
        Matcher r = propertyReferenceEpression.matcher(property);
        r.reset();
        boolean result = r.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String propertyReference = r.group();
                String propertyName = propertyReference.substring(2, propertyReference.length() - 1);
                r.appendReplacement(sb, System.getProperty(propertyName, propertyReference));
            } while (result = r.find());
            r.appendTail(sb);
            return sb.toString();
        }
        return property;
    }

    String getProperty(String key, String value) {
        return this.properties.getProperty(key, value);
    }

    public boolean isTransformResultWithoutError() {
        return this.mTransformResultWithoutError;
    }

    public void export(MapModel map, File saveFile) {
        try {
            this.mTransformResultWithoutError = true;
            boolean create_image = StringUtils.equals((String)this.getProperty("create_html_linked_image"), (String)"true");
            String areaCode = this.getAreaCode(create_image);
            String xsltFileName = this.getProperty("xslt_file");
            MapWriter.Mode mode = MapWriter.Mode.valueOf(this.getProperty("mode", MapWriter.Mode.EXPORT.name()));
            String[] parameters = this.getProperty("set_properties", "").split(",\\s*");
            boolean success = this.transformMapWithXslt(xsltFileName, saveFile, areaCode, mode, parameters);
            if (!success) {
                JOptionPane.showMessageDialog(UITools.getFrame(), this.getProperty("error_applying_template"), "Freeplane", 0);
                return;
            }
            if (success && StringUtils.equals((String)this.getProperty("create_dir"), (String)"true")) {
                String directoryName = saveFile.getAbsolutePath() + "_files";
                success = FileUtils.createDirectory(directoryName);
                if (success) {
                    String files = this.getProperty("files_to_copy");
                    String filePrefix = this.getProperty("file_prefix");
                    this.copyFilesFromResourcesToDirectory(directoryName, filePrefix, files);
                }
                if (success && StringUtils.equals((String)this.getProperty("copy_icons"), (String)"true")) {
                    success = this.copyIcons(map, directoryName);
                }
                if (success && StringUtils.equals((String)this.getProperty("copy_map"), (String)"true")) {
                    String copy\u041cap\u0425sltFile = this.getProperty("copy_map_xslt_file");
                    success = copy\u041cap\u0425sltFile != null ? this.transformMapWithXslt(copy\u041cap\u0425sltFile, new File(directoryName, "map.mm"), "", MapWriter.Mode.EXPORT, new String[0]) : this.copyMap(map, directoryName);
                }
                if (success && create_image) {
                    success = this.createImageFromMap(map, directoryName);
                }
            }
            if (!success) {
                JOptionPane.showMessageDialog(UITools.getFrame(), this.getProperty("error_creating_directory"), "Freeplane", 0);
                return;
            }
            if (StringUtils.equals((String)this.getProperty("load_file"), (String)"true")) {
                Controller.getCurrentController().getViewController().openDocument(Compat.fileToUrl(saveFile));
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
            this.mTransformResultWithoutError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transformMapWithXslt(String xsltFileName, File saveFile, String areaCode, MapWriter.Mode mode, String[] parameters) throws IOException, TransformerFactoryConfigurationError {
        String map = this.getMapXml(mode);
        StringReader reader = new StringReader(map);
        ResourceController resourceController = ResourceController.getResourceController();
        URL xsltUrl = resourceController.getResource(xsltFileName);
        if (xsltUrl == null) {
            LogUtils.severe("Can't find " + xsltFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        BufferedInputStream xsltFile = new BufferedInputStream(xsltUrl.openStream());
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult result = new StreamResult(saveFile);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("destination_dir", saveFile.getName() + "_files/");
            trans.setParameter("area_code", areaCode);
            trans.setParameter("folding_type", resourceController.getProperty("html_export_folding"));
            StringBuilder sb = new StringBuilder();
            for (String p : parameters) {
                String value = resourceController.getProperty(p, null);
                if (value == null || value.equals(resourceController.getDefaultProperty(p))) continue;
                sb.append(p);
                sb.append('=');
                sb.append(value);
                sb.append("$$$");
            }
            trans.setParameter("propertyList", sb.toString());
            trans.transform(new StreamSource(reader), result);
        }
        catch (Exception e) {
            boolean bl;
            try {
                LogUtils.warn(e);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(xsltFile);
                throw throwable;
            }
            FileUtils.silentlyClose(xsltFile);
            return bl;
        }
        FileUtils.silentlyClose(xsltFile);
        return true;
    }

    public FileFilter getFileFilter() {
        return new ExampleFileFilter(this.getProperty("file_type"), TextUtils.getText(this.name + ".text"));
    }
}

