/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class ExportToOoWriter
implements IExportEngine {
    public FileFilter getFileFilter() {
        return new ExampleFileFilter("odt", TextUtils.getText("ExportToOoWriter.text"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(MapModel map, File chosenFile) {
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            this.exportToOoWriter(map, chosenFile);
        }
        catch (Exception ex) {
            LogUtils.warn(ex);
            UITools.errorMessage(TextUtils.getText("export_failed"));
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyXsltFile(String xsltFileName, StringWriter writer, Result result) throws IOException {
        URL xsltUrl = ResourceController.getResourceController().getResource(xsltFileName);
        if (xsltUrl == null) {
            LogUtils.severe("Can't find " + xsltFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        BufferedInputStream xsltStream = new BufferedInputStream(xsltUrl.openStream());
        StreamSource xsltSource = new StreamSource(xsltStream);
        try {
            StringReader reader = new StringReader(writer.getBuffer().toString());
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(new StreamSource(reader), result);
        }
        catch (Exception e) {
            try {
                UITools.errorMessage(e.getMessage());
                LogUtils.warn(e);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(xsltStream);
                throw throwable;
            }
            FileUtils.silentlyClose(xsltStream);
            return;
        }
        FileUtils.silentlyClose(xsltStream);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToOoWriter(MapModel map, File file) throws IOException {
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(file));
        try {
            StringWriter writer = new StringWriter();
            ModeController controller = Controller.getCurrentModeController();
            controller.getMapController().getFilteredXml(map, writer, MapWriter.Mode.EXPORT, true);
            StreamResult result = new StreamResult(zipout);
            ZipEntry entry = new ZipEntry("content.xml");
            zipout.putNextEntry(entry);
            this.applyXsltFile("/xslt/export2oowriter.xsl", writer, result);
            zipout.closeEntry();
            entry = new ZipEntry("META-INF/manifest.xml");
            zipout.putNextEntry(entry);
            this.applyXsltFile("/xslt/export2oowriter.manifest.xsl", writer, result);
            zipout.closeEntry();
            entry = new ZipEntry("styles.xml");
            zipout.putNextEntry(entry);
            this.applyXsltFile("/xslt/export2oowriter.styles.xsl", writer, result);
            zipout.closeEntry();
        }
        finally {
            zipout.close();
        }
    }
}

