/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.export.mindmapmode.ExportWithXSLT;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;

class ExportToHTMLAction
implements IExportEngine {
    public FileFilter getFileFilter() {
        return new ExampleFileFilter("html", TextUtils.getText("ExportToHTMLAction.text"));
    }

    public void export(MapModel map, File file) {
        try {
            ClipboardController.getController().saveHTML(map.getRootNode(), file);
            if (ResourceController.getResourceController().getBooleanProperty("export_icons_in_html")) {
                ExportWithXSLT.copyIconsToDirectory(map, new File(file.getAbsoluteFile().getParentFile(), "icons").getAbsolutePath());
            }
            Controller.getCurrentModeController().getExtension(UrlManager.class).loadURL(file.toURI());
        }
        catch (IOException ex) {
            LogUtils.warn(ex);
            UITools.errorMessage(TextUtils.getText("export_failed"));
        }
    }
}

