/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.MapModel;

public class ExportDialog {
    private final JFileChooser fileChooser = new JFileChooser();

    public ExportDialog() {
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setDialogTitle(TextUtils.getText("export_using_xslt"));
        this.fileChooser.setToolTipText(TextUtils.getText("select_file_export_to"));
        ExportController exportEngineRegistry = ExportController.getContoller();
        for (FileFilter filter : exportEngineRegistry.getFileFilters()) {
            this.fileChooser.addChoosableFileFilter(filter);
        }
        FileFilter fileFilter = this.fileChooser.getChoosableFileFilters()[0];
        this.fileChooser.setFileFilter(fileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(Component parentframe, MapModel map) {
        ExportController exportEngineRegistry = ExportController.getContoller();
        if (exportEngineRegistry.getFilterMap().isEmpty()) {
            JOptionPane.showMessageDialog(parentframe, TextUtils.getText("xslt_export_not_possible"));
            return;
        }
        File xmlSourceFile = map.getFile();
        final String absolutePathWithoutExtension = xmlSourceFile != null ? FileUtils.removeExtension(xmlSourceFile.getAbsolutePath()) : null;
        PropertyChangeListener filterChangeListener = new PropertyChangeListener(){
            private final File selectedFile;
            {
                this.selectedFile = absolutePathWithoutExtension == null ? null : new File(absolutePathWithoutExtension);
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    FileFilter filter = ExportDialog.this.fileChooser.getFileFilter();
                    if (!(filter instanceof ExampleFileFilter)) {
                        return;
                    }
                    final File acceptableFile = ExportDialog.this.getAcceptableFile(this.selectedFile, (ExampleFileFilter)filter);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ExportDialog.this.fileChooser.setSelectedFile(acceptableFile);
                        }
                    });
                    return;
                }
                if (this.selectedFile != null && evt.getPropertyName().equals("directoryChanged")) {
                    FileFilter filter = ExportDialog.this.fileChooser.getFileFilter();
                    if (!(filter instanceof ExampleFileFilter)) {
                        return;
                    }
                    File acceptableFile = ExportDialog.this.getAcceptableFile(this.selectedFile, (ExampleFileFilter)filter);
                    File currentDirectory = ExportDialog.this.fileChooser.getCurrentDirectory();
                    if (currentDirectory != null) {
                        File file = new File(currentDirectory, acceptableFile.getName());
                        ExportDialog.this.fileChooser.setSelectedFile(file);
                    } else {
                        ExportDialog.this.fileChooser.setSelectedFile(acceptableFile);
                    }
                    return;
                }
            }
        };
        filterChangeListener.propertyChange(new PropertyChangeEvent(this.fileChooser, "fileFilterChanged", null, this.fileChooser.getFileFilter()));
        try {
            this.fileChooser.addPropertyChangeListener(filterChangeListener);
            int returnVal = this.fileChooser.showSaveDialog(parentframe);
            if (returnVal == 0) {
                if (!(this.fileChooser.getFileFilter() instanceof ExampleFileFilter)) {
                    UITools.errorMessage(TextUtils.getText("invalid_export_file"));
                    return;
                }
                ExampleFileFilter fileFilter = (ExampleFileFilter)this.fileChooser.getFileFilter();
                File selectedFile = this.getAcceptableFile(this.fileChooser.getSelectedFile(), fileFilter);
                if (selectedFile == null) {
                    return;
                }
                if (selectedFile.isDirectory()) {
                    return;
                }
                if (selectedFile.exists()) {
                    String overwriteText = MessageFormat.format(TextUtils.getText("file_already_exists"), selectedFile.toString());
                    int overwriteMap = JOptionPane.showConfirmDialog(UITools.getFrame(), overwriteText, overwriteText, 0);
                    if (overwriteMap != 0) {
                        return;
                    }
                }
                IExportEngine exportEngine = exportEngineRegistry.getFilterMap().get(fileFilter);
                exportEngine.export(map, selectedFile);
            }
        }
        finally {
            this.fileChooser.removePropertyChangeListener(filterChangeListener);
        }
    }

    private File getAcceptableFile(File selectedFile, ExampleFileFilter fileFilter) {
        if (selectedFile == null) {
            return null;
        }
        if (!fileFilter.accept(selectedFile)) {
            selectedFile = new File(selectedFile.getAbsolutePath() + '.' + fileFilter.getExtensionProposal());
        }
        return selectedFile;
    }
}

