/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.ExportAction;
import org.freeplane.features.export.mindmapmode.ExportBranchToHTMLAction;
import org.freeplane.features.export.mindmapmode.ExportToHTMLAction;
import org.freeplane.features.export.mindmapmode.ExportToImage;
import org.freeplane.features.export.mindmapmode.ExportToOoWriter;
import org.freeplane.features.export.mindmapmode.ExportWithXSLT;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.export.mindmapmode.XsltExportEngineFactory;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportController
implements IExtension {
    private final HashMap<FileFilter, IExportEngine> filterMap = new HashMap();
    private final ArrayList<FileFilter> fileFilters = new ArrayList();

    public static void install(ExportController exportController) {
        Controller.getCurrentModeController().addExtension(ExportController.class, exportController);
    }

    public ExportController(String xmlDescriptorFile) {
        ModeController modeController = Controller.getCurrentModeController();
        ExportAction action = new ExportAction();
        modeController.addAction(action);
        ExportToHTMLAction exportToHTMLAction = new ExportToHTMLAction();
        this.addExportEngine(exportToHTMLAction.getFileFilter(), exportToHTMLAction);
        ExportBranchToHTMLAction exportBranchToHTMLAction = new ExportBranchToHTMLAction();
        this.addExportEngine(exportBranchToHTMLAction.getFileFilter(), exportBranchToHTMLAction);
        ExportToOoWriter exportToOoWriter = new ExportToOoWriter();
        this.addExportEngine(exportToOoWriter.getFileFilter(), exportToOoWriter);
        this.createImageExporters();
        this.createXSLTExportActions(xmlDescriptorFile);
        new XsltExportEngineFactory().gatherXsltScripts(this);
        Collections.sort(this.fileFilters, new Comparator<FileFilter>(){

            @Override
            public int compare(FileFilter f1, FileFilter f2) {
                return f1.getDescription().compareToIgnoreCase(f2.getDescription());
            }
        });
    }

    public void createImageExporters() {
        ExportToImage pngExport = new ExportToImage("png", "Portable Network Graphic (PNG)");
        this.addExportEngine(pngExport.getFileFilter(), pngExport);
        ExportToImage jpgExport = new ExportToImage("jpg", "Compressed image (JPEG)");
        this.addExportEngine(jpgExport.getFileFilter(), jpgExport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXSLTExportActions(String xmlDescriptorFile) {
        InputStream xmlDescriptorStream = null;
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            URL resource = ResourceController.getResourceController().getResource(xmlDescriptorFile);
            xmlDescriptorStream = resource.openStream();
            StdXMLReader reader = new StdXMLReader(xmlDescriptorStream);
            parser.setReader(reader);
            XMLElement xml = (XMLElement)parser.parse();
            Enumeration<XMLElement> actionDescriptors = xml.enumerateChildren();
            while (actionDescriptors.hasMoreElements()) {
                XMLElement descriptor = actionDescriptors.nextElement();
                String name = descriptor.getAttribute("name", null);
                XMLElement xmlProperties = descriptor.getFirstChildNamed("properties");
                Properties properties = xmlProperties.getAttributes();
                ExportWithXSLT action = new ExportWithXSLT(name, properties);
                this.addExportEngine(action.getFileFilter(), action);
            }
        }
        catch (Exception e) {
            try {
                LogUtils.severe(e);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(xmlDescriptorStream);
                throw throwable;
            }
            FileUtils.silentlyClose(xmlDescriptorStream);
        }
        FileUtils.silentlyClose(xmlDescriptorStream);
    }

    public void addExportEngine(FileFilter filter, IExportEngine exporter) {
        for (IExportEngine existingExporter : this.filterMap.values()) {
            if (!existingExporter.equals(exporter)) continue;
            return;
        }
        this.fileFilters.add(filter);
        this.filterMap.put(filter, exporter);
    }

    public HashMap<FileFilter, IExportEngine> getFilterMap() {
        return this.filterMap;
    }

    public List<FileFilter> getFileFilters() {
        return this.fileFilters;
    }

    public static ExportController getContoller() {
        return ExportController.getController(Controller.getCurrentModeController());
    }

    public static ExportController getController(ModeController modeController) {
        return modeController.getExtension(ExportController.class);
    }

    public boolean checkCurrentMap(MapModel map) {
        if (map.equals(Controller.getCurrentController().getMap())) {
            return true;
        }
        UITools.errorMessage(TextUtils.getText("export_works_for_current_map_only"));
        return false;
    }
}

