/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.features.encrypt.SwingPasswordStrategy;
import org.freeplane.features.encrypt.mindmapmode.MEncryptionController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

@EnabledAction(checkOnNodeChange=true)
public class RemoveEncryption
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final MEncryptionController encryptionController;

    public RemoveEncryption(MEncryptionController encryptionController) {
        super("RemoveEncryption");
        this.encryptionController = encryptionController;
    }

    public void actionPerformed(ActionEvent e) {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        this.encryptionController.removeEncryption(node, new SwingPasswordStrategy());
    }

    private boolean canBeEnabled() {
        EncryptionModel enode;
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController == null) {
            return false;
        }
        boolean isEncryptedNode = false;
        MapController mapController = modeController.getMapController();
        NodeModel selectedNode = mapController.getSelectedNode();
        if (selectedNode != null && (enode = EncryptionModel.getModel(selectedNode)) != null) {
            isEncryptedNode = true;
        }
        return isEncryptedNode;
    }

    public void setEnabled() {
        super.setEnabled(this.canBeEnabled());
    }
}

