/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.EnterPasswordDialog;
import org.freeplane.features.encrypt.SingleDesEncrypter;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.mindmapmode.MFileManager;

class EncryptedMap
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    EncryptedMap() {
        super("EncryptedMap");
    }

    public void actionPerformed(ActionEvent e) {
        this.newEncryptedMap();
    }

    private StringBuilder getUsersPassword() {
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(Controller.getCurrentController().getViewController().getFrame(), true);
        pwdDialog.setModal(true);
        pwdDialog.show();
        if (pwdDialog.getResult() == -1) {
            return null;
        }
        StringBuilder password = pwdDialog.getPassword();
        return password;
    }

    private void newEncryptedMap() {
        StringBuilder password = this.getUsersPassword();
        if (password == null) {
            return;
        }
        ModeController modeController = Controller.getCurrentModeController();
        MFileManager.getController(modeController).newMapFromDefaultTemplate();
        NodeModel node = Controller.getCurrentController().getMap().getRootNode();
        EncryptionModel encryptedMindMapNode = new EncryptionModel(node);
        encryptedMindMapNode.setEncrypter(new SingleDesEncrypter(password));
        node.addExtension(encryptedMindMapNode);
        Controller.getCurrentModeController().getMapController().nodeChanged(node);
    }

    public void afterMapChange(Object newMap) {
    }
}

