/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge.mindmapmode;

import java.awt.Color;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.edge.mindmapmode.EdgeColorAction;
import org.freeplane.features.edge.mindmapmode.EdgeStyleAction;
import org.freeplane.features.edge.mindmapmode.EdgeStyleAsParentAction;
import org.freeplane.features.edge.mindmapmode.EdgeWidthAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MEdgeController
extends EdgeController {
    public MEdgeController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier(new ExtensionCopier(modeController));
        modeController.addAction(new EdgeColorAction());
        modeController.addAction(new EdgeWidthAction(-1));
        modeController.addAction(new EdgeWidthAction(0));
        modeController.addAction(new EdgeWidthAction(1));
        modeController.addAction(new EdgeWidthAction(2));
        modeController.addAction(new EdgeWidthAction(4));
        modeController.addAction(new EdgeWidthAction(8));
        modeController.addAction(new EdgeStyleAction(EdgeStyle.EDGESTYLE_LINEAR));
        modeController.addAction(new EdgeStyleAction(EdgeStyle.EDGESTYLE_BEZIER));
        modeController.addAction(new EdgeStyleAction(EdgeStyle.EDGESTYLE_SHARP_LINEAR));
        modeController.addAction(new EdgeStyleAction(EdgeStyle.EDGESTYLE_SHARP_BEZIER));
        modeController.addAction(new EdgeStyleAction(EdgeStyle.EDGESTYLE_HORIZONTAL));
        modeController.addAction(new EdgeStyleAction(EdgeStyle.EDGESTYLE_HIDDEN));
        modeController.addAction(new EdgeStyleAsParentAction());
    }

    public void setColor(final NodeModel node, final Color color) {
        final ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = EdgeModel.createEdgeModel(node).getColor();
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel(node).setColor(color);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                EdgeModel.createEdgeModel(node).setColor(oldColor);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setStyle(final NodeModel node, final EdgeStyle style) {
        EdgeStyle oldStyle;
        final ModeController modeController = Controller.getCurrentModeController();
        if (style != null ? style.equals((Object)(oldStyle = EdgeModel.createEdgeModel(node).getStyle())) : (oldStyle = EdgeModel.createEdgeModel(node).getStyle()) == null) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel(node).setStyle(style);
                modeController.getMapController().nodeChanged(node);
                this.edgeStyleRefresh(node);
            }

            private void edgeStyleRefresh(NodeModel node2) {
                for (NodeModel child : modeController.getMapController().childrenFolded(node2)) {
                    EdgeModel edge = EdgeModel.getModel(child);
                    if (edge != null && edge.getStyle() != null) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.edgeStyleRefresh(child);
                }
            }

            public String getDescription() {
                return "setStyle";
            }

            public void undo() {
                EdgeModel.createEdgeModel(node).setStyle(oldStyle);
                modeController.getMapController().nodeChanged(node);
                this.edgeStyleRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setWidth(final NodeModel node, final int width) {
        final ModeController modeController = Controller.getCurrentModeController();
        final int oldWidth = EdgeModel.createEdgeModel(node).getWidth();
        if (width == oldWidth) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel(node).setWidth(width);
                modeController.getMapController().nodeChanged(node);
                this.edgeWidthRefresh(node);
            }

            private void edgeWidthRefresh(NodeModel node2) {
                for (NodeModel child : modeController.getMapController().childrenFolded(node2)) {
                    EdgeModel edge = EdgeModel.getModel(child);
                    if (edge != null && edge.getWidth() != -1) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.edgeWidthRefresh(child);
                }
            }

            public String getDescription() {
                return "setWidth";
            }

            public void undo() {
                EdgeModel.createEdgeModel(node).setWidth(oldWidth);
                modeController.getMapController().nodeChanged(node);
                this.edgeWidthRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private final ModeController modeController;

        public ExtensionCopier(ModeController modeController) {
            this.modeController = modeController;
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            int width;
            EdgeStyle style;
            EdgeModel fromStyle = from.getExtension(EdgeModel.class);
            if (fromStyle == null) {
                return;
            }
            EdgeModel toStyle = EdgeModel.createEdgeModel(to);
            Color color = fromStyle.getColor();
            if (color != null) {
                toStyle.setColor(color);
            }
            if ((style = fromStyle.getStyle()) != null) {
                toStyle.setStyle(style);
            }
            if ((width = fromStyle.getWidth()) != -1) {
                toStyle.setWidth(width);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(EdgeModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            int width;
            EdgeStyle style;
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            EdgeModel whichStyle = which.getExtension(EdgeModel.class);
            if (whichStyle == null) {
                return;
            }
            EdgeModel fromStyle = from.getExtension(EdgeModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension(fromStyle);
            EdgeModel delta = new EdgeModel();
            Color color = fromStyle.getColor();
            boolean deltaFound = false;
            if (color != null && whichStyle.getColor() == null) {
                delta.setColor(color);
                deltaFound = true;
            }
            if ((style = fromStyle.getStyle()) != null && whichStyle.getStyle() == null) {
                delta.setStyle(style);
                deltaFound = true;
            }
            if ((width = fromStyle.getWidth()) != -1 && whichStyle.getWidth() == -1) {
                delta.setWidth(width);
                deltaFound = true;
            }
            if (deltaFound) {
                from.addExtension(delta);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.resolveColor(to);
            this.resolveWidth(to);
            this.resolveStyle(to);
        }

        private void resolveColor(NodeModel to) {
            if (null != this.getColor(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                Color color = this.getColor(source);
                if (color == null) continue;
                EdgeModel.createEdgeModel(to).setColor(color);
                return;
            }
        }

        private Color getColor(NodeModel node) {
            return this.modeController.getExtension(EdgeController.class).getColor(node, false);
        }

        private void resolveWidth(NodeModel to) {
            if (null != this.getWidth(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                Integer width = this.getWidth(source);
                if (width == null) continue;
                EdgeModel.createEdgeModel(to).setWidth(width);
                return;
            }
        }

        private Integer getWidth(NodeModel node) {
            return this.modeController.getExtension(EdgeController.class).getWidth(node, false);
        }

        private void resolveStyle(NodeModel to) {
            if (null != this.getStyle(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                EdgeStyle style = this.getStyle(source);
                if (style == null) continue;
                EdgeModel.createEdgeModel(to).setStyle(style);
                return;
            }
        }

        private EdgeStyle getStyle(NodeModel node) {
            return this.modeController.getExtension(EdgeController.class).getStyle(node, false);
        }
    }
}

