/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

@SelectableAction(checkOnNodeChange=true)
class EdgeWidthAction
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;
    private final int mWidth;

    private static String getWidthTitle(int width) {
        String returnValue = width <= 0 ? TextUtils.getRawText(EdgeWidthAction.width2String(width) + ".text") : Integer.toString(width);
        return returnValue;
    }

    private static String width2String(int width) {
        if (width == -1) {
            return "EdgeWidthAction_width_parent";
        }
        if (width == 0) {
            return "EdgeWidthAction_width_thin";
        }
        return "EdgeWidthAction_" + width;
    }

    public EdgeWidthAction(int width) {
        super(EdgeWidthAction.width2String(width), EdgeWidthAction.getWidthTitle(width), null);
        this.mWidth = width;
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        ((MEdgeController)EdgeController.getController()).setWidth(node, this.mWidth);
    }

    public void setSelected() {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        EdgeModel model = EdgeModel.getModel(node);
        if (model == null) {
            if (this.mWidth == -1) {
                this.setSelected(true);
                return;
            }
        } else if (model.getWidth() == this.mWidth) {
            this.setSelected(true);
            return;
        }
        this.setSelected(false);
    }
}

