/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge.mindmapmode;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.mindmapmode.AutomaticEdgeColor;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.AMapChangeListenerAdapter;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NodeHookDescriptor(hookName="AutomaticEdgeColor")
public class AutomaticEdgeColorHook
extends PersistentNodeHook
implements IExtension {
    private ModeController modeController;

    public AutomaticEdgeColorHook() {
        Listener listener = new Listener();
        this.modeController = Controller.getCurrentModeController();
        this.modeController.addExtension(AutomaticEdgeColorHook.class, this);
        MapController mapController = this.modeController.getMapController();
        mapController.addMapChangeListener(listener);
    }

    @Override
    protected Class<? extends IExtension> getExtensionClass() {
        return AutomaticEdgeColor.class;
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        int colorCount = element == null ? 0 : element.getAttribute("COUNTER", 0);
        return new AutomaticEdgeColor(colorCount);
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        super.saveExtension(extension, element);
        int colorCount = ((AutomaticEdgeColor)extension).getColorCount();
        element.setAttribute("COUNTER", Integer.toString(colorCount));
    }

    private class Listener
    extends AMapChangeListenerAdapter {
        private Listener() {
        }

        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            if (!AutomaticEdgeColorHook.this.isActive(child) || AutomaticEdgeColorHook.this.modeController.isUndoAction()) {
                return;
            }
            if (MapStyleModel.FLOATING_STYLE.equals(LogicalStyleModel.getStyle(child))) {
                return;
            }
            if (parent.isRoot()) {
                EdgeModel edgeModel = EdgeModel.createEdgeModel(child);
                if (null == edgeModel.getColor()) {
                    MEdgeController controller = (MEdgeController)EdgeController.getController();
                    AutomaticEdgeColor model = (AutomaticEdgeColor)AutomaticEdgeColorHook.this.getMapHook();
                    controller.setColor(child, model.nextColor());
                }
            } else {
                MEdgeController controller = (MEdgeController)EdgeController.getController();
                controller.setColor(child, null);
                boolean edgeStylesEquals = controller.getColor(child).equals(controller.getColor(parent));
                if (!edgeStylesEquals) {
                    OptionalDontShowMeAgainDialog.show("edge_is_formatted_by_style", "confirmation", "ignore_edge_format_by_style", 2);
                }
            }
        }

        public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
            this.onNodeInserted(newParent, child, newIndex);
        }
    }
}

