/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud.mindmapmode;

import java.awt.Color;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.mindmapmode.CloudAction;
import org.freeplane.features.cloud.mindmapmode.CloudColorAction;
import org.freeplane.features.cloud.mindmapmode.CloudShapeAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MCloudController
extends CloudController {
    public MCloudController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier(new ExtensionCopier());
        modeController.addAction(new CloudAction());
        modeController.addAction(new CloudColorAction());
        for (CloudModel.Shape shape : CloudModel.Shape.values()) {
            modeController.addAction(new CloudShapeAction(shape));
        }
    }

    public void setCloud(final NodeModel node, final boolean enable) {
        CloudModel cloud = CloudModel.getModel(node);
        if (cloud != null == enable) {
            return;
        }
        final Color color = cloud != null ? cloud.getColor() : CloudController.getStandardColor();
        final ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                if (enable) {
                    this.enable();
                } else {
                    this.disable();
                }
            }

            private void disable() {
                MapController mapController = modeController.getMapController();
                CloudModel.setModel(node, null);
                mapController.nodeChanged(node);
            }

            private void enable() {
                CloudModel cloud = new CloudModel();
                cloud.setColor(color);
                MapController mapController = modeController.getMapController();
                CloudModel.setModel(node, cloud);
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setCloud";
            }

            public void undo() {
                if (enable) {
                    this.disable();
                } else {
                    this.enable();
                }
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setColor(final NodeModel node, final Color color) {
        this.setCloud(node, true);
        final ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = CloudModel.getModel(node).getColor();
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                CloudModel.getModel(node).setColor(color);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                CloudModel.getModel(node).setColor(oldColor);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setShape(final NodeModel node, final CloudModel.Shape shape) {
        this.setCloud(node, true);
        final ModeController modeController = Controller.getCurrentModeController();
        final CloudModel.Shape oldShape = CloudModel.getModel(node).getShape();
        if (shape == oldShape || shape != null && shape.equals((Object)oldShape)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                CloudModel.getModel(node).setShape(shape);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setShape";
            }

            public void undo() {
                CloudModel.getModel(node).setShape(oldShape);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            CloudModel.Shape shape;
            CloudModel fromStyle = from.getExtension(CloudModel.class);
            if (fromStyle == null) {
                return;
            }
            CloudModel toStyle = CloudModel.createModel(to);
            Color color = fromStyle.getColor();
            if (color != null) {
                toStyle.setColor(color);
            }
            if ((shape = fromStyle.getShape()) != null) {
                toStyle.setShape(shape);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(CloudModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals((Object)LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            CloudModel whichStyle = which.getExtension(CloudModel.class);
            if (whichStyle == null) {
                return;
            }
            CloudModel fromStyle = from.getExtension(CloudModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension(fromStyle);
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
        }
    }
}

