/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

@SelectableAction(checkOnNodeChange=true)
class CloudShapeAction
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;
    private final CloudModel.Shape actionShape;

    public CloudShapeAction(CloudModel.Shape actionShape) {
        super("CloudShapeAction." + actionShape.toString());
        this.actionShape = actionShape;
    }

    public void actionPerformed(ActionEvent e) {
        ModeController controller = Controller.getCurrentModeController();
        NodeModel selected = controller.getMapController().getSelectedNode();
        MCloudController cloudController = (MCloudController)CloudController.getController();
        cloudController.setCloud(selected, true);
        super.actionPerformed(e);
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        MCloudController cloudController = (MCloudController)CloudController.getController();
        cloudController.setShape(node, this.actionShape);
    }

    public void setSelected() {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        CloudModel model = CloudModel.getModel(node);
        if (model != null && this.actionShape.equals((Object)model.getShape())) {
            this.setSelected(true);
            return;
        }
        this.setSelected(false);
    }
}

