/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard.mindmapmode;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedPasteAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private MClipboardController.IDataFlavorHandler selectedHandler;

    public SelectedPasteAction() {
        super("SelectedPasteAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MClipboardController clipboardController = (MClipboardController)ClipboardController.getController();
        Collection<MClipboardController.IDataFlavorHandler> flavorHandlers = clipboardController.getFlavorHandlers();
        if (flavorHandlers.isEmpty()) {
            return;
        }
        JPanel options = this.createPane(flavorHandlers);
        if (2 == JOptionPane.showConfirmDialog((Component)e.getSource(), options, e.getActionCommand(), 2)) {
            return;
        }
        NodeModel parent = Controller.getCurrentController().getSelection().getSelected();
        Transferable clipboardContents = clipboardController.getClipboardContents();
        clipboardController.paste(clipboardContents, this.selectedHandler, parent, false, parent.isNewChildLeft());
        this.selectedHandler = null;
    }

    private JPanel createPane(Collection<MClipboardController.IDataFlavorHandler> flavorHandlers) {
        ButtonGroup group = new ButtonGroup();
        JRadioButton[] buttons = new JRadioButton[flavorHandlers.size()];
        int i = 0;
        this.selectedHandler = null;
        for (final MClipboardController.IDataFlavorHandler handler : flavorHandlers) {
            JRadioButton radioButton = new JRadioButton(TextUtils.getText(handler.getClass().getSimpleName()));
            group.add(radioButton);
            if (this.selectedHandler == null) {
                this.selectedHandler = handler;
                radioButton.setSelected(true);
            }
            radioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectedPasteAction.this.selectedHandler = handler;
                }
            });
            buttons[i++] = radioButton;
        }
        return this.createPane(buttons);
    }

    private JPanel createPane(JRadioButton[] radioButtons) {
        int numChoices = radioButtons.length;
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 3));
        for (int i = 0; i < numChoices; ++i) {
            box.add(radioButtons[i]);
        }
        return box;
    }
}

