/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode;

import java.util.NoSuchElementException;
import java.util.Vector;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.mindmapmode.AddStyleAttributes;
import org.freeplane.features.attribute.mindmapmode.AssignAttributesAction;
import org.freeplane.features.attribute.mindmapmode.CopyAttributes;
import org.freeplane.features.attribute.mindmapmode.PasteAttributes;
import org.freeplane.features.attribute.mindmapmode.ShowAttributeDialogAction;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.mindmapmode.SetBooleanMapPropertyAction;

public class MAttributeController
extends AttributeController {
    InsertAttributeActor insertAttributeActor;

    public static MAttributeController getController() {
        return (MAttributeController)AttributeController.getController();
    }

    public MAttributeController(ModeController modeController) {
        super(modeController);
        this.createActions();
    }

    public int addAttribute(NodeModel node, Attribute pAttribute) {
        this.createAttributeTableModel(node);
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        int rowCount = attributes.getRowCount();
        this.performInsertRow(attributes, rowCount, pAttribute.getName(), pAttribute.getValue());
        return rowCount;
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new AssignAttributesAction());
        modeController.addAction(new ShowAttributeDialogAction());
        modeController.addAction(new CopyAttributes());
        modeController.addAction(new PasteAttributes());
        modeController.addAction(new AddStyleAttributes());
        modeController.addAction(new SetBooleanMapPropertyAction("show_icon_for_attributes"));
    }

    public int editAttribute(NodeModel pNode, String pName, String pNewValue) {
        this.createAttributeTableModel(pNode);
        Attribute newAttribute = new Attribute(pName, pNewValue);
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(pNode);
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (!pName.equals(attributes.getAttribute(i).getName())) continue;
            if (pNewValue != null) {
                this.setAttribute(pNode, i, newAttribute);
            } else {
                this.removeAttribute(pNode, i);
            }
            return i;
        }
        if (pNewValue == null) {
            return -1;
        }
        return this.addAttribute(pNode, newAttribute);
    }

    public void performInsertRow(NodeAttributeTableModel model, int row, String name, Object value) {
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry attributes = AttributeRegistry.getRegistry(map);
        if (name.equals("")) {
            return;
        }
        try {
            AttributeRegistryElement element = attributes.getElement((Comparable<?>)((Object)name));
            int index = element.getValues().getIndexOf(value);
            if (index == -1) {
                if (element.isRestricted()) {
                    value = element.getValues().firstElement().toString();
                } else {
                    RegistryAttributeValueActor actor = new RegistryAttributeValueActor(element, value, false);
                    Controller.getCurrentModeController().execute(actor, map);
                }
            }
        }
        catch (NoSuchElementException ex) {
            AttributeRegistry registry = AttributeRegistry.getRegistry(map);
            RegistryAttributeActor nameActor = new RegistryAttributeActor(name, false, false, registry, map);
            Controller.getCurrentModeController().execute(nameActor, map);
            AttributeRegistryElement element = registry.getElement((Comparable<?>)((Object)name));
            RegistryAttributeValueActor valueActor = new RegistryAttributeValueActor(element, value, false);
            Controller.getCurrentModeController().execute(valueActor, map);
        }
        Object newValue = value;
        InsertAttributeActor actor = new InsertAttributeActor(model, row, name, newValue);
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void performRegistryAttribute(String name) {
        if (name.equals("")) {
            return;
        }
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
        try {
            attributeRegistry.getElement((Comparable<?>)((Object)name));
        }
        catch (NoSuchElementException ex) {
            RegistryAttributeActor actor = new RegistryAttributeActor(name, true, false, attributeRegistry, map);
            Controller.getCurrentModeController().execute(actor, map);
            return;
        }
    }

    public void performRegistryAttributeValue(String name, String value, boolean manual) {
        if (name.equals("")) {
            return;
        }
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
        try {
            AttributeRegistryElement element = attributeRegistry.getElement((Comparable<?>)((Object)name));
            if (element.getValues().contains(value)) {
                return;
            }
            RegistryAttributeValueActor actor = new RegistryAttributeValueActor(element, value, manual);
            Controller.getCurrentModeController().execute(actor, map);
            return;
        }
        catch (NoSuchElementException ex) {
            RegistryAttributeActor nameActor = new RegistryAttributeActor(name, true, false, attributeRegistry, map);
            Controller.getCurrentModeController().execute(nameActor, map);
            AttributeRegistryElement element = attributeRegistry.getElement((Comparable<?>)((Object)name));
            RegistryAttributeValueActor valueActor = new RegistryAttributeValueActor(element, value, false);
            Controller.getCurrentModeController().execute(valueActor, map);
            return;
        }
    }

    public void performRegistrySubtreeAttributes(NodeModel node) {
        NodeAttributeTableModel nodeAttributeTableModel = NodeAttributeTableModel.getModel(node);
        for (int i = 0; i < nodeAttributeTableModel.getRowCount(); ++i) {
            String name = nodeAttributeTableModel.getValueAt(i, 0).toString();
            String value = nodeAttributeTableModel.getValueAt(i, 1).toString();
            this.performRegistryAttributeValue(name, value, false);
        }
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            this.performRegistrySubtreeAttributes(child);
        }
    }

    public void performRemoveAttribute(String name) {
        AttributeRemover remover = new AttributeRemover(name);
        Iterator iterator = new Iterator(remover);
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel root = modeController.getMapController().getRootNode();
        iterator.iterate(root);
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
        UnregistryAttributeActor actor = new UnregistryAttributeActor(name, attributeRegistry, map);
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void performRemoveAttributeValue(String name, String value) {
        AttributeValueRemover remover = new AttributeValueRemover(name, value);
        Iterator iterator = new Iterator(remover);
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel root = modeController.getMapController().getRootNode();
        iterator.iterate(root);
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
        UnregistryAttributeValueActor unregistryActor = new UnregistryAttributeValueActor(attributeRegistry.getElement((Comparable<?>)((Object)name)), value);
        Controller.getCurrentModeController().execute(unregistryActor, map);
    }

    public Attribute performRemoveRow(NodeAttributeTableModel model, int row) {
        Vector<Attribute> attributes = model.getAttributes();
        Attribute o = attributes.elementAt(row);
        RemoveAttributeActor actor = new RemoveAttributeActor(model, row);
        Controller.getCurrentModeController().execute(actor, model.getNode().getMap());
        return o;
    }

    public void performReplaceAtributeName(String oldName, String newName) {
        if (oldName.equals("") || newName.equals("") || oldName.equals(newName)) {
            return;
        }
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry registry = AttributeRegistry.getRegistry(map);
        int iOld = registry.getElements().indexOf((Comparable)((Object)oldName));
        AttributeRegistryElement oldElement = registry.getElement(iOld);
        SortedComboBoxModel values = oldElement.getValues();
        RegistryAttributeActor registryActor = new RegistryAttributeActor(newName, oldElement.isManual(), oldElement.isVisible(), registry, map);
        Controller.getCurrentModeController().execute(registryActor, map);
        AttributeRegistryElement newElement = registry.getElement((Comparable<?>)((Object)newName));
        for (int i = 0; i < values.getSize(); ++i) {
            RegistryAttributeValueActor registryValueActor = new RegistryAttributeValueActor(newElement, values.getElementAt(i).toString(), false);
            Controller.getCurrentModeController().execute(registryValueActor, map);
        }
        AttributeRenamer replacer = new AttributeRenamer(oldName, newName);
        Iterator iterator = new Iterator(replacer);
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel root = modeController.getMapController().getRootNode();
        iterator.iterate(root);
        UnregistryAttributeActor unregistryActor = new UnregistryAttributeActor(oldName, registry, map);
        Controller.getCurrentModeController().execute(unregistryActor, map);
    }

    public void performReplaceAttributeValue(String name, String oldValue, String newValue) {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        ModeController modeController = controller.getModeController();
        AttributeRegistry registry = AttributeRegistry.getRegistry(map);
        ReplaceAttributeValueActor actor = new ReplaceAttributeValueActor(registry, name, oldValue, newValue);
        Controller.getCurrentModeController().execute(actor, map);
        AttributeChanger replacer = new AttributeChanger(name, oldValue, newValue);
        Iterator iterator = new Iterator(replacer);
        NodeModel root = modeController.getMapController().getRootNode();
        iterator.iterate(root);
    }

    public void performSetColumnWidth(NodeAttributeTableModel model, int col, int width) {
        int oldWidth = model.getLayout().getColumnWidth(col);
        if (width == oldWidth) {
            return;
        }
        SetAttributeColumnWidthActor actor = new SetAttributeColumnWidthActor(col, oldWidth, width, model);
        Controller.getCurrentModeController().execute(actor, model.getNode().getMap());
    }

    public void performSetFontSize(AttributeRegistry registry, final int size) {
        final int oldSize = registry.getFontSize();
        if (size == oldSize) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                MapModel map = Controller.getCurrentModeController().getController().getMap();
                AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
                attributeRegistry.setFontSize(size);
            }

            public String getDescription() {
                return "SetAttributeFontSizeActor";
            }

            public void undo() {
                MapModel map = Controller.getCurrentModeController().getController().getMap();
                AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
                attributeRegistry.setFontSize(oldSize);
            }
        };
        Controller.getCurrentModeController().execute(actor, Controller.getCurrentModeController().getController().getMap());
    }

    public void performSetRestriction(int index, boolean isRestricted) {
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry registry = AttributeRegistry.getRegistry(map);
        boolean currentValue = index == -1 ? registry.isRestricted() : registry.getElement(index).isRestricted();
        if (currentValue == isRestricted) {
            return;
        }
        SetAttributeRestrictedActor actor = new SetAttributeRestrictedActor(registry, index, isRestricted);
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void performSetValueAt(NodeAttributeTableModel model, Object o, int row, int col) {
        Attribute attribute = model.getAttribute(row);
        MapModel map = model.getNode().getMap();
        AttributeRegistry registry = AttributeRegistry.getRegistry(map);
        switch (col) {
            case 0: {
                String name = o.toString().trim();
                String oldName = attribute.getName();
                if (oldName.equals(name)) {
                    return;
                }
                SetAttributeNameActor nameActor = new SetAttributeNameActor(model, name, oldName, row);
                Controller.getCurrentModeController().execute(nameActor, map);
                try {
                    AttributeRegistryElement element = registry.getElement((Comparable<?>)((Object)name));
                    String value = model.getValueAt(row, 1).toString();
                    int index = element.getValues().getIndexOf(value);
                    if (index != -1) break;
                    SetAttributeValueActor valueActor = new SetAttributeValueActor(model, row, element.getValues().firstElement());
                    Controller.getCurrentModeController().execute(valueActor, map);
                }
                catch (NoSuchElementException ex) {
                    RegistryAttributeActor registryActor = new RegistryAttributeActor(name, false, false, registry, map);
                    Controller.getCurrentModeController().execute(registryActor, map);
                }
                break;
            }
            case 1: {
                if (attribute.getValue().equals(o)) {
                    return;
                }
                SetAttributeValueActor actor = new SetAttributeValueActor(model, row, o);
                Controller.getCurrentModeController().execute(actor, map);
                String name = model.getValueAt(row, 0).toString();
                AttributeRegistryElement element = registry.getElement((Comparable<?>)((Object)name));
                int index = element.getValues().getIndexOf(o);
                if (index != -1) break;
                RegistryAttributeValueActor registryActor = new RegistryAttributeValueActor(element, o, false);
                Controller.getCurrentModeController().execute(registryActor, map);
                break;
            }
        }
    }

    public void performSetVisibility(int index, boolean isVisible) {
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        AttributeRegistry attributeRegistry = AttributeRegistry.getRegistry(map);
        if (attributeRegistry.getElement(index).isVisible() == isVisible) {
            return;
        }
        SetAttributeVisibleActor actor = new SetAttributeVisibleActor(attributeRegistry, index, isVisible);
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void removeAttribute(NodeModel pNode, int pPosition) {
        this.createAttributeTableModel(pNode);
        this.performRemoveRow(NodeAttributeTableModel.getModel(pNode), pPosition);
    }

    public void setAttribute(NodeModel pNode, int pPosition, Attribute pAttribute) {
        this.createAttributeTableModel(pNode);
        NodeAttributeTableModel model = NodeAttributeTableModel.getModel(pNode);
        this.performSetValueAt(model, pAttribute.getName(), pPosition, 0);
        this.performSetValueAt(model, pAttribute.getValue(), pPosition, 1);
    }

    public void copyAttributesToNode(NodeModel source, NodeModel target) {
        if (source == null) {
            return;
        }
        NodeAttributeTableModel model = NodeAttributeTableModel.getModel(source);
        if (model.getRowCount() == 0) {
            return;
        }
        int attributeTableLength = model.getAttributeTableLength();
        for (int i = 0; i < attributeTableLength; ++i) {
            Attribute attribute = model.getAttribute(i);
            this.addAttribute(target, new Attribute(attribute.getName(), attribute.getValue()));
        }
    }

    public boolean canEdit() {
        return true;
    }

    private static class UnregistryAttributeValueActor
    implements IActor {
        private final RegistryAttributeValueActor registryActor;

        private UnregistryAttributeValueActor(AttributeRegistryElement element, String newValue) {
            this.registryActor = new RegistryAttributeValueActor(element, newValue, element.isManual());
        }

        public void act() {
            this.registryActor.undo();
        }

        public String getDescription() {
            return "UnregistryAttributeValueActor";
        }

        public void undo() {
            this.registryActor.act();
        }
    }

    private static class UnregistryAttributeActor
    implements IActor {
        private final RegistryAttributeActor registryActor;

        private UnregistryAttributeActor(String name, AttributeRegistry registry, MapModel map) {
            this.registryActor = new RegistryAttributeActor(name, registry.getElement((Comparable<?>)((Object)name)).isManual(), registry.getElement((Comparable<?>)((Object)name)).isVisible(), registry, map);
        }

        public void act() {
            this.registryActor.undo();
        }

        public String getDescription() {
            return "UnregistryAttributeActor";
        }

        public void undo() {
            this.registryActor.act();
        }
    }

    private static class SetAttributeVisibleActor
    implements IActor {
        private final AttributeRegistry attributeRegistry;
        private final int index;
        private final boolean isVisible;

        private SetAttributeVisibleActor(AttributeRegistry attributeRegistry, int index, boolean isVisible) {
            this.attributeRegistry = attributeRegistry;
            this.index = index;
            this.isVisible = isVisible;
        }

        public void act() {
            this.act(this.isVisible);
        }

        private void act(boolean isVisible) {
            this.attributeRegistry.getElement(this.index).setVisibility(isVisible);
            this.attributeRegistry.fireStateChanged();
        }

        public String getDescription() {
            return "SetAttributeVisibleActor";
        }

        public void undo() {
            this.act(!this.isVisible);
        }
    }

    private static final class SetAttributeValueActor
    implements IActor {
        private final NodeAttributeTableModel model;
        private final Object newValue;
        private final Object oldValue;
        private final int row;

        private SetAttributeValueActor(NodeAttributeTableModel model, int row, Object newValue) {
            this.row = row;
            this.oldValue = model.getAttribute(row).getValue();
            this.newValue = newValue;
            this.model = model;
        }

        public void act() {
            this.model.getAttribute(this.row).setValue(this.newValue);
            this.model.fireTableCellUpdated(this.row, 1);
        }

        public String getDescription() {
            return "SetAttributeValue";
        }

        public void undo() {
            this.model.getAttribute(this.row).setValue(this.oldValue);
            this.model.fireTableCellUpdated(this.row, 1);
        }
    }

    private static class SetAttributeRestrictedActor
    implements IActor {
        private final int index;
        private final boolean isRestricted;
        private final AttributeRegistry registry;

        private SetAttributeRestrictedActor(AttributeRegistry registry, int index, boolean isRestricted) {
            this.registry = registry;
            this.index = index;
            this.isRestricted = isRestricted;
        }

        public void act() {
            this.act(this.isRestricted);
        }

        public void act(boolean isRestricted) {
            if (this.index == -1) {
                this.registry.setRestricted(isRestricted);
            } else {
                this.registry.getElement(this.index).setRestriction(isRestricted);
            }
        }

        public String getDescription() {
            return "SetAttributeRestrictedActor";
        }

        public void undo() {
            this.act(!this.isRestricted);
        }
    }

    private static class SetAttributeNameActor
    implements IActor {
        private final NodeAttributeTableModel model;
        private final String name;
        private final String oldName;
        private final int row;

        private SetAttributeNameActor(NodeAttributeTableModel model, String name, String oldName, int row) {
            this.model = model;
            this.name = name;
            this.oldName = oldName;
            this.row = row;
        }

        public void act() {
            this.model.getAttribute(this.row).setName(this.name);
            this.model.fireTableCellUpdated(this.row, 0);
        }

        public String getDescription() {
            return "setAttributeName";
        }

        public void undo() {
            this.model.getAttribute(this.row).setName(this.oldName);
            this.model.fireTableCellUpdated(this.row, 0);
        }
    }

    private static class SetAttributeColumnWidthActor
    implements IActor {
        private final int col;
        private final NodeAttributeTableModel model;
        private final int oldWidth;
        private final int width;

        private SetAttributeColumnWidthActor(int col, int oldWidth, int width, NodeAttributeTableModel model) {
            this.col = col;
            this.oldWidth = oldWidth;
            this.width = width;
            this.model = model;
        }

        public void act() {
            this.model.getLayout().setColumnWidth(this.col, this.width);
        }

        public String getDescription() {
            return "SetAttributeColumnWidthActor";
        }

        public void undo() {
            this.model.getLayout().setColumnWidth(this.col, this.oldWidth);
        }
    }

    private static class ReplaceAttributeValueActor
    implements IActor {
        private final String name;
        private final String newValue;
        private final String oldValue;
        private final AttributeRegistry registry;

        private ReplaceAttributeValueActor(AttributeRegistry registry, String name, String oldValue, String newValue) {
            this.registry = registry;
            this.name = name;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void act() {
            this.registry.getElement((Comparable<?>)((Object)this.name)).replaceValue(this.oldValue, this.newValue);
        }

        public String getDescription() {
            return "ReplaceAttributeValueActor";
        }

        public void undo() {
            this.registry.getElement((Comparable<?>)((Object)this.name)).replaceValue(this.newValue, this.oldValue);
        }
    }

    private class RemoveAttributeActor
    implements IActor {
        private final InsertAttributeActor insertActor;

        private RemoveAttributeActor(NodeAttributeTableModel model, int row) {
            Attribute attribute = model.getAttribute(row);
            String name = attribute.getName();
            Object value = attribute.getValue();
            this.insertActor = new InsertAttributeActor(model, row, name, value);
        }

        public void act() {
            this.insertActor.undo();
        }

        public String getDescription() {
            return "RemoveAttributeActor";
        }

        public void undo() {
            this.insertActor.act();
        }
    }

    private static class RegistryAttributeValueActor
    implements IActor {
        private final AttributeRegistryElement element;
        private final Object newValue;
        private final boolean setManual;
        private final boolean wasManual;

        private RegistryAttributeValueActor(AttributeRegistryElement element, Object newValue, boolean setManual) {
            this.element = element;
            this.newValue = newValue;
            this.setManual = setManual;
            this.wasManual = element.isManual();
        }

        public void act() {
            if (this.newValue != null) {
                this.element.addValue(this.newValue);
                if (this.setManual) {
                    this.element.setManual(true);
                }
            }
        }

        public String getDescription() {
            return "RegistryAttributeValueActor";
        }

        public void undo() {
            if (this.newValue != null) {
                this.element.removeValue(this.newValue);
                if (this.setManual & !this.wasManual) {
                    this.element.setManual(false);
                }
            }
        }
    }

    private static class RegistryAttributeActor
    implements IActor {
        private final boolean manual;
        private final MapModel map;
        private final String name;
        private final AttributeRegistry registry;
        private final boolean visible;

        private RegistryAttributeActor(String name, boolean manual, boolean visible, AttributeRegistry registry, MapModel map) {
            this.name = name;
            this.registry = registry;
            this.manual = manual;
            this.visible = visible;
            this.map = map;
        }

        public void act() {
            AttributeRegistryElement attributeRegistryElement = new AttributeRegistryElement(this.registry, this.name);
            attributeRegistryElement.setManual(this.manual);
            attributeRegistryElement.setVisibility(this.visible);
            int index = this.registry.getElements().add((Comparable)((Object)this.name), attributeRegistryElement);
            this.registry.getTableModel().fireTableRowsInserted(index, index);
            if (this.manual || this.visible) {
                ModeController modeController = Controller.getCurrentModeController();
                modeController.getMapController().setSaved(this.map, false);
            }
        }

        public String getDescription() {
            return "RegistryAttributeActor";
        }

        public void undo() {
            this.registry.unregistry(this.name);
            if (this.manual) {
                ModeController modeController = Controller.getCurrentModeController();
                modeController.getMapController().setSaved(this.map, false);
            }
        }
    }

    private static interface IVisitor {
        public void visit(NodeAttributeTableModel var1);
    }

    private class Iterator {
        private final IVisitor visitor;

        Iterator(IVisitor v) {
            this.visitor = v;
        }

        void iterate(NodeModel node) {
            this.visitor.visit(NodeAttributeTableModel.getModel(node));
            for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
                this.iterate(child);
            }
        }
    }

    private class InsertAttributeActor
    implements IActor {
        private final NodeAttributeTableModel model;
        private final String name;
        private final int row;
        private final Object value;

        private InsertAttributeActor(NodeAttributeTableModel model, int row, String name, Object value) {
            this.row = row;
            this.name = name;
            this.model = model;
            this.value = value;
        }

        public void act() {
            Attribute newAttribute = new Attribute(this.name, this.value);
            this.model.getAttributes().add(this.row, newAttribute);
            this.model.fireTableRowsInserted(this.row, this.row);
        }

        public String getDescription() {
            return "InsertAttributeActor";
        }

        public void undo() {
            this.model.getAttributes().remove(this.row);
            this.model.fireTableRowsDeleted(this.row, this.row);
        }
    }

    private class AttributeValueRemover
    implements IVisitor {
        private final Object name;
        private final Object value;

        public AttributeValueRemover(Object name, Object value) {
            this.name = name;
            this.value = value;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name) || !model.getValue(i).equals(this.value)) continue;
                RemoveAttributeActor actor = new RemoveAttributeActor(model, i);
                Controller.getCurrentModeController().execute(actor, model.getNode().getMap());
            }
        }
    }

    private class AttributeRenamer
    implements IVisitor {
        private final Object newName;
        private final Object oldName;

        public AttributeRenamer(Object oldName, Object newName) {
            this.newName = newName;
            this.oldName = oldName;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.oldName)) continue;
                int row = i;
                String name = this.newName.toString();
                String oldName = this.oldName.toString();
                SetAttributeNameActor actor = new SetAttributeNameActor(model, name, oldName, row);
                Controller.getCurrentModeController().execute(actor, model.getNode().getMap());
            }
        }
    }

    private class AttributeRemover
    implements IVisitor {
        private final Object name;

        public AttributeRemover(Object name) {
            this.name = name;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name)) continue;
                int row = i;
                RemoveAttributeActor actor = new RemoveAttributeActor(model, row);
                Controller.getCurrentModeController().execute(actor, model.getNode().getMap());
            }
        }
    }

    private class AttributeChanger
    implements IVisitor {
        private final Object name;
        private final Object newValue;
        private final Object oldValue;

        public AttributeChanger(Object name, Object oldValue, Object newValue) {
            this.name = name;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void visit(NodeAttributeTableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getName(i).equals(this.name) || !model.getValue(i).equals(this.oldValue)) continue;
                int row = i;
                SetAttributeValueActor actor = new SetAttributeValueActor(model, row, this.newValue);
                Controller.getCurrentModeController().execute(actor, model.getNode().getMap());
            }
        }
    }
}

