/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.IListModel;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.mindmapmode.AttributeRegistryTable;
import org.freeplane.features.attribute.mindmapmode.ImportAttributesDialog;
import org.freeplane.features.attribute.mindmapmode.ListDialog;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class AttributeManagerDialog
extends JDialog
implements IMapSelectionListener {
    static final Icon editButtonImage = new ImageIcon(ResourceController.getResourceController().getResource("/images/edit12.png"));
    private static final String[] fontSizes = new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "24"};
    private static final long serialVersionUID = 1L;
    private ImportAttributesDialog importDialog = null;
    private AttributeRegistry model;
    private final JComboBox size;
    private final JTable view;

    public AttributeManagerDialog(Frame frame) {
        super(frame, TextUtils.getText("attributes_dialog_title"), true);
        Controller controller = Controller.getCurrentController();
        this.view = new AttributeRegistryTable(new EditListAction());
        this.model = AttributeRegistry.getRegistry(controller.getMap());
        this.view.setModel(this.model.getTableModel());
        this.view.getSelectionModel().setSelectionMode(0);
        this.view.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.view);
        this.getContentPane().add((Component)scrollPane, "Center");
        Box southButtons = Box.createHorizontalBox();
        southButtons.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)southButtons, "South");
        southButtons.add(Box.createHorizontalGlue());
        JButton ok = new JButton(new OKAction());
        southButtons.add(ok);
        southButtons.add(Box.createHorizontalGlue());
        JButton apply = new JButton(new ApplyAction());
        southButtons.add(apply);
        southButtons.add(Box.createHorizontalGlue());
        JButton cancel = new JButton(new CancelAction());
        southButtons.add(cancel);
        southButtons.add(Box.createHorizontalGlue());
        this.size = new JComboBox<String>(fontSizes);
        this.size.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AttributeManagerDialog.this.model.setAttributeLayoutChanged();
            }
        });
        this.size.setToolTipText(TextUtils.getText("attribute_font_size_tooltip"));
        southButtons.add(this.size);
        southButtons.add(Box.createHorizontalGlue());
        JButton importBtn = new JButton(new ImportAction());
        importBtn.setToolTipText(TextUtils.getText("attributes_import_tooltip"));
        southButtons.add(importBtn);
        southButtons.add(Box.createHorizontalGlue());
        UITools.addEscapeActionToDialog(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ClosingListener());
        controller.getMapViewManager().addMapSelectionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                AttributeManagerDialog.this.size.setSelectedItem(Integer.toString(AttributeManagerDialog.this.model.getFontSize()));
            }
        });
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        if (newMap != null) {
            this.model = AttributeRegistry.getRegistry(newMap);
            if (this.model != null) {
                this.view.setModel(this.model.getTableModel());
            } else {
                this.setVisible(false);
            }
        }
    }

    private void applyChanges() {
        Object size = this.size.getSelectedItem();
        int iSize = Integer.parseInt(size.toString());
        this.model.getAttributeController().performSetFontSize(this.model, iSize);
        this.model.applyChanges();
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        modeController.delayedCommit();
        MapController mapController = modeController.getMapController();
        MapModel map = Controller.getCurrentController().getMap();
        assert (AttributeRegistry.getRegistry(map) == this.model);
        mapController.setSaved(map, false);
    }

    public void beforeMapChange(MapModel oldMap, MapModel newMap) {
    }

    private void resetChanges() {
        int iSize = this.model.getFontSize();
        this.size.setSelectedItem(Integer.toString(iSize));
        this.model.resetChanges();
        Controller.getCurrentModeController().rollback();
    }

    public void show() {
        Controller.getCurrentModeController().startTransaction();
        super.show();
    }

    private class OKAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        OKAction() {
            super("OKAction");
        }

        public void actionPerformed(ActionEvent e) {
            AttributeManagerDialog.this.applyChanges();
            AttributeManagerDialog.this.setVisible(false);
        }
    }

    private class ImportAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        ImportAction() {
            super("ImportAction");
        }

        public void actionPerformed(ActionEvent e) {
            if (AttributeManagerDialog.this.importDialog == null) {
                AttributeManagerDialog.this.importDialog = new ImportAttributesDialog((Component)AttributeManagerDialog.this);
            }
            AttributeManagerDialog.this.importDialog.show();
        }
    }

    class EditListAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String labelText;
        private IListModel listBoxModel;
        private int row;
        private String title;

        public EditListAction() {
            super(null, editButtonImage);
            this.row = 0;
        }

        public void actionPerformed(ActionEvent e) {
            ListDialog.showDialog((Component)e.getSource(), AttributeManagerDialog.this, this.labelText, this.title, this.listBoxModel, "xxxxxxxxxxxxxxxxxxxxx");
        }

        public int getRow() {
            return this.row;
        }

        public void setListBoxModel(String title, String labelText, IListModel listBoxModel) {
            this.title = title;
            this.labelText = labelText;
            this.listBoxModel = listBoxModel;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }

    private class ClosingListener
    extends WindowAdapter {
        private ClosingListener() {
        }

        public void windowClosing(WindowEvent e) {
            AttributeManagerDialog.this.resetChanges();
            super.windowClosing(e);
            AttributeManagerDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        CancelAction() {
            super("CancelAction");
        }

        public void actionPerformed(ActionEvent e) {
            AttributeManagerDialog.this.resetChanges();
            AttributeManagerDialog.this.setVisible(false);
        }
    }

    private class ApplyAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        ApplyAction() {
            super("ApplyAction");
        }

        public void actionPerformed(ActionEvent e) {
            AttributeManagerDialog.this.applyChanges();
            Controller.getCurrentModeController().startTransaction();
        }
    }
}

