/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.openmaps.mapelements;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Set;
import org.freeplane.plugin.openmaps.LocationChoosenListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class OpenMapsController
extends DefaultMapController
implements MouseListener {
    private Set<LocationChoosenListener> Listeners;
    private int locationCount;

    public OpenMapsController(JMapViewer map) {
        super(map);
        this.configureButtons();
        this.Listeners = new HashSet<LocationChoosenListener>();
        this.locationCount = 0;
    }

    private void configureButtons() {
        this.setDoubleClickZoomEnabled(false);
        this.setMovementMouseButton(1);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            Coordinate locationChoosen = this.getSelectedLocation(e.getPoint());
            if (this.locationCount < 1) {
                this.addMarkerToLocation(locationChoosen);
                ++this.locationCount;
            }
            this.sendLocation(locationChoosen, this.getCurrentZoomLevel());
        }
    }

    public void addLocationChoosenListener(LocationChoosenListener listener) {
        this.Listeners.add(listener);
    }

    public void removeLocationChoosenListener(LocationChoosenListener listener) {
        this.Listeners.remove(listener);
    }

    private void sendLocation(Coordinate locationChoosen, int zoom) {
        for (LocationChoosenListener l : this.Listeners) {
            l.locationChoosenAction(locationChoosen, zoom);
        }
    }

    public Coordinate getSelectedLocation(Point clickedLocation) {
        return this.map.getPosition(clickedLocation);
    }

    public int getCurrentZoomLevel() {
        return this.map.getZoom();
    }

    private void addMarkerToLocation(Coordinate locationChoosen) {
        this.map.addMapMarker((MapMarker)new MapMarkerDot(locationChoosen.getLat(), locationChoosen.getLon()));
    }

    public void zoomToLocation(Coordinate location, int zoom) {
        if (this.locationCount == 0) {
            this.addMarkerToLocation(location);
            ++this.locationCount;
        }
        this.map.setDisplayPositionByLatLon(new Point(this.map.getWidth() / 2, this.map.getHeight() / 2), location.getLat(), location.getLon(), zoom);
    }
}

