/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import java.util.List;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.plugin.script.FormulaUtils;

public class FormulaUpdateChangeListener
implements INodeChangeListener,
IMapChangeListener {
    public void nodeChanged(NodeChangeEvent event) {
        Object property = event.getProperty();
        if ("node_text".equals(property) || NodeAttributeTableModel.class.equals(property) || "note_text".equals(property) || "icon".equals(property) || LogicalStyleModel.class.equals(property) || DetailTextModel.class.equals(property)) {
            this.nodeChangedImpl(false, event.getNode());
        }
    }

    public void onNodeDeleted(NodeModel parent, NodeModel child, int index) {
        this.nodeChangedImpl(true, parent);
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        this.nodeChangedImpl(true, parent);
    }

    public void onNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
        this.nodeChangedImpl(true, oldParent, newParent);
    }

    public void onPreNodeMoved(NodeModel oldParent, int oldIndex, NodeModel newParent, NodeModel child, int newIndex) {
    }

    public void onPreNodeDelete(NodeModel oldParent, NodeModel selectedNode, int index) {
    }

    public void mapChanged(MapChangeEvent event) {
        if ("map_url".equals(event.getProperty())) {
            FormulaUtils.clearCache((MapModel)event.getMap());
        }
    }

    private void nodeChangedImpl(boolean includeChanged, NodeModel ... nodes) {
        ModeController modeController = Controller.getCurrentModeController();
        List dependencies = FormulaUtils.manageChangeAndReturnDependencies((boolean)includeChanged, (NodeModel[])nodes);
        for (NodeModel dependentNode : dependencies) {
            modeController.getMapController().delayedNodeRefresh(dependentNode, IContentTransformer.class, null, null);
        }
    }
}

