/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.JEditorPane;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.FormattedFormula;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.plugin.formula.FormulaEditor;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FormulaUtils;

class FormulaTextTransformer
extends AbstractContentTransformer
implements IEditBaseCreator {
    FormulaTextTransformer(int priority) {
        super(priority);
    }

    public Object transformContent(TextController textController, Object obj, NodeModel node, Object transformedExtension) {
        if (obj instanceof FormattedFormula) {
            FormattedFormula formattedFormula = (FormattedFormula)obj;
            Object evaluationResult = this.transformContent(textController, formattedFormula.getObject(), node, transformedExtension);
            return new FormattedObject(evaluationResult, formattedFormula.getPattern());
        }
        if (!(obj instanceof String)) {
            return obj;
        }
        if (textController.isTextFormattingDisabled(node)) {
            return obj;
        }
        String text = obj.toString();
        if (!FormulaUtils.containsFormulaCheckHTML((String)text)) {
            return obj;
        }
        String plainText = HtmlUtils.htmlToPlain((String)text);
        Object result = FormulaUtils.evalIfScript((NodeModel)node, null, (String)plainText);
        if (result == null) {
            throw new ExecuteScriptException("got null result from evaluating " + node.getID() + ", text='" + plainText.substring(1) + "'");
        }
        return result;
    }

    public EditNodeBase createEditor(NodeModel node, EditNodeBase.IEditControl editControl, String text, boolean editLong) {
        MTextController textController = MTextController.getController();
        if (textController.isTextFormattingDisabled(node)) {
            return null;
        }
        KeyEvent firstKeyEvent = textController.getEventQueue().getFirstEvent();
        if (firstKeyEvent != null) {
            if (firstKeyEvent.getKeyChar() == '=') {
                text = "=";
            } else {
                return null;
            }
        }
        if (text.startsWith("=")) {
            JEditorPane textEditor = new JEditorPane();
            textEditor.putClientProperty("JEditorPane.honorDisplayProperties", true);
            JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane((Component)textEditor);
            scrollPane.setMinimumSize(new Dimension(0, 60));
            FormulaEditor editNodeDialog = new FormulaEditor(node, text, firstKeyEvent, editControl, false, textEditor);
            editNodeDialog.setTitle(TextUtils.getText((String)"formula_editor"));
            textEditor.setContentType("text/groovy");
            return editNodeDialog;
        }
        return null;
    }

    public boolean markTransformation() {
        return true;
    }
}

