/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.launcher;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.knopflerfish.framework.Main;

public class Launcher {
    private File frameworkDir = this.getPathToJar();
    private int argCount = 0;

    public static void main(String[] args) {
        new Launcher().launch(args);
    }

    private void launch(String[] args) {
        this.setDefines();
        this.setArgProperties(args);
        this.run();
    }

    private void setDefines() {
        this.setDefine("org.knopflerfish.framework.bundlestorage", "memory");
        this.setDefine("org.knopflerfish.gosg.jars", "reference:file:" + this.getAbsolutePath("core") + '/');
        if (this.isDefineNotSet("org.freeplane.globalresourcedir")) {
            this.setDefine("org.freeplane.globalresourcedir", this.getAbsolutePath("resources"));
        }
    }

    private boolean isDefineNotSet(String name) {
        return System.getProperty(name, null) == null;
    }

    private String setDefine(String name, String value) {
        return System.setProperty(name, value);
    }

    private void run() {
        String[] args = new String[]{"-xargs", this.getAbsolutePath("props.xargs"), "-xargs", this.getAbsolutePath("init.xargs")};
        Main.main(args);
    }

    private String getAbsolutePath(String relativePath) {
        return new File(this.frameworkDir, relativePath).getAbsolutePath();
    }

    private File getPathToJar() {
        URL frameworkUrl = Main.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return new File(frameworkUrl.toURI()).getAbsoluteFile().getParentFile();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void setArgProperties(String[] args) {
        for (String arg : args) {
            this.setArgumentProperty(arg);
        }
    }

    private void setArgumentProperty(String arg) {
        String propertyName = "org.freeplane.param" + ++this.argCount;
        System.setProperty(propertyName, arg);
    }
}

