/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URI;
import javax.swing.JComponent;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ViewerLayoutManager;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGSVGElement;

public class SvgViewerFactory
implements IViewerFactory {
    public boolean accept(URI uri) {
        return uri.getRawPath().endsWith(".svg");
    }

    public String getDescription() {
        return TextUtils.getText((String)"svg");
    }

    public JComponent createViewer(final ExternalResource resource, URI uri, final int maximumWidth) {
        final ViewerComponent canvas = new ViewerComponent(uri);
        canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                Dimension preferredSize = canvas.getOriginalSize();
                float r = resource.getZoom();
                int originalWidth = preferredSize.width;
                if (r == -1.0f) {
                    r = resource.setZoom(originalWidth, maximumWidth);
                }
                preferredSize.width = (int)Math.rint((float)originalWidth * r);
                preferredSize.height = (int)Math.rint((float)preferredSize.height * r);
                canvas.setPreferredSize(preferredSize);
                canvas.setLayout((LayoutManager)new ViewerLayoutManager(1.0f));
                canvas.revalidate();
                canvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
            }
        });
        return canvas;
    }

    public JComponent createViewer(URI uri, final Dimension preferredSize) {
        final ViewerComponent canvas = new ViewerComponent(uri);
        canvas.setPreferredSize(preferredSize);
        canvas.setSize(preferredSize);
        canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                canvas.setMySize(preferredSize);
                canvas.setSize(preferredSize);
                canvas.revalidate();
                canvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
            }
        });
        return canvas;
    }

    public Dimension getOriginalSize(JComponent viewer) {
        ViewerComponent canvas = (ViewerComponent)((Object)viewer);
        return canvas.getOriginalSize();
    }

    public void setFinalViewerSize(JComponent viewer, Dimension size) {
        JSVGCanvas canvas = (JSVGCanvas)viewer;
        canvas.setMySize(size);
    }

    public void setDraftViewerSize(JComponent viewer, Dimension size) {
        this.setFinalViewerSize(viewer, size);
    }

    private final class ViewerComponent
    extends JSVGCanvas {
        private static final long serialVersionUID = 1L;
        private Dimension originalSize;

        protected Dimension getOriginalSize() {
            return new Dimension(this.originalSize);
        }

        public ViewerComponent(URI uri) {
            super(null, false, false);
            this.originalSize = null;
            this.setDocumentState(2);
            this.setSize(1, 1);
            this.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                public void gvtRenderingStarted(GVTTreeRendererEvent e) {
                    super.gvtRenderingStarted(e);
                    SVGDocument document = ViewerComponent.this.getSVGDocument();
                    SVGSVGElement rootElement = document.getRootElement();
                    SVGLength width = rootElement.getWidth().getBaseVal();
                    SVGLength height = rootElement.getHeight().getBaseVal();
                    float defaultWidth = (float)Math.ceil(width.getValue());
                    float defaultHeigth = (float)Math.ceil(height.getValue());
                    if (defaultWidth == 1.0f && defaultHeigth == 1.0f) {
                        defaultWidth = ResourceController.getResourceController().getIntProperty("default_external_component_width", 200);
                        defaultHeigth = ResourceController.getResourceController().getIntProperty("default_external_component_height", 200);
                    }
                    ViewerComponent.this.originalSize = new Dimension((int)defaultWidth, (int)defaultHeigth);
                    if ("".equals(rootElement.getAttributeNS(null, "viewBox"))) {
                        rootElement.setAttributeNS(null, "viewBox", "0 0 " + defaultWidth + " " + defaultHeigth);
                    }
                    ViewerComponent.this.setSize(ViewerComponent.this.originalSize);
                    ViewerComponent.this.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
                }
            });
            this.setURI(uri.toString());
        }

        public Dimension getPreferredSize() {
            if (this.originalSize == null) {
                return new Dimension(1, 1);
            }
            return super.getPreferredSize();
        }
    }
}

